/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Tagging
implements ToSmithyBuilder<Tagging> {
    private final boolean taggable;
    private final boolean tagOnCreate;
    private final boolean tagUpdatable;
    private final String tagProperty;
    private final boolean cloudFormationSystemTags;

    private Tagging(Builder builder) {
        this.taggable = builder.taggable;
        this.tagOnCreate = builder.tagOnCreate;
        this.tagUpdatable = builder.tagUpdatable;
        this.cloudFormationSystemTags = builder.cloudFormationSystemTags;
        this.tagProperty = builder.tagProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean getTaggable() {
        return this.taggable;
    }

    public boolean getTagOnCreate() {
        return this.tagOnCreate;
    }

    public boolean getTagUpdatable() {
        return this.tagUpdatable;
    }

    public boolean getCloudFormationSystemTags() {
        return this.cloudFormationSystemTags;
    }

    public String getTagProperty() {
        return this.tagProperty;
    }

    public Builder toBuilder() {
        return Tagging.builder().taggable(this.taggable).tagOnCreate(this.tagOnCreate).tagUpdatable(this.tagUpdatable).cloudFormationSystemTags(this.cloudFormationSystemTags).tagProperty(this.tagProperty);
    }

    public static final class Builder
    implements SmithyBuilder<Tagging> {
        private boolean taggable;
        private boolean tagOnCreate;
        private boolean tagUpdatable;
        private boolean cloudFormationSystemTags;
        private String tagProperty;

        public Tagging build() {
            return new Tagging(this);
        }

        public Builder taggable(boolean taggable) {
            this.taggable = taggable;
            return this;
        }

        public Builder tagOnCreate(boolean tagOnCreate) {
            this.tagOnCreate = tagOnCreate;
            return this;
        }

        public Builder tagUpdatable(boolean tagUpdatable) {
            this.tagUpdatable = tagUpdatable;
            return this;
        }

        public Builder cloudFormationSystemTags(boolean cloudFormationSystemTags) {
            this.cloudFormationSystemTags = cloudFormationSystemTags;
            return this;
        }

        public Builder tagProperty(String tagProperty) {
            this.tagProperty = tagProperty;
            return this;
        }
    }
}

