/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceProperty;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class CfnResourcePropertyValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        CfnResourceIndex cfnResourceIndex = CfnResourceIndex.of(model);
        for (ResourceShape resource : model.getResourceShapesWithTrait(CfnResourceTrait.class)) {
            events.addAll(this.validateResource(model, cfnResourceIndex, resource));
        }
        return events;
    }

    private List<ValidationEvent> validateResource(Model model, CfnResourceIndex cfnResourceIndex, ResourceShape resource) {
        Optional<CfnResource> cfnResourceOptional;
        CfnResourceTrait trait = (CfnResourceTrait)resource.expectTrait(CfnResourceTrait.class);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        String resourceName = trait.getName().orElse(resource.getId().getName());
        if (trait.getPrimaryIdentifier().isPresent()) {
            this.validateResourcePrimaryIdentifier(model, resource, trait.getPrimaryIdentifier().get()).ifPresent(events::add);
        }
        if ((cfnResourceOptional = cfnResourceIndex.getResource((ToShapeId)resource)).isPresent()) {
            for (Map.Entry<String, CfnResourceProperty> property : cfnResourceOptional.get().getProperties().entrySet()) {
                this.validateResourceProperty(model, resource, resourceName, property).ifPresent(events::add);
            }
        }
        return events;
    }

    private Optional<ValidationEvent> validateResourcePrimaryIdentifier(Model model, ResourceShape resource, String primaryIdentifier) {
        Map properties = resource.getProperties();
        if (!properties.containsKey(primaryIdentifier)) {
            return Optional.of(this.error((Shape)resource, (FromSourceLocation)resource.expectTrait(CfnResourceTrait.class), String.format("The alternative resource primary identifier, `%s`, must be a property of the resource.", primaryIdentifier)));
        }
        Shape propertyTarget = model.expectShape((ShapeId)properties.get(primaryIdentifier));
        if (!propertyTarget.isStringShape() && !propertyTarget.isEnumShape()) {
            return Optional.of(this.error((Shape)resource, (FromSourceLocation)resource.expectTrait(CfnResourceTrait.class), String.format("The alternative resource primary identifier, `%s`, targets a `%s` shape, it must target a `string`.", primaryIdentifier, propertyTarget.getType())));
        }
        return Optional.empty();
    }

    private Optional<ValidationEvent> validateResourceProperty(Model model, ResourceShape resource, String resourceName, Map.Entry<String, CfnResourceProperty> property) {
        TreeSet propertyTargets = new TreeSet();
        for (ShapeId shapeId : property.getValue().getShapeIds()) {
            model.getShape(shapeId).ifPresent(shape -> OptionalUtils.ifPresentOrElse((Optional)shape.asMemberShape(), memberShape -> propertyTargets.add(memberShape.getTarget()), () -> propertyTargets.add(shapeId)));
        }
        if (propertyTargets.size() > 1) {
            return Optional.of(this.error((Shape)resource, String.format("The `%s` property of the generated `%s` CloudFormation resource targets multiple shapes: %s. Reusing member names that target different shapes can cause confusion for users of the API. This target discrepancy must either be resolved in the model or one of the members must be excluded from the conversion.", property.getKey(), resourceName, propertyTargets)));
        }
        return Optional.empty();
    }
}

