/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceProperty;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CfnResource
implements ToSmithyBuilder<CfnResource> {
    private final Map<String, CfnResourceProperty> propertyDefinitions;
    private final Map<String, CfnResourceProperty> availableProperties;
    private final Set<ShapeId> excludedProperties;
    private final Set<String> primaryIdentifiers;
    private final List<Set<String>> additionalIdentifiers;

    private CfnResource(Builder builder) {
        HashMap<String, CfnResourceProperty> propertyDefinitions = new HashMap<String, CfnResourceProperty>(builder.propertyDefinitions);
        HashMap<String, CfnResourceProperty> availableProperties = new HashMap<String, CfnResourceProperty>();
        this.excludedProperties = Collections.unmodifiableSet(builder.excludedProperties);
        this.primaryIdentifiers = Collections.unmodifiableSet(builder.primaryIdentifiers);
        this.additionalIdentifiers = Collections.unmodifiableList(builder.additionalIdentifiers);
        for (Map.Entry propertyDefinition : propertyDefinitions.entrySet()) {
            for (ShapeId shapeId : ((CfnResourceProperty)propertyDefinition.getValue()).getShapeIds()) {
                if (this.excludedProperties.contains(shapeId)) {
                    CfnResourceProperty updatedDefinition = ((CfnResourceProperty)propertyDefinition.getValue()).toBuilder().removeShapeId(shapeId).build();
                    propertyDefinitions.put((String)propertyDefinition.getKey(), updatedDefinition);
                    if (!availableProperties.containsKey(propertyDefinition.getKey())) continue;
                    availableProperties.put((String)propertyDefinition.getKey(), updatedDefinition);
                    continue;
                }
                availableProperties.put((String)propertyDefinition.getKey(), (CfnResourceProperty)propertyDefinition.getValue());
            }
        }
        this.propertyDefinitions = Collections.unmodifiableMap(propertyDefinitions);
        this.availableProperties = Collections.unmodifiableMap(availableProperties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, CfnResourceProperty> getProperties() {
        return this.availableProperties;
    }

    public Optional<CfnResourceProperty> getProperty(String propertyName) {
        return Optional.ofNullable(this.getProperties().get(propertyName));
    }

    public Set<String> getCreateOnlyProperties() {
        return this.getConstrainedProperties(definition -> {
            Set<CfnResourceIndex.Mutability> mutabilities = definition.getMutabilities();
            return mutabilities.contains((Object)CfnResourceIndex.Mutability.CREATE) && !mutabilities.contains((Object)CfnResourceIndex.Mutability.WRITE);
        });
    }

    public Set<String> getReadOnlyProperties() {
        return this.getConstrainedProperties(definition -> {
            Set<CfnResourceIndex.Mutability> mutabilities = definition.getMutabilities();
            return mutabilities.size() == 1 && mutabilities.contains((Object)CfnResourceIndex.Mutability.READ);
        });
    }

    public Set<String> getWriteOnlyProperties() {
        return this.getConstrainedProperties(definition -> {
            Set<CfnResourceIndex.Mutability> mutabilities = definition.getMutabilities();
            if (mutabilities.size() == 1 && mutabilities.contains((Object)CfnResourceIndex.Mutability.CREATE)) {
                return true;
            }
            return mutabilities.contains((Object)CfnResourceIndex.Mutability.WRITE) && !mutabilities.contains((Object)CfnResourceIndex.Mutability.READ);
        });
    }

    private Set<String> getConstrainedProperties(Predicate<CfnResourceProperty> constraint) {
        return this.getProperties().entrySet().stream().filter(property -> constraint.test((CfnResourceProperty)property.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<ShapeId> getExcludedProperties() {
        return this.excludedProperties;
    }

    public Set<String> getPrimaryIdentifiers() {
        return this.primaryIdentifiers;
    }

    public List<Set<String>> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    public Builder toBuilder() {
        return CfnResource.builder().propertyDefinitions(this.propertyDefinitions).excludedProperties(this.excludedProperties).primaryIdentifiers(this.primaryIdentifiers).additionalIdentifiers(this.additionalIdentifiers);
    }

    public static final class Builder
    implements SmithyBuilder<CfnResource> {
        private final Map<String, CfnResourceProperty> propertyDefinitions = new HashMap<String, CfnResourceProperty>();
        private final Set<ShapeId> excludedProperties = new HashSet<ShapeId>();
        private final Set<String> primaryIdentifiers = new HashSet<String>();
        private final List<Set<String>> additionalIdentifiers = new ArrayList<Set<String>>();

        private Builder() {
        }

        public boolean hasPropertyDefinition(String propertyName) {
            return this.propertyDefinitions.containsKey(propertyName);
        }

        public Builder putPropertyDefinition(String propertyName, CfnResourceProperty definition) {
            this.propertyDefinitions.put(propertyName, definition);
            return this;
        }

        public Builder updatePropertyDefinition(String propertyName, Function<CfnResourceProperty, CfnResourceProperty> updater) {
            CfnResourceProperty definition = this.propertyDefinitions.get(propertyName);
            if (definition == null || definition.hasExplicitMutability()) {
                return this;
            }
            return this.putPropertyDefinition(propertyName, updater.apply(definition));
        }

        public Builder propertyDefinitions(Map<String, CfnResourceProperty> propertyDefinitions) {
            this.propertyDefinitions.clear();
            this.propertyDefinitions.putAll(propertyDefinitions);
            return this;
        }

        public Builder addExcludedProperty(ShapeId excludedProperty) {
            this.excludedProperties.add(excludedProperty);
            return this;
        }

        public Builder excludedProperties(Set<ShapeId> excludedProperties) {
            this.excludedProperties.clear();
            this.excludedProperties.addAll(excludedProperties);
            return this;
        }

        public Builder addPrimaryIdentifier(String primaryIdentifier) {
            this.primaryIdentifiers.add(primaryIdentifier);
            return this;
        }

        public Builder primaryIdentifiers(Set<String> primaryIdentifiers) {
            this.primaryIdentifiers.clear();
            this.primaryIdentifiers.addAll(primaryIdentifiers);
            return this;
        }

        public Builder addAdditionalIdentifier(Set<String> additionalIdentifier) {
            this.additionalIdentifiers.add(additionalIdentifier);
            return this;
        }

        public Builder additionalIdentifiers(List<Set<String>> additionalIdentifiers) {
            this.additionalIdentifiers.clear();
            this.additionalIdentifiers.addAll(additionalIdentifiers);
            return this;
        }

        public CfnResource build() {
            return new CfnResource(this);
        }
    }
}

