/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.aws.cloudformation.traits.CfnAdditionalIdentifierTrait;
import software.amazon.smithy.aws.cloudformation.traits.CfnExcludePropertyTrait;
import software.amazon.smithy.aws.cloudformation.traits.CfnMutabilityTrait;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceProperty;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;

public final class CfnResourceIndex
implements KnowledgeIndex {
    static final Set<Mutability> FULLY_MUTABLE = SetUtils.of((Object[])new Mutability[]{Mutability.CREATE, Mutability.READ, Mutability.WRITE});
    private final Map<ShapeId, CfnResource> resourceDefinitions = new HashMap<ShapeId, CfnResource>();

    public CfnResourceIndex(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        model.shapes(ResourceShape.class).filter(shape -> shape.hasTrait(CfnResourceTrait.ID)).forEach(resource -> {
            CfnResource.Builder builder = CfnResource.builder();
            ShapeId resourceId = resource.getId();
            builder.primaryIdentifiers(resource.getIdentifiers().keySet());
            this.setIdentifierMutabilities(builder, (ResourceShape)resource);
            resource.getRead().ifPresent(operationId -> {
                operationIndex.getInputShape((ToShapeId)operationId).ifPresent(input -> this.addAdditionalIdentifiers(builder, this.computeResourceAdditionalIdentifiers((StructureShape)input)));
                operationIndex.getOutputShape((ToShapeId)operationId).ifPresent(output -> this.updatePropertyMutabilities(builder, model, resourceId, (ShapeId)operationId, (StructureShape)output, SetUtils.of((Object)((Object)Mutability.READ)), this::addReadMutability));
            });
            resource.getPut().ifPresent(operationId -> operationIndex.getInputShape((ToShapeId)operationId).ifPresent(input -> this.updatePropertyMutabilities(builder, model, resourceId, (ShapeId)operationId, (StructureShape)input, SetUtils.of((Object[])new Mutability[]{Mutability.CREATE, Mutability.WRITE}), this::addPutMutability)));
            resource.getCreate().ifPresent(operationId -> operationIndex.getInputShape((ToShapeId)operationId).ifPresent(input -> this.updatePropertyMutabilities(builder, model, resourceId, (ShapeId)operationId, (StructureShape)input, SetUtils.of((Object)((Object)Mutability.CREATE)), this::addCreateMutability)));
            resource.getUpdate().ifPresent(operationId -> operationIndex.getInputShape((ToShapeId)operationId).ifPresent(input -> this.updatePropertyMutabilities(builder, model, resourceId, (ShapeId)operationId, (StructureShape)input, SetUtils.of((Object)((Object)Mutability.WRITE)), this::addWriteMutability)));
            CfnResourceTrait trait = (CfnResourceTrait)resource.expectTrait(CfnResourceTrait.class);
            for (ShapeId additionalSchema : trait.getAdditionalSchemas()) {
                model.getShape(additionalSchema).map(Shape::asStructureShape).map(Optional::get).ifPresent(shape -> {
                    this.addAdditionalIdentifiers(builder, this.computeResourceAdditionalIdentifiers((StructureShape)shape));
                    this.updatePropertyMutabilities(builder, model, resourceId, null, (StructureShape)shape, SetUtils.of(), Function.identity());
                });
            }
            this.resourceDefinitions.put(resourceId, builder.build());
        });
    }

    public static CfnResourceIndex of(Model model) {
        return (CfnResourceIndex)model.getKnowledge(CfnResourceIndex.class, CfnResourceIndex::new);
    }

    public Optional<CfnResource> getResource(ToShapeId resource) {
        return Optional.ofNullable(this.resourceDefinitions.get(resource.toShapeId()));
    }

    private void setIdentifierMutabilities(CfnResource.Builder builder, ResourceShape resource) {
        Set<Mutability> mutability = this.getDefaultIdentifierMutabilities(resource);
        resource.getIdentifiers().forEach((name, shape) -> builder.putPropertyDefinition((String)name, CfnResourceProperty.builder().hasExplicitMutability(true).mutabilities(mutability).addShapeId((ShapeId)shape).build()));
    }

    private Set<Mutability> getDefaultIdentifierMutabilities(ResourceShape resource) {
        if (resource.getPut().isPresent()) {
            return SetUtils.of((Object[])new Mutability[]{Mutability.CREATE, Mutability.READ});
        }
        return SetUtils.of((Object)((Object)Mutability.READ));
    }

    private List<Map<String, ShapeId>> computeResourceAdditionalIdentifiers(StructureShape readInput) {
        ArrayList<Map<String, ShapeId>> identifiers = new ArrayList<Map<String, ShapeId>>();
        for (MemberShape member : readInput.members()) {
            if (!member.hasTrait(CfnAdditionalIdentifierTrait.class)) continue;
            identifiers.add(MapUtils.of((Object)member.getMemberName(), (Object)member.getId()));
        }
        return identifiers;
    }

    private void addAdditionalIdentifiers(CfnResource.Builder builder, List<Map<String, ShapeId>> addedIdentifiers) {
        if (addedIdentifiers.isEmpty()) {
            return;
        }
        for (Map<String, ShapeId> addedIdentifier : addedIdentifiers) {
            for (Map.Entry<String, ShapeId> idEntry : addedIdentifier.entrySet()) {
                builder.putPropertyDefinition(idEntry.getKey(), CfnResourceProperty.builder().mutabilities(SetUtils.of((Object)((Object)Mutability.READ))).addShapeId(idEntry.getValue()).build());
            }
            builder.addAdditionalIdentifier(addedIdentifier.keySet());
        }
    }

    private void updatePropertyMutabilities(CfnResource.Builder builder, Model model, ShapeId resourceId, ShapeId operationId, StructureShape propertyContainer, Set<Mutability> defaultMutabilities, Function<Set<Mutability>, Set<Mutability>> updater) {
        ((Set)propertyContainer.accept((ShapeVisitor)new ExcludedPropertiesVisitor(model))).forEach(builder::addExcludedProperty);
        for (MemberShape member : propertyContainer.members()) {
            Set<Mutability> mutabilities;
            if (this.operationMemberIsIdentifier(model, resourceId, operationId, member)) continue;
            String memberName = member.getMemberName();
            Set<Mutability> explicitMutability = this.getExplicitMutability(model, member);
            Set<Mutability> set = mutabilities = !explicitMutability.isEmpty() ? explicitMutability : defaultMutabilities;
            if (builder.hasPropertyDefinition(memberName)) {
                builder.updatePropertyDefinition(memberName, this.getCfnResourcePropertyUpdater(member, explicitMutability, updater));
                continue;
            }
            builder.putPropertyDefinition(memberName, CfnResourceProperty.builder().addShapeId(member.getId()).mutabilities(mutabilities).hasExplicitMutability(!explicitMutability.isEmpty()).build());
        }
    }

    private Function<CfnResourceProperty, CfnResourceProperty> getCfnResourcePropertyUpdater(MemberShape member, Set<Mutability> explicitMutability, Function<Set<Mutability>, Set<Mutability>> updater) {
        return definition -> {
            CfnResourceProperty.Builder builder = definition.toBuilder().addShapeId(member.getId());
            if (explicitMutability.isEmpty()) {
                builder.mutabilities((Set)updater.apply(definition.getMutabilities()));
            } else {
                builder.hasExplicitMutability(true).mutabilities(explicitMutability);
            }
            return builder.build();
        };
    }

    private boolean operationMemberIsIdentifier(Model model, ShapeId resourceId, ShapeId operationId, MemberShape member) {
        if (operationId == null) {
            return false;
        }
        IdentifierBindingIndex index = IdentifierBindingIndex.of((Model)model);
        Map bindings = index.getOperationBindings((ToShapeId)resourceId, (ToShapeId)operationId);
        String memberName = member.getMemberName();
        for (String bindingMemberName : bindings.values()) {
            if (!memberName.equals(bindingMemberName)) continue;
            return true;
        }
        return false;
    }

    private Set<Mutability> getExplicitMutability(Model model, MemberShape member) {
        Optional traitOptional = member.getMemberTrait(model, CfnMutabilityTrait.class);
        if (!traitOptional.isPresent()) {
            return SetUtils.of();
        }
        CfnMutabilityTrait trait = (CfnMutabilityTrait)((Object)traitOptional.get());
        if (trait.isFullyMutable()) {
            return FULLY_MUTABLE;
        }
        if (trait.isCreateAndRead()) {
            return SetUtils.of((Object[])new Mutability[]{Mutability.CREATE, Mutability.READ});
        }
        if (trait.isCreate()) {
            return SetUtils.of((Object)((Object)Mutability.CREATE));
        }
        if (trait.isRead()) {
            return SetUtils.of((Object)((Object)Mutability.READ));
        }
        if (trait.isWrite()) {
            return SetUtils.of((Object)((Object)Mutability.WRITE));
        }
        return SetUtils.of();
    }

    private Set<Mutability> addReadMutability(Set<Mutability> mutabilities) {
        HashSet<Mutability> newMutabilities = new HashSet<Mutability>(mutabilities);
        newMutabilities.add(Mutability.READ);
        return SetUtils.copyOf(newMutabilities);
    }

    private Set<Mutability> addCreateMutability(Set<Mutability> mutabilities) {
        HashSet<Mutability> newMutabilities = new HashSet<Mutability>(mutabilities);
        newMutabilities.add(Mutability.CREATE);
        return SetUtils.copyOf(newMutabilities);
    }

    private Set<Mutability> addWriteMutability(Set<Mutability> mutabilities) {
        HashSet<Mutability> newMutabilities = new HashSet<Mutability>(mutabilities);
        newMutabilities.add(Mutability.WRITE);
        return SetUtils.copyOf(newMutabilities);
    }

    private Set<Mutability> addPutMutability(Set<Mutability> mutabilities) {
        return this.addWriteMutability(this.addCreateMutability(mutabilities));
    }

    private static final class ExcludedPropertiesVisitor
    extends ShapeVisitor.Default<Set<ShapeId>> {
        private final Model model;

        private ExcludedPropertiesVisitor(Model model) {
            this.model = model;
        }

        protected Set<ShapeId> getDefault(Shape shape) {
            return SetUtils.of();
        }

        public Set<ShapeId> structureShape(StructureShape shape) {
            HashSet<ShapeId> excludedShapes = new HashSet<ShapeId>();
            for (MemberShape member : shape.members()) {
                if (member.hasTrait(CfnExcludePropertyTrait.ID)) {
                    excludedShapes.add(member.getId());
                    continue;
                }
                excludedShapes.addAll((Collection)this.model.expectShape(member.getTarget()).accept((ShapeVisitor)this));
            }
            return excludedShapes;
        }
    }

    public static enum Mutability {
        CREATE,
        READ,
        WRITE;

    }
}

