/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerDefinition;
import software.amazon.smithy.aws.apigateway.traits.AuthorizersTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class AuthorizersTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(ServiceShape.class).map(service -> this.validate(model, (ServiceShape)service)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ValidationEvent> validate(Model model, ServiceShape service) {
        Map authorizers = service.getTrait(AuthorizersTrait.class).map(AuthorizersTrait::getAuthorizers).orElseGet(HashMap::new);
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        Optional<ValidationEvent> authSchemaValidation = this.validateAuthSchema(authorizers, model, service);
        authSchemaValidation.ifPresent(validationEvents::add);
        Optional<ValidationEvent> enableSimpleResponsesValidation = this.validateEnableSimpleResponsesConfig(authorizers, service);
        enableSimpleResponsesValidation.ifPresent(validationEvents::add);
        return validationEvents;
    }

    private Optional<ValidationEvent> validateAuthSchema(Map<String, AuthorizerDefinition> authorizers, Model model, ServiceShape service) {
        Set authSchemes = ServiceIndex.of((Model)model).getAuthSchemes((ToShapeId)service).keySet();
        String invalidMappings = authorizers.entrySet().stream().filter(entry -> !authSchemes.contains(((AuthorizerDefinition)entry.getValue()).getScheme())).map(entry -> (String)entry.getKey() + " -> " + ((AuthorizerDefinition)entry.getValue()).getScheme()).sorted().collect(Collectors.joining(", "));
        if (invalidMappings.isEmpty()) {
            return Optional.empty();
        }
        AuthorizersTrait authorizersTrait = (AuthorizersTrait)((Object)service.getTrait(AuthorizersTrait.class).get());
        return Optional.of(this.error((Shape)service, (FromSourceLocation)authorizersTrait, String.format("Each `scheme` of the `%s` trait must target one of the auth schemes applied to the service (i.e., [%s]). The following mappings of authorizer names to schemes are invalid: %s", AuthorizersTrait.ID, ValidationUtils.tickedList(authSchemes), invalidMappings)));
    }

    private Optional<ValidationEvent> validateEnableSimpleResponsesConfig(Map<String, AuthorizerDefinition> authorizers, ServiceShape service) {
        String invalidConfigs = authorizers.entrySet().stream().filter(entry -> ((AuthorizerDefinition)entry.getValue()).getEnableSimpleResponses().isPresent()).filter(entry -> ((AuthorizerDefinition)entry.getValue()).getAuthorizerPayloadFormatVersion().isPresent()).filter(entry -> !((AuthorizerDefinition)entry.getValue()).getAuthorizerPayloadFormatVersion().get().equals("2.0")).map(Map.Entry::getKey).sorted().collect(Collectors.joining(", "));
        if (invalidConfigs.isEmpty()) {
            return Optional.empty();
        }
        AuthorizersTrait authorizersTrait = (AuthorizersTrait)((Object)service.getTrait(AuthorizersTrait.class).get());
        return Optional.of(this.error((Shape)service, (FromSourceLocation)authorizersTrait, String.format("The enableSimpleResponses member of %s is only supported when authorizedPayloadFormatVersion is 2.0. The following authorizers are misconfigured: %s", AuthorizersTrait.ID, invalidConfigs)));
    }
}

