/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.apigateway.traits.IntegrationTrait;
import software.amazon.smithy.aws.apigateway.traits.MockIntegrationTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;

public final class IntegrationTraitIndex
implements KnowledgeIndex {
    private Map<ShapeId, Map<ShapeId, Trait>> traits = new HashMap<ShapeId, Map<ShapeId, Trait>>();

    public IntegrationTraitIndex(Model model) {
        model.shapes(ServiceShape.class).forEach(service -> {
            HashMap serviceMap = new HashMap();
            this.traits.put(service.getId(), serviceMap);
            this.walk(model, service.getId(), (EntityShape)service, null);
        });
    }

    public Optional<Trait> getIntegrationTrait(ToShapeId service, ToShapeId shape) {
        return Optional.ofNullable(this.traits.getOrDefault(service.toShapeId(), MapUtils.of()).get(shape.toShapeId()));
    }

    public <T extends Trait> Optional<T> getIntegrationTrait(ToShapeId service, ToShapeId shape, Class<T> type) {
        return this.getIntegrationTrait(service, shape).filter(type::isInstance).map(type::cast);
    }

    private void walk(Model model, ShapeId service, EntityShape current, Trait trait) {
        Trait updatedTrait = IntegrationTraitIndex.extractTrait((Shape)current, trait);
        Map<ShapeId, Trait> serviceMapping = this.traits.get(service);
        serviceMapping.put(current.getId(), updatedTrait);
        for (ShapeId resource : current.getResources()) {
            model.getShape(resource).flatMap(Shape::asResourceShape).ifPresent(resourceShape -> this.walk(model, service, (EntityShape)resourceShape, updatedTrait));
        }
        for (ShapeId operation : current.getAllOperations()) {
            model.getShape(operation).ifPresent(op -> serviceMapping.put(operation, IntegrationTraitIndex.extractTrait(op, updatedTrait)));
        }
    }

    private static Trait extractTrait(Shape shape, Trait defaultValue) {
        return shape.getTrait(MockIntegrationTrait.class).map(trait -> trait).orElseGet(() -> shape.getTrait(IntegrationTrait.class).map(trait -> trait).orElse(defaultValue));
    }
}

