/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.apigateway.traits.IntegrationResponse;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IntegrationTrait
extends AbstractTrait
implements ToSmithyBuilder<IntegrationTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.apigateway#integration");
    private static final String SERVICE_NAME_LABEL = "{serviceName}";
    private static final String OPERATION_NAME_LABEL = "{operationName}";
    private static final String TYPE_KEY = "type";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String HTTP_METHOD_KEY = "httpMethod";
    private static final String URI_KEY = "uri";
    private final String type;
    private final String uri;
    private final String credentials;
    private final String httpMethod;
    private final String passThroughBehavior;
    private final String contentHandling;
    private final Integer timeoutInMillis;
    private final String connectionId;
    private final String connectionType;
    private final String cacheNamespace;
    private final List<String> cacheKeyParameters;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final Map<String, IntegrationResponse> responses;

    private IntegrationTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.type = (String)SmithyBuilder.requiredState((String)TYPE_KEY, (Object)builder.type);
        this.uri = (String)SmithyBuilder.requiredState((String)URI_KEY, (Object)builder.uri);
        this.httpMethod = (String)SmithyBuilder.requiredState((String)HTTP_METHOD_KEY, (Object)builder.httpMethod);
        this.credentials = builder.credentials;
        this.passThroughBehavior = builder.passThroughBehavior;
        this.contentHandling = builder.contentHandling;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.cacheNamespace = builder.cacheNamespace;
        this.cacheKeyParameters = ListUtils.copyOf((Collection)builder.cacheKeyParameters);
        this.requestParameters = MapUtils.copyOf((Map)builder.requestParameters);
        this.requestTemplates = MapUtils.copyOf((Map)builder.requestTemplates);
        this.responses = MapUtils.copyOf((Map)builder.responses);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public Optional<String> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Optional<String> getPassThroughBehavior() {
        return Optional.ofNullable(this.passThroughBehavior);
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    public Optional<Integer> getTimeoutInMillis() {
        return Optional.ofNullable(this.timeoutInMillis);
    }

    public Optional<String> getConnectionId() {
        return Optional.ofNullable(this.connectionId);
    }

    public Optional<String> getConnectionType() {
        return Optional.ofNullable(this.connectionType);
    }

    public Optional<String> getCacheNamespace() {
        return Optional.ofNullable(this.cacheNamespace);
    }

    public List<String> getCacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public Optional<String> getRequestParameter(String expression) {
        return Optional.ofNullable(this.requestParameters.get(expression));
    }

    public Map<String, String> getRequestTemplates() {
        return this.requestTemplates;
    }

    public Optional<String> getRequestTemplate(String mimeType) {
        return Optional.ofNullable(this.requestTemplates.get(mimeType));
    }

    public Map<String, IntegrationResponse> getResponses() {
        return this.responses;
    }

    public Optional<IntegrationResponse> getResponse(String statusCode) {
        return Optional.ofNullable(this.responses.get(statusCode));
    }

    public ObjectNode toExpandedNode(ToShapeId service, ToShapeId operation) {
        ObjectNode result = this.toNode().expectObjectNode();
        if ((result = result.withMember(URI_KEY, IntegrationTrait.formatComponent(service, operation, result.expectStringMember(URI_KEY).getValue()))).containsMember(CREDENTIALS_KEY)) {
            result = result.withMember(CREDENTIALS_KEY, IntegrationTrait.formatComponent(service, operation, result.expectStringMember(CREDENTIALS_KEY).getValue()));
        }
        return result;
    }

    public static String formatComponent(ToShapeId service, ToShapeId operation, String component) {
        return component.replace(SERVICE_NAME_LABEL, service.toShapeId().getName()).replace(OPERATION_NAME_LABEL, operation.toShapeId().getName());
    }

    protected ObjectNode createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IntegrationTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public Builder toBuilder() {
        return IntegrationTrait.builder().type(this.type).uri(this.uri).credentials(this.credentials).httpMethod(this.httpMethod).passThroughBehavior(this.passThroughBehavior).contentHandling(this.contentHandling).timeoutInMillis(this.timeoutInMillis).connectionId(this.connectionId).connectionType(this.connectionType).cacheNamespace(this.cacheNamespace).requestParameters(this.requestParameters).requestTemplates(this.requestTemplates).responses(this.responses).cacheKeyParameters(this.cacheKeyParameters);
    }

    public static final class Builder
    extends AbstractTraitBuilder<IntegrationTrait, Builder> {
        private String type;
        private String uri;
        private String credentials;
        private String httpMethod;
        private String passThroughBehavior;
        private String contentHandling;
        private Integer timeoutInMillis;
        private String connectionId;
        private String connectionType;
        private String cacheNamespace;
        private final List<String> cacheKeyParameters = new ArrayList<String>();
        private final Map<String, String> requestParameters = new HashMap<String, String>();
        private final Map<String, String> requestTemplates = new HashMap<String, String>();
        private final Map<String, IntegrationResponse> responses = new HashMap<String, IntegrationResponse>();

        public IntegrationTrait build() {
            return new IntegrationTrait(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder passThroughBehavior(String passThroughBehavior) {
            this.passThroughBehavior = passThroughBehavior;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public Builder addCacheKeyParameter(String cacheKeyParameter) {
            this.cacheKeyParameters.add(cacheKeyParameter);
            return this;
        }

        public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
            this.cacheKeyParameters.clear();
            this.cacheKeyParameters.addAll(cacheKeyParameters);
            return this;
        }

        public Builder removeCacheKeyParameter(String cacheKeyParameter) {
            this.cacheKeyParameters.remove(cacheKeyParameter);
            return this;
        }

        public Builder clearCacheKeyParameters() {
            this.cacheKeyParameters.clear();
            return this;
        }

        public Builder putRequestParameter(String input, String output) {
            this.requestParameters.put(input, output);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters.clear();
            this.requestParameters.putAll(requestParameters);
            return this;
        }

        public Builder removeRequestParameter(String expression) {
            this.requestParameters.remove(expression);
            return this;
        }

        public Builder putRequestTemplate(String mimeType, String template) {
            this.requestTemplates.put(mimeType, template);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates.clear();
            this.requestTemplates.putAll(requestTemplates);
            return this;
        }

        public Builder removeRequestTemplate(String mimeType) {
            this.requestTemplates.remove(mimeType);
            return this;
        }

        public Builder putResponse(String statusCodeRegex, IntegrationResponse integrationResponse) {
            this.responses.put(statusCodeRegex, integrationResponse);
            return this;
        }

        public Builder responses(Map<String, IntegrationResponse> responses) {
            this.responses.clear();
            this.responses.putAll(responses);
            return this;
        }

        public Builder removeResponse(String statusCodeRegex) {
            this.responses.remove(statusCodeRegex);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            return (Trait)new NodeMapper().deserialize(value, IntegrationTrait.class);
        }
    }
}

