/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ResponseObject;

enum CorsHeader {
    ALLOW_CREDENTIALS("Access-Control-Allow-Credentials"),
    ALLOW_HEADERS("Access-Control-Allow-Headers"),
    ALLOW_METHODS("Access-Control-Allow-Methods"),
    ALLOW_ORIGIN("Access-Control-Allow-Origin"),
    EXPOSE_HEADERS("Access-Control-Expose-Headers"),
    MAX_AGE("Access-Control-Max-Age");

    private final String headerName;

    private CorsHeader(String headerName) {
        this.headerName = headerName;
    }

    public String toString() {
        return this.headerName;
    }

    static <T extends Trait> Set<String> deduceOperationResponseHeaders(Context<T> context, OperationObject operationObject, OperationShape shape, CorsTrait cors) {
        TreeSet<String> result = new TreeSet<String>(cors.getAdditionalExposedHeaders());
        result.addAll(context.getOpenApiProtocol().getProtocolResponseHeaders(context, shape));
        result.addAll(context.getAllSecuritySchemeResponseHeaders());
        for (ResponseObject responseObject : operationObject.getResponses().values()) {
            result.addAll(responseObject.getHeaders().keySet());
        }
        return result;
    }
}

