/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayDefaults;
import software.amazon.smithy.utils.SetUtils;

public final class ApiGatewayConfig {
    private ApiType apiGatewayType = ApiType.REST;
    private boolean disableCloudFormationSubstitution;
    private Set<String> additionalAllowedCorsHeaders = Collections.emptySet();
    private ApiGatewayDefaults apiGatewayDefaults;

    public boolean getDisableCloudFormationSubstitution() {
        return this.disableCloudFormationSubstitution;
    }

    public void setDisableCloudFormationSubstitution(boolean disableCloudFormationSubstitution) {
        this.disableCloudFormationSubstitution = disableCloudFormationSubstitution;
    }

    public ApiType getApiGatewayType() {
        return this.apiGatewayType;
    }

    public void setApiGatewayType(ApiType apiGatewayType) {
        this.apiGatewayType = Objects.requireNonNull(apiGatewayType);
    }

    @Deprecated
    public List<String> getAdditionalAllowedCorsHeaders() {
        return new ArrayList<String>(this.additionalAllowedCorsHeaders);
    }

    public Set<String> getAdditionalAllowedCorsHeadersSet() {
        return this.additionalAllowedCorsHeaders;
    }

    public void setAdditionalAllowedCorsHeaders(Collection<String> additionalAllowedCorsHeaders) {
        this.additionalAllowedCorsHeaders = SetUtils.caseInsensitiveCopyOf(additionalAllowedCorsHeaders);
    }

    public ApiGatewayDefaults getApiGatewayDefaults() {
        return this.apiGatewayDefaults;
    }

    public void setApiGatewayDefaults(ApiGatewayDefaults apiGatewayDefaults) {
        this.apiGatewayDefaults = apiGatewayDefaults;
    }

    public static enum ApiType {
        REST,
        HTTP,
        DISABLED;

    }
}

