/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.OptionalUtils;

final class AddBinaryTypes
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddBinaryTypes.class.getName());
    private static final String EXTENSION_NAME = "x-amazon-apigateway-binary-media-types";
    private static final String DEFAULT_BINARY_TYPE = "application/octet-stream";

    AddBinaryTypes() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST), (Object)((Object)ApiGatewayConfig.ApiType.HTTP));
    }

    public OpenApi after(Context<? extends Trait> context, OpenApi openApi) {
        List binaryTypes = this.supportedMediaTypes(context).sorted().collect(Collectors.toList());
        if (!binaryTypes.isEmpty()) {
            LOGGER.fine(() -> "Adding recognized binary types to model: " + binaryTypes);
            return ((OpenApi.Builder)openApi.toBuilder().putExtension(EXTENSION_NAME, (Node)Stream.concat(binaryTypes.stream(), Stream.of(DEFAULT_BINARY_TYPE)).distinct().map(Node::from).collect(ArrayNode.collect()))).build();
        }
        return openApi;
    }

    private Stream<String> supportedMediaTypes(Context<? extends Trait> context) {
        Model model = context.getModel();
        HttpBindingIndex httpBindingIndex = HttpBindingIndex.of((Model)context.getModel());
        TopDownIndex topDownIndex = TopDownIndex.of((Model)context.getModel());
        return topDownIndex.getContainedOperations((ToShapeId)context.getService()).stream().flatMap(operation -> Stream.concat(OptionalUtils.stream(this.binaryMediaType(model, httpBindingIndex.getRequestBindings((ToShapeId)operation))), OptionalUtils.stream(this.binaryMediaType(model, httpBindingIndex.getResponseBindings((ToShapeId)operation)))));
    }

    private Optional<String> binaryMediaType(Model model, Map<String, HttpBinding> httpBindings) {
        return httpBindings.values().stream().filter(binding -> binding.getLocation().equals((Object)HttpBinding.Location.PAYLOAD)).map(HttpBinding::getMember).flatMap(member -> OptionalUtils.stream((Optional)member.getMemberTrait(model, MediaTypeTrait.class))).map(StringTrait::getValue).findFirst();
    }
}

