/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.rulesengine;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.HttpBearerAuthTrait;
import software.amazon.smithy.utils.SmithyBuilder;

public final class AuthSchemeBinding {
    private final String schemeId;
    private final String endpointAuthName;
    private final Map<String, String> propertyMap;

    private AuthSchemeBinding(Builder builder) {
        this.schemeId = builder.schemeId;
        this.endpointAuthName = builder.endpointAuthName;
        this.propertyMap = builder.propertyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<AuthSchemeBinding> standardAuthSchemes() {
        return List.of(AuthSchemeBinding.builder().schemeId(HttpBearerAuthTrait.ID).endpointAuthName("bearer").build());
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    public String getEndpointAuthName() {
        return this.endpointAuthName;
    }

    public Optional<String> getAuthSchemeProperty(String endpointProperty) {
        return Optional.ofNullable(this.propertyMap.get(endpointProperty));
    }

    public Map<String, String> getPropertyMap() {
        return Map.copyOf(this.propertyMap);
    }

    public static class Builder
    implements SmithyBuilder<AuthSchemeBinding> {
        private String schemeId;
        private String endpointAuthName;
        private final Map<String, String> propertyMap = new LinkedHashMap<String, String>();

        public Builder schemeId(String schemeId) {
            this.schemeId = schemeId;
            return this;
        }

        public Builder schemeId(ShapeId shapeId) {
            this.schemeId = shapeId.toString();
            return this;
        }

        public Builder endpointAuthName(String endpointAuthName) {
            this.endpointAuthName = endpointAuthName;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            properties.forEach((k, v) -> this.propertyMap.put((String)k, (String)v));
            return this;
        }

        public Builder property(String endpointProperty, String authProperty) {
            this.propertyMap.put(endpointProperty, authProperty);
            return this;
        }

        public AuthSchemeBinding build() {
            return new AuthSchemeBinding(this);
        }
    }
}

