/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class ParseMiddlewareFactory {
    private ParseMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        SymbolProvider symbolProvider = context.symbolProvider();
        return Middleware.builder().klass(Hearth.PARSE_MIDDLEWARE).step(MiddlewareStackStep.PARSE).operationParams((ctx, operation) -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data_parser", "Parsers::" + symbolProvider.toSymbol((Shape)operation).getName());
            Object successCode = "200";
            Optional httpTrait = operation.getTrait(HttpTrait.class);
            if (httpTrait.isPresent()) {
                successCode = "" + ((HttpTrait)httpTrait.get()).getCode();
            }
            String errors = operation.getErrors().stream().map(error -> "Errors::" + symbolProvider.toSymbol(ctx.model().expectShape(error)).getName()).collect(Collectors.joining(", "));
            String errorParser = "Hearth::HTTP::ErrorParser.new(\n  error_module: Errors,\n  success_status: %s,\n  errors: [%s]\n)".formatted(successCode, errors);
            params.put("error_parser", errorParser);
            return params;
        }).build();
    }
}

