/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators.rbs;

import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;

public class OperationKeywordArgRbsVisitor
extends ShapeVisitor.Default<Void> {
    private static final int MAX_LEVEL = 2;
    private final GenerationContext context;
    private final RubyCodeWriter writer;
    private final int level;

    public OperationKeywordArgRbsVisitor(GenerationContext context, RubyCodeWriter writer) {
        this.context = context;
        this.writer = writer;
        this.level = 0;
    }

    public OperationKeywordArgRbsVisitor(GenerationContext context, RubyCodeWriter writer, int level) {
        this.context = context;
        this.writer = writer;
        this.level = level;
    }

    protected Void getDefault(Shape shape) {
        Symbol symbol = this.context.symbolProvider().toSymbol(shape);
        this.writer.writeInline(symbol.getProperty("rbsType", String.class).orElse("untyped"), new Object[0]);
        return null;
    }

    public Void enumShape(EnumShape shape) {
        String values = shape.getEnumValues().values().stream().map(v -> "\"" + v + "\"").collect(Collectors.joining(" | "));
        this.writer.write("($L)", new Object[]{values});
        return null;
    }

    public Void listShape(ListShape shape) {
        Shape target = this.context.model().expectShape(shape.getMember().getTarget());
        this.writer.write("::Array[$L]", new Object[]{this.targetSubType(target)});
        return null;
    }

    public Void mapShape(MapShape shape) {
        Shape target = this.context.model().expectShape(shape.getValue().getTarget());
        this.writer.write("::Hash[::String, $L]", new Object[]{this.targetSubType(target)});
        return null;
    }

    public Void operationShape(OperationShape operationShape) {
        Shape inputShape = this.context.model().expectShape(operationShape.getInputShape());
        for (MemberShape memberShape : inputShape.members()) {
            String required = memberShape.hasTrait(RequiredTrait.class) ? "" : "?";
            RubyCodeWriter subWriter = new RubyCodeWriter("");
            this.context.model().expectShape(memberShape.getTarget()).accept((ShapeVisitor)new OperationKeywordArgRbsVisitor(this.context, subWriter, this.level + 1));
            String subType = subWriter.toString().trim();
            this.writer.write("$L$L: $L,", new Object[]{required, this.context.symbolProvider().toMemberName(memberShape), subType});
        }
        this.writer.unwrite(",\n", new Object[0]);
        return null;
    }

    public Void structureShape(StructureShape shape) {
        ((RubyCodeWriter)this.writer.write("{", new Object[0])).indent();
        for (MemberShape memberShape : shape.members()) {
            Shape target = this.context.model().expectShape(memberShape.getTarget());
            this.writer.write("$L: $L,", new Object[]{this.context.symbolProvider().toMemberName(memberShape), this.targetSubType(target)});
        }
        this.writer.unwrite(",\n", new Object[0]);
        ((RubyCodeWriter)this.writer.dedent()).write("\n}", new Object[0]);
        return null;
    }

    public Void unionShape(UnionShape shape) {
        ((RubyCodeWriter)this.writer.write("{", new Object[0])).indent();
        for (MemberShape memberShape : shape.members()) {
            Shape target = this.context.model().expectShape(memberShape.getTarget());
            this.writer.write("$L: $L,", new Object[]{this.context.symbolProvider().toMemberName(memberShape), this.targetSubType(target)});
        }
        this.writer.unwrite(",\n", new Object[0]);
        ((RubyCodeWriter)this.writer.dedent()).write("\n}", new Object[0]);
        return null;
    }

    private String targetSubType(Shape target) {
        String subType;
        if (this.level < 2) {
            RubyCodeWriter subWriter = new RubyCodeWriter("");
            target.accept((ShapeVisitor)new OperationKeywordArgRbsVisitor(this.context, subWriter, this.level + 1));
            subType = subWriter.toString().trim();
        } else {
            Symbol symbol = this.context.symbolProvider().toSymbol(target);
            subType = symbol.getProperty("rbsType", String.class).orElse("untyped");
        }
        return subType;
    }
}

