/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Map;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateEnumDirective;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class EnumGenerator
extends RubyGeneratorBase {
    private final EnumShape shape;

    public EnumGenerator(GenerateEnumDirective<GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.shape = directive.expectEnumShape();
    }

    @Override
    String getModule() {
        return "Types";
    }

    public void render() {
        String shapeName = this.symbolProvider.toSymbol((Shape)this.shape).getName();
        Map enumValues = this.shape.getEnumValues();
        this.write(writer -> {
            ((RubyCodeWriter)writer.writeDocstring("Enum constants for " + shapeName).call(() -> new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)this.shape).render())).addModule(shapeName);
            enumValues.entrySet().forEach(entry -> {
                String enumName = StringUtils.upperCase((String)RubyFormatter.toSnakeCase((String)entry.getKey()));
                String enumValue = (String)entry.getValue();
                writer.write("$L = $S\n", new Object[]{enumName, enumValue});
            });
            ((RubyCodeWriter)writer.unwrite("\n", new Object[0])).closeModule().write("", new Object[0]);
        });
        this.writeRbs(writer -> {
            writer.addModule(shapeName);
            enumValues.entrySet().forEach(entry -> {
                String enumName = StringUtils.upperCase((String)RubyFormatter.toSnakeCase((String)entry.getKey()));
                writer.write("$L: ::String\n", new Object[]{enumName});
            });
            ((RubyCodeWriter)writer.unwrite("\n", new Object[0])).closeModule().write("", new Object[0]);
        });
    }
}

