/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.ruby.codegen.auth.AuthParam;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.util.RubySource;
import software.amazon.smithy.utils.SmithyBuilder;

public final class AuthScheme {
    private final ShapeId shapeId;
    private final String rubyAuthScheme;
    private final String rubyIdentityType;
    private Set<AuthParam> additionalAuthParams;
    private final Optional<ClientConfig> identityProviderConfig;
    private final WriteAdditionalFiles writeAdditionalFiles;
    private final ExtractProperties extractSignerProperties;
    private final Map<String, String> signerProperties;
    private final ExtractProperties extractIdentityProperties;
    private final Map<String, String> identityProperties;
    private final List<ClientConfig> additionalConfig;

    private AuthScheme(Builder builder) {
        this.shapeId = Objects.requireNonNull(builder.shapeId);
        this.rubyAuthScheme = Objects.requireNonNull(builder.rubyAuthScheme);
        this.rubyIdentityType = Objects.requireNonNull(builder.rubyIdentityType);
        this.additionalAuthParams = Collections.unmodifiableSet(builder.additionalAuthParams);
        this.identityProviderConfig = Optional.ofNullable(builder.identityProviderConfig);
        this.writeAdditionalFiles = builder.writeAdditionalFiles;
        this.extractSignerProperties = builder.extractSignerProperties;
        this.signerProperties = builder.signerProperties;
        this.extractIdentityProperties = builder.extractIdentityProperties;
        this.identityProperties = builder.identityProperties;
        this.additionalConfig = List.copyOf(builder.additionalConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ShapeId getShapeId() {
        return this.shapeId;
    }

    public String getRubyAuthScheme() {
        return this.rubyAuthScheme;
    }

    public String getRubyIdentityType() {
        return this.rubyIdentityType;
    }

    public Set<AuthParam> getAdditionalAuthParams() {
        return this.additionalAuthParams;
    }

    public Optional<ClientConfig> getIdentityProviderConfig() {
        return this.identityProviderConfig;
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.writeAdditionalFiles.writeAdditionalFiles(context);
    }

    public Map<String, String> getSignerProperties(Trait trait) {
        Map<String, String> signerProperties = this.extractSignerProperties.extractProperties(trait);
        this.signerProperties.forEach((key, value) -> signerProperties.put((String)key, (String)value));
        return signerProperties;
    }

    public Map<String, String> getIdentityProperties(Trait trait) {
        Map<String, String> identityProperties = this.extractIdentityProperties.extractProperties(trait);
        this.identityProperties.forEach((key, value) -> identityProperties.put((String)key, (String)value));
        return identityProperties;
    }

    public List<ClientConfig> getAdditionalConfig() {
        return this.additionalConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthScheme)) {
            return false;
        }
        AuthScheme other = (AuthScheme)o;
        return this.shapeId.equals((Object)other.shapeId);
    }

    public int hashCode() {
        return Objects.hash(this.shapeId);
    }

    public static class Builder
    implements SmithyBuilder<AuthScheme> {
        private ShapeId shapeId;
        private String rubyAuthScheme;
        private String rubyIdentityType;
        private Set<AuthParam> additionalAuthParams = new HashSet<AuthParam>();
        private ClientConfig identityProviderConfig;
        private WriteAdditionalFiles writeAdditionalFiles = context -> Collections.emptyList();
        private ExtractProperties extractSignerProperties = trait -> Collections.emptyMap();
        private ExtractProperties extractIdentityProperties = trait -> Collections.emptyMap();
        private Map<String, String> signerProperties = new HashMap<String, String>();
        private Map<String, String> identityProperties = new HashMap<String, String>();
        private List<ClientConfig> additionalConfig = new ArrayList<ClientConfig>();

        protected Builder() {
        }

        public Builder shapeId(ShapeId shapeId) {
            this.shapeId = Objects.requireNonNull(shapeId);
            return this;
        }

        public Builder rubyAuthScheme(String rubyAuthScheme) {
            this.rubyAuthScheme = Objects.requireNonNull(rubyAuthScheme);
            return this;
        }

        public Builder rubyIdentityType(String rubyIdentityType) {
            this.rubyIdentityType = Objects.requireNonNull(rubyIdentityType);
            return this;
        }

        public Builder additionalAuthParam(AuthParam authParam) {
            this.additionalAuthParams.add(authParam);
            return this;
        }

        public Builder identityProviderConfig(ClientConfig identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return this;
        }

        public Builder rubySource(String rubyFileName) {
            this.writeAdditionalFiles = RubySource.rubySource(rubyFileName, "auth/");
            return this;
        }

        public Builder extractSignerProperties(ExtractProperties extractProperties) {
            this.extractSignerProperties = extractProperties;
            return this;
        }

        public Builder putSignerProperty(String key, String value) {
            this.signerProperties.put(key, value);
            return this;
        }

        public Builder extractIdentityProperties(ExtractProperties extractProperties) {
            this.extractIdentityProperties = extractProperties;
            return this;
        }

        public Builder putIdentityProperty(String key, String value) {
            this.identityProperties.put(key, value);
            return this;
        }

        public Builder additionalConfig(ClientConfig config) {
            this.additionalConfig.add(config);
            return this;
        }

        public AuthScheme build() {
            return new AuthScheme(this);
        }
    }

    @FunctionalInterface
    public static interface ExtractProperties {
        public Map<String, String> extractProperties(Trait var1);
    }
}

