/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth;

import java.util.Objects;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.utils.SmithyBuilder;

public final class AuthParam {
    public static final AuthParam OPERATION_NAME = AuthParam.builder().name("operation_name").rbsType("::Symbol").paramValue((_p, context, operation) -> RubyFormatter.asSymbol(context.symbolProvider().toSymbol((Shape)operation).getName())).build();
    private final String name;
    private final String rbsType;
    private final ParamValue paramValue;

    private AuthParam(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.rbsType = Objects.requireNonNull(builder.rbsType);
        this.paramValue = Objects.requireNonNull(builder.paramValue);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getRbsType() {
        return this.rbsType;
    }

    public String renderParamValue(GenerationContext context, OperationShape operation) {
        return this.paramValue.paramValue(this, context, operation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthParam authParam = (AuthParam)o;
        return Objects.equals(this.name, authParam.name) && Objects.equals(this.rbsType, authParam.rbsType) && Objects.equals(this.paramValue, authParam.paramValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rbsType, this.paramValue);
    }

    public static class Builder
    implements SmithyBuilder<AuthParam> {
        private String name;
        private String rbsType;
        private ParamValue paramValue;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rbsType(String rbsType) {
            this.rbsType = rbsType;
            return this;
        }

        public Builder paramValue(String valueSetter) {
            this.paramValue = (_p, _context, _operation) -> valueSetter;
            return this;
        }

        public Builder paramValue(ParamValue paramValue) {
            this.paramValue = paramValue;
            return this;
        }

        public AuthParam build() {
            return new AuthParam(this);
        }
    }

    @FunctionalInterface
    public static interface ParamValue {
        public String paramValue(AuthParam var1, GenerationContext var2, OperationShape var3);
    }
}

