/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolContainer;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class RubyCodeWriter
extends SymbolWriter<RubyCodeWriter, RubyImportContainer> {
    public static final String QUALIFIED_NAMESPACE = "qualifiedNamespace";
    private static final String PREAMBLE = "# frozen_string_literal: true\n\n# WARNING ABOUT GENERATED CODE\n#\n# This file was code generated using smithy-ruby.\n# https://github.com/smithy-lang/smithy-ruby\n#\n# WARNING ABOUT GENERATED CODE\n";
    private final String namespace;
    private boolean includePreamble = false;
    private boolean includeRequires = false;
    private Stack<String> modules = new Stack();
    private Set<String> modulesSet = new HashSet<String>();

    public RubyCodeWriter(String namespace) {
        super((ImportContainer)new RubyImportContainer(namespace));
        this.namespace = namespace;
        this.trimTrailingSpaces();
        this.trimBlankLines();
        this.setIndentText("  ");
        this.putFormatter('T', new RubySymbolFormatter());
    }

    public RubyCodeWriter addModule(String name) {
        if (this.modulesSet.contains(name)) {
            return this;
        }
        this.modulesSet.add(name);
        this.modules.push(name);
        this.openBlock("module $L", new Object[]{name});
        return this;
    }

    public RubyCodeWriter closeModule() {
        if (this.modules.isEmpty()) {
            throw new RuntimeException("No modules were opened");
        }
        String module = this.modules.pop();
        this.modulesSet.remove(module);
        this.closeBlock("end", new Object[0]);
        return this;
    }

    public void closeAllModules() {
        while (!this.modules.isEmpty()) {
            this.closeModule();
        }
    }

    public RubyCodeWriter apiPrivate() {
        this.write("# @api private", new Object[0]);
        return this;
    }

    public RubyCodeWriter preamble() {
        this.includePreamble = true;
        return this;
    }

    public RubyCodeWriter includeRequires() {
        this.includeRequires = true;
        return this;
    }

    public RubyCodeWriter writeRequireRelativeAdditionalFiles(List<String> additionalFiles) {
        for (String require : additionalFiles) {
            this.write("require_relative '$L'", new Object[]{this.removeRbExtension(require)});
        }
        if (additionalFiles.size() > 0) {
            this.write("", new Object[0]);
        }
        return this;
    }

    private String removeRbExtension(String s) {
        if (s != null && s.endsWith(".rb")) {
            return s.split(".rb")[0];
        }
        return s;
    }

    public RubyCodeWriter writeDocs(Consumer<RubyCodeWriter> consumer) {
        this.pushState();
        if (this.getNewlinePrefix().isEmpty()) {
            this.setNewlinePrefix("# ");
        }
        consumer.accept(this);
        this.popState();
        return this;
    }

    public RubyCodeWriter writeYardMethod(String methodSignature, Runnable task) {
        this.writeDocs(w -> {
            w.write("@!method $L", new Object[]{methodSignature});
            w.pushState();
            w.setNewlinePrefix(w.getNewlinePrefix() + w.getIndentText());
            task.run();
            w.popState();
        });
        return this;
    }

    public RubyCodeWriter writeYardAttribute(String attribute, Runnable task) {
        this.writeDocs(w -> {
            w.write("@!attribute $L", new Object[]{attribute});
            w.pushState();
            w.setNewlinePrefix(w.getNewlinePrefix() + w.getIndentText());
            task.run();
            w.popState();
        });
        return this;
    }

    public RubyCodeWriter writeDocstring(String docstring) {
        this.writeDocs(w -> w.write("$L", new Object[]{docstring}));
        return this;
    }

    public RubyCodeWriter writeYardParam(String paramType, String param, String documentation) {
        this.writeDocs(w -> {
            w.write("@param [$L] $L", new Object[]{paramType, param});
            w.writeIndentedParts(documentation);
        });
        return this;
    }

    public RubyCodeWriter writeYardOption(String param, String type, String option, String defaultValue, String documentation) {
        this.writeDocs(w -> {
            w.writeInline("@option $L [$L] $L", new Object[]{param, type, option});
            if (!defaultValue.isEmpty()) {
                w.write(" ($L)", new Object[]{defaultValue});
            } else {
                w.write("", new Object[0]);
            }
            w.writeIndentedParts(documentation);
        });
        return this;
    }

    public RubyCodeWriter writeYardReturn(String returnType, String documentation) {
        this.writeDocs(w -> {
            w.write("@return [$L]", new Object[]{returnType});
            w.writeIndentedParts(documentation);
        });
        return this;
    }

    public RubyCodeWriter writeYardRaise(String errorType, String documentation) {
        this.writeDocs(w -> {
            w.write("@raise [$L]", new Object[]{errorType});
            w.writeIndentedParts(documentation);
        });
        return this;
    }

    public RubyCodeWriter writeYardExample(String title, String block) {
        this.writeDocs(w -> {
            w.write("@example $L", new Object[]{title});
            w.writeIndentedParts(block);
        });
        return this;
    }

    public RubyCodeWriter writeYardDeprecated(String message, String since) {
        this.writeDocs(w -> {
            w.write("@deprecated", new Object[0]);
            w.writeIndentedParts(message);
            if (!since.isEmpty()) {
                w.write("  Since: $L", new Object[]{since});
            }
        });
        return this;
    }

    public RubyCodeWriter writeYardSee(String url, String description) {
        this.writeDocs(w -> w.write("@see $L $L", new Object[]{url, description}));
        return this;
    }

    public RubyCodeWriter writeYardNote(String note) {
        this.writeDocs(w -> {
            w.write("@note", new Object[0]);
            w.writeIndentedParts(note);
        });
        return this;
    }

    public RubyCodeWriter writeYardSince(String since) {
        this.writeDocs(w -> w.write("@since $L", new Object[]{since}));
        return this;
    }

    public RubyCodeWriter writeYardReference(String tag, String reference) {
        this.writeDocs(w -> {
            if (tag.isEmpty()) {
                w.write("(see $L)", new Object[]{reference});
            } else {
                w.write("@$L (see $L)", new Object[]{tag, reference});
            }
        });
        return this;
    }

    public String toString() {
        String requires;
        StringBuilder result = new StringBuilder();
        if (this.includePreamble) {
            result.append(PREAMBLE).append("\n");
        }
        if (this.includeRequires && !(requires = ((RubyImportContainer)this.getImportContainer()).toString()).isEmpty()) {
            result.append(requires).append("\n");
        }
        result.append(super.toString());
        return result.toString();
    }

    private void writeIndentedParts(String documentation) {
        if (!documentation.isEmpty()) {
            String[] docstringParts = documentation.split("\n");
            for (int i = 0; i < docstringParts.length; ++i) {
                this.write("  $L", new Object[]{docstringParts[i]});
            }
        }
    }

    public RubyCodeWriter withQualifiedNamespace(String qualifiedNamespace, Runnable task) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.pushState(qualifiedNamespace)).putContext(QUALIFIED_NAMESPACE, qualifiedNamespace)).call(task)).popState();
        return this;
    }

    public void addUseImports(RubyDependency dependency) {
        dependency.getDependencies().forEach(d -> ((RubyImportContainer)this.getImportContainer()).importDependency((SymbolDependency)d));
    }

    public String getNamespace() {
        return this.namespace;
    }

    private final class RubySymbolFormatter
    implements BiFunction<Object, String, String> {
        private RubySymbolFormatter() {
        }

        @Override
        public String apply(Object type, String indent) {
            if (type instanceof Symbol) {
                Symbol typeSymbol = (Symbol)type;
                RubyCodeWriter.this.addUseImports((SymbolContainer)typeSymbol);
                return this.relativizeName(typeSymbol);
            }
            if (type instanceof SymbolReference) {
                SymbolReference typeSymbol = (SymbolReference)type;
                RubyCodeWriter.this.addImport(typeSymbol.getSymbol(), typeSymbol.getAlias(), new SymbolReference.ContextOption[]{SymbolReference.ContextOption.USE});
                return typeSymbol.getAlias();
            }
            throw new CodegenException("Invalid type provided to $T. Expected a Symbol or SymbolReference, but found `" + type + "`");
        }

        private String relativizeName(Symbol symbol) {
            int i;
            if (symbol.getNamespace().isEmpty()) {
                return "::" + symbol.getName();
            }
            String[] symbolNamespace = symbol.getNamespace().split("::");
            String[] moduleNamespace = RubyCodeWriter.this.namespace.split("::");
            String qualifiedNamespace = (String)RubyCodeWriter.this.getContext(RubyCodeWriter.QUALIFIED_NAMESPACE, String.class);
            for (i = 0; i < symbolNamespace.length && i < moduleNamespace.length && symbolNamespace[i].equals(moduleNamespace[i]) && !symbolNamespace[i].equals(qualifiedNamespace); ++i) {
            }
            String relativeNamespace = IntStream.range(i, symbolNamespace.length).mapToObj(j -> symbolNamespace[j]).collect(Collectors.joining("::"));
            if (relativeNamespace.isBlank()) {
                return symbol.getName();
            }
            return relativeNamespace + "::" + symbol.getName();
        }
    }

    public static final class Factory
    implements SymbolWriter.Factory<RubyCodeWriter> {
        public RubyCodeWriter apply(String filename, String namespace) {
            return new RubyCodeWriter(namespace);
        }
    }
}

