/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class HostPrefixMiddlewareFactory {
    private HostPrefixMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        String hostPrefixDocumentation = "When `true`, does not perform host prefix injection using @endpoint trait's hostPrefix property.\n";
        ClientConfig disableHostPrefix = ClientConfig.builder().name("disable_host_prefix").type("Boolean").rbsType("bool").defaultPrimitiveValue("false").documentation(hostPrefixDocumentation).build();
        return Middleware.builder().klass("Hearth::Middleware::HostPrefix").step(MiddlewareStackStep.BUILD).addConfig(disableHostPrefix).relative(Middleware.Relative.builder().before(Hearth.BUILD_MIDDLEWARE).build()).operationPredicate((model, service, operation) -> operation.hasTrait(EndpointTrait.class)).operationParams((ctx, operation) -> {
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            SmithyPattern pattern = ((EndpointTrait)operation.getTrait(EndpointTrait.class).get()).getHostPrefix();
            StringBuffer prefix = new StringBuffer();
            for (SmithyPattern.Segment segment : pattern.getSegments()) {
                if (segment.isLabel()) {
                    String label = RubySymbolProvider.toMemberName(segment.getContent());
                    prefix.append("{" + label + "}");
                    continue;
                }
                prefix.append(segment);
            }
            params.put("host_prefix", (CallSite)((Object)("\"" + prefix + "\"")));
            return params;
        }).build();
    }
}

