/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateEnumDirective;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class EnumGenerator
extends RubyGeneratorBase {
    private final Shape shape;

    public EnumGenerator(GenerateEnumDirective<GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.shape = directive.shape();
    }

    @Override
    String getModule() {
        return "Types";
    }

    public void render() {
        this.write(writer -> {
            EnumTrait enumTrait = (EnumTrait)this.shape.expectTrait(EnumTrait.class);
            List<EnumDefinition> enumDefinitions = enumTrait.getValues().stream().filter(value -> value.getName().isPresent()).collect(Collectors.toList());
            if (enumDefinitions.size() > 0) {
                String shapeName = this.symbolProvider.toSymbol(this.shape).getName();
                writer.writeDocstring("Includes enum constants for " + shapeName).openBlock("module $L", new Object[]{shapeName});
                enumDefinitions.forEach(enumDefinition -> {
                    String enumName = (String)enumDefinition.getName().get();
                    String enumValue = enumDefinition.getValue();
                    String enumDocumentation = enumDefinition.getDocumentation().orElse("No documentation available.");
                    writer.writeDocstring(enumDocumentation);
                    if (enumDefinition.isDeprecated()) {
                        writer.writeYardDeprecated("This enum value is deprecated.", "");
                    }
                    if (!enumDefinition.getTags().isEmpty()) {
                        String enumTags = enumDefinition.getTags().stream().map(tag -> "\"" + tag + "\"").collect(Collectors.joining(", "));
                        writer.writeDocstring("Tags: [" + enumTags + "]");
                    }
                    writer.write("$L = $S\n", new Object[]{enumName, enumValue});
                });
                ((RubyCodeWriter)writer.unwrite("\n", new Object[0])).closeBlock("end\n", new Object[0]);
            }
        });
        this.writeRbs(writer -> {
            EnumTrait enumTrait = (EnumTrait)this.shape.expectTrait(EnumTrait.class);
            List<EnumDefinition> enumDefinitions = enumTrait.getValues().stream().filter(value -> value.getName().isPresent()).collect(Collectors.toList());
            if (enumDefinitions.size() > 0) {
                String shapeName = this.symbolProvider.toSymbol(this.shape).getName();
                writer.openBlock("module $L", new Object[]{shapeName});
                enumDefinitions.forEach(enumDefinition -> {
                    String enumName = (String)enumDefinition.getName().get();
                    writer.write("$L: ::String\n", new Object[]{enumName});
                });
                ((RubyCodeWriter)writer.unwrite("\n", new Object[0])).closeBlock("end\n", new Object[0]);
            }
        });
    }
}

