/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.ruby.codegen.ClientFragment;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.config.ConfigDefaults;
import software.amazon.smithy.ruby.codegen.config.ConfigProvider;
import software.amazon.smithy.ruby.codegen.config.DynamicConfigProvider;
import software.amazon.smithy.ruby.codegen.config.EnvConfigProvider;
import software.amazon.smithy.ruby.codegen.config.SharedConfigProvider;
import software.amazon.smithy.ruby.codegen.config.StaticConfigProvider;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class ConfigProviderChain
implements ConfigDefaults {
    private final List<ConfigProvider> providers;
    private Optional<String> documentationDefaultOverride;

    public ConfigProviderChain(Builder builder) {
        this.providers = builder.providers;
        this.documentationDefaultOverride = Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String renderDefault(GenerationContext context) {
        return "[" + this.providers.stream().map(p -> p.providerFragment().render(context)).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public Optional<String> getDocumentationDefault() {
        if (this.documentationDefaultOverride.isPresent()) {
            return this.documentationDefaultOverride;
        }
        return this.providers.stream().map(p -> p.getDocumentationDefault()).filter(d -> d.isPresent()).map(d -> (String)d.get()).findFirst();
    }

    @Override
    public void setDocumentationDefault(String documentationDefault) {
        this.documentationDefaultOverride = Optional.of(documentationDefault);
    }

    @Override
    public void addToConfigCollection(Set<ClientConfig> configCollection) {
        this.providers.forEach(p -> configCollection.addAll(p.providerFragment().getClientConfig()));
    }

    public static class Builder
    implements SmithyBuilder<ConfigProviderChain> {
        private final List<ConfigProvider> providers = new ArrayList<ConfigProvider>();

        protected Builder() {
        }

        public Builder provider(ConfigProvider provider) {
            this.providers.add(provider);
            return this;
        }

        public Builder staticProvider(String value) {
            this.providers.add(new StaticConfigProvider(value));
            return this;
        }

        public Builder dynamicProvider(String rubyProcBody) {
            this.providers.add(new DynamicConfigProvider("proc { |cfg| " + rubyProcBody + " }"));
            return this;
        }

        public Builder dynamicProvider(ClientFragment providerFragment) {
            this.providers.add(new DynamicConfigProvider(providerFragment));
            return this;
        }

        public Builder envProvider(String environmentKey, String type) {
            this.providers.add(new EnvConfigProvider(environmentKey, type));
            return this;
        }

        public Builder sharedConfigProvider(String configKey, String type) {
            this.providers.add(new SharedConfigProvider(configKey, type));
            return this;
        }

        public ConfigProviderChain build() {
            return new ConfigProviderChain(this);
        }
    }
}

