/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import software.amazon.smithy.codegen.core.ReservedWordSymbolProvider;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.ReservedWordsBuilder;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.CaseUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyUnstableApi
public class RubySymbolProvider
implements SymbolProvider,
ShapeVisitor<Symbol> {
    public static final ReservedWordSymbolProvider.Escaper ESCAPER = ReservedWordSymbolProvider.builder().nameReservedWords(RubySymbolProvider.rubyReservedNames()).memberReservedWords(RubySymbolProvider.memberReservedNames()).buildEscaper();
    private static final String DEFAULT_DEFINITION_FILE = "types.rb";
    private final Model model;
    private final RubySettings settings;
    private final String rootModuleName;
    private final String moduleName;

    public RubySymbolProvider(Model model, RubySettings settings) {
        this.model = model;
        this.settings = settings;
        this.rootModuleName = settings.getModule();
        this.moduleName = this.rootModuleName + "::Types";
    }

    private static ReservedWords rubyReservedNames() {
        String[] reserved;
        ReservedWordsBuilder reservedNames = new ReservedWordsBuilder();
        for (String w : reserved = new String[]{"__ENCODING__", "__LINE__", "__FILE__", "BEGIN", "END", "alias", "and", "begin", "break", "case", "class", "def", "defined?", "do", "else", "elsif", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"}) {
            reservedNames.put(w, w + "_");
        }
        reservedNames.put("ApiError", "ApiError_");
        reservedNames.put("ApiClientError", "ApiClientError_");
        reservedNames.put("ApiServerError", "ApiServerError_");
        reservedNames.put("ApiRedirectError", "ApiRedirectError_");
        return reservedNames.build();
    }

    private static ReservedWords memberReservedNames() {
        String[] reserved;
        ReservedWordsBuilder reservedNames = new ReservedWordsBuilder();
        for (String w : reserved = new String[]{"!", "!=", "!~", "<=>", "==", "===", "=~", "__id__", "__send__", "class", "clone", "define_singleton_method", "display", "dup", "enum_for", "eql?", "equal?", "extend", "freeze", "frozen?", "hash", "inspect", "instance_eval", "instance_exec", "instance_of?", "instance_variable_defined?", "instance_variable_get", "instance_variable_set", "instance_variables", "is_a?", "itself", "kind_of?", "method", "methods", "nil?", "object_id", "pretty_inspect", "pretty_print", "pretty_print_cycle", "pretty_print_inspect", "pretty_print_instance_variables", "private_methods", "protected_methods", "public_method", "public_methods", "public_send", "remove_instance_variable", "respond_to?", "send", "singleton_class", "singleton_method", "singleton_methods", "taint", "tainted?", "tap", "then", "to_enum", "to_s", "trust", "untaint", "untrust", "untrusted?", "yield_self", "each_pair"}) {
            reservedNames.put(w, "member_" + w);
        }
        return reservedNames.build();
    }

    public Symbol toSymbol(Shape shape) {
        return ESCAPER.escapeSymbol(shape, (Symbol)shape.accept((ShapeVisitor)this));
    }

    public String toMemberName(MemberShape shape) {
        Shape container = this.model.expectShape(shape.getContainer());
        if (container.isUnionShape()) {
            String memberName = CaseUtils.toPascalCase((String)this.getDefaultMemberName(shape));
            if (memberName.equals("Unknown")) {
                return "MemberUnknown";
            }
            return memberName;
        }
        return this.getDefaultMemberName(shape);
    }

    public static String toMemberName(String shapeName) {
        return RubyFormatter.prefixLeadingInvalidIdentCharacters(ESCAPER.escapeMemberName(RubyFormatter.toSnakeCase(shapeName)), "member_");
    }

    private String getDefaultMemberName(MemberShape shape) {
        return RubyFormatter.prefixLeadingInvalidIdentCharacters(ESCAPER.escapeMemberName(RubyFormatter.toSnakeCase(shape.getMemberName())), "member_");
    }

    private String getDefaultShapeName(Shape shape, String prefix) {
        ServiceShape serviceShape = (ServiceShape)this.model.expectShape(this.settings.getService(), ServiceShape.class);
        return StringUtils.capitalize((String)RubyFormatter.prefixLeadingInvalidIdentCharacters(shape.getId().getName(serviceShape), prefix));
    }

    private Symbol.Builder createSymbolBuilder(Shape shape, String type, String rbsType, String docType) {
        return ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)Symbol.builder().putProperty("shape", (Object)shape)).putProperty("rbsType", (Object)rbsType)).putProperty("docType", (Object)docType)).name(type);
    }

    private Symbol.Builder createSymbolBuilder(Shape shape, String type, String rbsType, String docType, String namespace) {
        return this.createSymbolBuilder(shape, type, rbsType, docType).namespace(namespace, "::");
    }

    public Symbol stringShape(StringShape shape) {
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "String__"), "::String", "String").build();
    }

    public Symbol intEnumShape(IntEnumShape shape) {
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, ""), "::Integer", "Integer").build();
    }

    public Symbol enumShape(EnumShape shape) {
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, ""), "::String", "String").build();
    }

    public Symbol blobShape(BlobShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::String", "String").build();
    }

    public Symbol booleanShape(BooleanShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "bool", "Boolean").build();
    }

    public Symbol byteShape(ByteShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Integer", "Integer").build();
    }

    public Symbol shortShape(ShortShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Integer", "Integer").build();
    }

    public Symbol integerShape(IntegerShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Integer", "Integer").build();
    }

    public Symbol longShape(LongShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Integer", "Integer").build();
    }

    public Symbol floatShape(FloatShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Float", "Float").build();
    }

    public Symbol doubleShape(DoubleShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Float", "Float").build();
    }

    public Symbol bigIntegerShape(BigIntegerShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::Integer", "Integer").build();
    }

    public Symbol bigDecimalShape(BigDecimalShape shape) {
        return this.createSymbolBuilder((Shape)shape, "", "::BigDecimal", "BigDecimal").addDependency((SymbolDependencyContainer)RubyDependency.BIG_DECIMAL).build();
    }

    public Symbol timestampShape(TimestampShape shape) {
        RubyDependency d = RubyDependency.TIME;
        return this.createSymbolBuilder((Shape)shape, "", "::Time", "Time").addDependency((SymbolDependencyContainer)d).build();
    }

    public Symbol listShape(ListShape shape) {
        Symbol member = this.toSymbol(this.model.expectShape(shape.getMember().getTarget()));
        String rbsType = "::Array[" + member.getProperty("rbsType").get() + "]";
        String docType = "Array<" + member.getProperty("docType").get() + ">";
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "List__"), rbsType, docType, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol mapShape(MapShape shape) {
        Symbol key = this.toSymbol(this.model.expectShape(shape.getKey().getTarget()));
        Symbol value = this.toSymbol(this.model.expectShape(shape.getValue().getTarget()));
        String rbsType = "::Hash[" + key.getProperty("rbsType").get() + ", " + value.getProperty("rbsType").get() + "]";
        String docType = "Hash<" + key.getProperty("docType").get() + ", " + value.getProperty("docType").get() + ">";
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Map__"), rbsType, docType, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol documentShape(DocumentShape shape) {
        String rbsType = "document";
        String docType = "Hash, Array, String, Boolean, Numeric";
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Document__"), rbsType, docType, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol serviceShape(ServiceShape shape) {
        return this.createSymbolBuilder((Shape)shape, "Client", "::Client", "Client").namespace(this.rootModuleName, "::").definitionFile("client.rb").build();
    }

    public Symbol structureShape(StructureShape shape) {
        String name = this.getDefaultShapeName((Shape)shape, "Struct__");
        return this.createSymbolBuilder((Shape)shape, name, name, name, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol unionShape(UnionShape shape) {
        String name = this.getDefaultShapeName((Shape)shape, "Union__");
        return this.createSymbolBuilder((Shape)shape, name, name, name, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol memberShape(MemberShape shape) {
        Shape targetShape = this.model.expectShape(shape.getTarget());
        Shape containerShape = this.model.expectShape(shape.getContainer());
        if (containerShape.isUnionShape()) {
            String name = this.getDefaultShapeName(containerShape, "Union__") + "::" + this.toMemberName(shape);
            return this.createSymbolBuilder((Shape)shape, name, name, name, this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
        }
        return this.toSymbol(targetShape);
    }

    public Symbol operationShape(OperationShape shape) {
        return this.createSymbolBuilder((Shape)shape, this.getDefaultShapeName((Shape)shape, "Operation__"), "", "", this.moduleName).definitionFile(DEFAULT_DEFINITION_FILE).build();
    }

    public Symbol resourceShape(ResourceShape shape) {
        return Symbol.builder().name(this.getDefaultShapeName((Shape)shape, "Resources__")).namespace(this.moduleName, "::").build();
    }
}

