/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyIntegration;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public interface ProtocolGenerator {
    public ShapeId getProtocol();

    public ApplicationTransport getApplicationTransport();

    public void generateBuilders(GenerationContext var1);

    public void generateParsers(GenerationContext var1);

    public void generateErrors(GenerationContext var1);

    public void generateStubs(GenerationContext var1);

    default public void modifyClientMiddleware(MiddlewareBuilder middlewareBuilder, GenerationContext context) {
    }

    default public List<ClientConfig> getAdditionalClientConfig(GenerationContext context) {
        return Collections.emptyList();
    }

    default public List<String> writeAdditionalFiles(GenerationContext context) {
        return Collections.emptyList();
    }

    default public Set<RubyDependency> additionalGemDependencies(GenerationContext context) {
        return Collections.emptySet();
    }

    public static Map<ShapeId, ProtocolGenerator> collectSupportedProtocolGenerators(List<RubyIntegration> integrations) {
        HashMap<ShapeId, ProtocolGenerator> generators = new HashMap<ShapeId, ProtocolGenerator>();
        for (RubyIntegration integration : integrations) {
            for (ProtocolGenerator generator : integration.getProtocolGenerators()) {
                generators.put(generator.getProtocol(), generator);
            }
        }
        return generators;
    }

    public static Optional<ProtocolGenerator> resolve(ShapeId protocol, List<RubyIntegration> integrations) {
        for (RubyIntegration integration : integrations) {
            Optional<ProtocolGenerator> pg = integration.getProtocolGenerators().stream().filter(p -> p.getProtocol().equals((Object)protocol)).findFirst();
            if (!pg.isPresent()) continue;
            return pg;
        }
        return Optional.empty();
    }
}

