/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.knowledge.SerdeIndex;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerdeDescriptorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeUnionGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J&\u0010\u0018\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J(\u0010\u001c\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0016J.\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonSerializerGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "protocolGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;", "supportsJsonNameTrait", "", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;Z)V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "addNestedDocumentSerializers", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "documentSerializer", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "operationSerializer", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "", "payloadSerializer", "renderSerializeOperationBody", "documentMembers", "renderSerializerBody", "smithy-kotlin-codegen"})
public class JsonSerializerGenerator
implements StructuredDataSerializerGenerator {
    @NotNull
    private final ProtocolGenerator protocolGenerator;
    private final boolean supportsJsonNameTrait;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public JsonSerializerGenerator(@NotNull ProtocolGenerator protocolGenerator, boolean supportsJsonNameTrait) {
        Intrinsics.checkNotNullParameter((Object)protocolGenerator, (String)"protocolGenerator");
        this.protocolGenerator = protocolGenerator;
        this.supportsJsonNameTrait = supportsJsonNameTrait;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.EPOCH_SECONDS;
    }

    public /* synthetic */ JsonSerializerGenerator(ProtocolGenerator protocolGenerator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(protocolGenerator, bl);
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @Override
    @NotNull
    public Symbol operationSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Shape input = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Symbol symbol = ctx.getSymbolProvider().toSymbol(input);
        return SerdeExtKt.bodySerializer(op, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, op, symbol, members){
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ List<MemberShape> $members;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$op = $op;
                this.$symbol = $symbol;
                this.$members = $members;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                JsonSerializerGenerator.access$addNestedDocumentSerializers(this.this$0, this.$ctx, (Shape)this.$op, writer);
                String fnName = SerdeExtKt.bodySerializerName(this.$op);
                Object[] objectArray = new Object[]{fnName, RuntimeTypes.Core.INSTANCE.getExecutionContext(), this.$symbol};
                writer.openBlock("private fun #L(context: #T, input: #T): ByteArray {", objectArray).call(() -> operationSerializer.1.invoke$lambda-0(this.this$0, this.$ctx, this.$op, this.$members, writer)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, List $members, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
                Intrinsics.checkNotNullParameter((Object)$members, (String)"$members");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                JsonSerializerGenerator.access$renderSerializeOperationBody(this$0, $ctx, $op, $members, $writer);
            }
        }));
    }

    private final void addNestedDocumentSerializers(ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        SerdeIndex serdeIndex = SerdeIndex.Companion.of(ctx.getModel());
        Set<Shape> shapesRequiringDocumentSerializer = serdeIndex.requiresDocumentSerializer(shape);
        Iterable $this$forEach$iv = shapesRequiringDocumentSerializer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape it = (Shape)element$iv;
            boolean bl = false;
            Symbol nestedStructOrUnionSerializer = JsonSerializerGenerator.documentSerializer$default(this, ctx, it, null, 4, null);
            KotlinWriter.addImport$default(writer, nestedStructOrUnionSerializer, null, 2, null);
        }
    }

    private final void renderSerializeOperationBody(ProtocolGenerator.GenerationContext ctx, OperationShape op, List<MemberShape> documentMembers, KotlinWriter writer) {
        Shape shape = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
        writer.write("val serializer = #T()", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"shape");
        this.renderSerializerBody(ctx, shape, documentMembers, writer);
        writer.write("return serializer.toByteArray()", new Object[0]);
    }

    private final Symbol documentSerializer(ProtocolGenerator.GenerationContext ctx, Shape shape, Collection<MemberShape> members) {
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        KotlinSettings kotlinSettings = ctx.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        return SerdeExtKt.documentSerializer(shape, kotlinSettings, symbol, members, (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, this, ctx, shape, members){
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ Shape $shape;
            final /* synthetic */ Collection<MemberShape> $members;
            {
                this.$symbol = $symbol;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$shape = $shape;
                this.$members = $members;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getSerializer(), this.$symbol};
                writer.openBlock("internal fun #identifier.name:L(serializer: #T, input: #T) {", objectArray).call(() -> documentSerializer.1.invoke$lambda-0(this.this$0, this.$ctx, this.$shape, this.$members, writer)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, Shape $shape, Collection $members, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
                Intrinsics.checkNotNullParameter((Object)$members, (String)"$members");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                JsonSerializerGenerator.access$renderSerializerBody(this$0, $ctx, $shape, CollectionsKt.toList((Iterable)$members), $writer);
            }
        }));
    }

    static /* synthetic */ Symbol documentSerializer$default(JsonSerializerGenerator jsonSerializerGenerator, ProtocolGenerator.GenerationContext generationContext, Shape shape, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: documentSerializer");
        }
        if ((n & 4) != 0) {
            Collection collection2 = shape.members();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"fun documentSerializer(\n\u2026lock(\"}\")\n        }\n    }");
            collection = collection2;
        }
        return jsonSerializerGenerator.documentSerializer(generationContext, shape, collection);
    }

    private final void renderSerializerBody(ProtocolGenerator.GenerationContext ctx, Shape shape, List<MemberShape> members, KotlinWriter writer) {
        new JsonSerdeDescriptorGenerator(ProtocolGeneratorKt.toRenderingContext(ctx, this.protocolGenerator, shape, writer), members, this.supportsJsonNameTrait).render();
        if (shape.isUnionShape()) {
            new SerializeUnionGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        } else {
            new SerializeStructGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        }
    }

    @Override
    @NotNull
    public Symbol payloadSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull Shape shape, @Nullable Collection<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape target = ShapeExtKt.targetOrSelf(shape, ctx.getModel());
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        Collection collection = members;
        if (collection == null) {
            collection = target.members();
        }
        Collection forMembers = collection;
        Intrinsics.checkNotNullExpressionValue((Object)forMembers, (String)"forMembers");
        Symbol serializeFn = this.documentSerializer(ctx, target, forMembers);
        KotlinSettings kotlinSettings = ctx.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        return SerdeExtKt.payloadSerializer(target, kotlinSettings, symbol, forMembers, (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, target, symbol, serializeFn){
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ Shape $target;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ Symbol $serializeFn;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$target = $target;
                this.$symbol = $symbol;
                this.$serializeFn = $serializeFn;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                JsonSerializerGenerator.access$addNestedDocumentSerializers(this.this$0, this.$ctx, this.$target, writer);
                Object[] objectArray = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"symbol");
                SymbolReference.ContextOption[] contextOptionArray = objectArray;
                objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.USE};
                writer.addImportReferences((Symbol)contextOptionArray, (SymbolReference.ContextOption[])objectArray);
                CodeWriter codeWriter = writer;
                objectArray = new Object[1];
                Symbol symbol = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
                objectArray[0] = symbol;
                CodeWriterExtKt.withBlock(codeWriter, "internal fun #identifier.name:L(input: #T): ByteArray {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$serializeFn){
                    final /* synthetic */ Symbol $serializeFn;
                    {
                        this.$serializeFn = $serializeFn;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
                        $this$withBlock.write("val serializer = #T()", objectArray);
                        objectArray = new Object[]{this.$serializeFn};
                        $this$withBlock.write("#T(serializer, input)", objectArray);
                        $this$withBlock.write("return serializer.toByteArray()", new Object[0]);
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ void access$addNestedDocumentSerializers(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        $this.addNestedDocumentSerializers(ctx, shape, writer);
    }

    public static final /* synthetic */ void access$renderSerializeOperationBody(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, OperationShape op, List documentMembers, KotlinWriter writer) {
        $this.renderSerializeOperationBody(ctx, op, documentMembers, writer);
    }

    public static final /* synthetic */ void access$renderSerializerBody(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, List members, KotlinWriter writer) {
        $this.renderSerializerBody(ctx, shape, members, writer);
    }
}

