/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigProperty;
import software.amazon.smithy.kotlin.codegen.rendering.ServiceGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.CodeWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\rJ\b\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "(Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;)V", "service", "serviceSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "kotlin.jvm.PlatformType", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "importExternalSymbols", "", "overrideServiceName", "render", "renderCompanionObject", "renderOperation", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "renderServiceConfig", "SectionServiceCompanionObject", "SectionServiceConfig", "smithy-kotlin-codegen"})
public final class ServiceGenerator {
    @NotNull
    private final RenderingContext<ServiceShape> ctx;
    @NotNull
    private final ServiceShape service;
    private final Symbol serviceSymbol;
    @NotNull
    private final KotlinWriter writer;

    public ServiceGenerator(@NotNull RenderingContext<ServiceShape> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.ctx = ctx;
        if (!(this.ctx.getShape() != null)) {
            boolean $i$a$-require-ServiceGenerator$22 = false;
            String $i$a$-require-ServiceGenerator$22 = Intrinsics.stringPlus((String)"ServiceShape is required for generating a service interface; was: ", (Object)this.ctx.getShape());
            throw new IllegalArgumentException($i$a$-require-ServiceGenerator$22.toString());
        }
        ServiceShape serviceShape2 = this.ctx.getShape();
        if (serviceShape2 == null) {
            ServiceGenerator serviceGenerator = this;
            boolean bl = false;
            ServiceGenerator serviceGenerator2 = serviceGenerator;
            String string = "ServiceShape is required to render a service client";
            throw new IllegalArgumentException(string.toString());
        }
        this.service = serviceShape2;
        this.serviceSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.service);
        this.writer = this.ctx.getWriter();
    }

    public final void render() {
        this.importExternalSymbols();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.ctx.getModel());
        Set set = topDownIndex.getContainedOperations((ToShapeId)this.service);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"topDownIndex.getContainedOperations(service)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        List operations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OperationShape it = (OperationShape)a;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (OperationShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        OperationIndex operationsIndex = OperationIndex.of((Model)this.ctx.getModel());
        this.writer.renderDocumentation((Shape)this.service);
        this.writer.renderAnnotations((Shape)this.service);
        this.writer.openBlock("interface " + this.serviceSymbol.getName() + " : SdkClient {", new Object[0]).call(() -> ServiceGenerator.render$lambda-3(this)).call(() -> ServiceGenerator.render$lambda-4(this)).call(() -> ServiceGenerator.render$lambda-5(this)).call(() -> ServiceGenerator.render$lambda-7(operations, this, operationsIndex)).closeBlock("}", new Object[0]).write((Object)"", new Object[0]);
    }

    private final void renderServiceConfig() {
        KotlinWriterKt.declareSection((CodeWriter)this.writer, SectionServiceConfig.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"RenderingContext", this.ctx)), (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ ServiceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                new ClientConfigGenerator(ServiceGenerator.access$getCtx$p(this.this$0), false, null, new ClientConfigProperty[0], 6, null).render();
            }
        });
    }

    private final void renderCompanionObject() {
        KotlinWriterKt.withBlock((CodeWriter)this.writer, "companion object {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ ServiceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                boolean hasProtocolGenerator = ServiceGenerator.access$getCtx$p(this.this$0).getProtocolGenerator() != null;
                KotlinWriterKt.callIf($this$withBlock, hasProtocolGenerator, () -> renderCompanionObject.1.invoke$lambda-0($this$withBlock, this.this$0));
            }

            private static final void invoke$lambda-0(KotlinWriter $this_withBlock, ServiceGenerator this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this_withBlock), (String)"$this_withBlock");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                KotlinWriterKt.withBlock((CodeWriter)$this_withBlock, "operator fun invoke(block: Config.Builder.() -> Unit = {}): " + ServiceGenerator.access$getServiceSymbol$p(this$0).getName() + " {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this$0){
                    final /* synthetic */ ServiceGenerator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        $this$withBlock.write("val config = Config.Builder().apply(block).build()", new Object[0]);
                        $this$withBlock.write("return Default" + ServiceGenerator.access$getServiceSymbol$p(this.this$0).getName() + "(config)", new Object[0]);
                    }
                });
                $this_withBlock.write("", new Object[0]);
                $this_withBlock.write("operator fun invoke(config: Config): " + ServiceGenerator.access$getServiceSymbol$p(this$0).getName() + " = Default" + ServiceGenerator.access$getServiceSymbol$p(this$0).getName() + "(config)", new Object[0]);
            }
        });
    }

    private final void importExternalSymbols() {
        Symbol sdkInterfaceSymbol = Symbol.builder().name("SdkClient").namespace("aws.smithy.kotlin.runtime", ".").addDependency((SymbolDependencyContainer)KotlinDependency.Companion.getCORE()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sdkInterfaceSymbol, (String)"sdkInterfaceSymbol");
        KotlinWriter.addImport$default(this.writer, sdkInterfaceSymbol, null, 2, null);
        KotlinWriter.addImport$default(this.writer, Intrinsics.stringPlus((String)this.ctx.getSettings().getPkg().getName(), (Object)".model"), "*", null, 4, null);
    }

    private final void overrideServiceName() {
        Object[] objectArray = new Object[]{this.ctx.getSettings().getSdkId()};
        this.writer.write("", new Object[0]).write((Object)"override val serviceName: String", new Object[0]).indent().write((Object)"get() = #S", objectArray).dedent();
    }

    private final void renderOperation(OperationIndex opIndex, OperationShape op) {
        this.writer.write("", new Object[0]);
        this.writer.renderDocumentation((Shape)op);
        this.writer.renderAnnotations((Shape)op);
        this.writer.write(ShapeExtKt.operationSignature(opIndex, this.ctx.getModel(), this.ctx.getSymbolProvider(), op), new Object[0]);
        opIndex.getInput((ToShapeId)op).ifPresent(arg_0 -> ServiceGenerator.renderOperation$lambda-9(opIndex, op, this, arg_0));
    }

    private static final void render$lambda-3(ServiceGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.overrideServiceName();
    }

    private static final void render$lambda-4(ServiceGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writer.dokka(Intrinsics.stringPlus((String)this$0.serviceSymbol.getName(), (Object)"'s configuration"));
        this$0.writer.write("val config: Config", new Object[0]);
    }

    private static final void render$lambda-5(ServiceGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writer.write("", new Object[0]);
        KotlinWriterKt.declareSection((CodeWriter)this$0.writer, SectionServiceCompanionObject.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"ServiceSymbol", (Object)this$0.serviceSymbol)), (Function1)new Function1<KotlinWriter, Unit>(this$0){
            final /* synthetic */ ServiceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                ServiceGenerator.access$renderCompanionObject(this.this$0);
            }
        });
        this$0.writer.write("", new Object[0]);
        this$0.renderServiceConfig();
    }

    private static final void render$lambda-7(List $operations, ServiceGenerator this$0, OperationIndex $operationsIndex) {
        Intrinsics.checkNotNullParameter((Object)$operations, (String)"$operations");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape op = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$operationsIndex, (String)"operationsIndex");
            Intrinsics.checkNotNullExpressionValue((Object)op, (String)"op");
            this$0.renderOperation($operationsIndex, op);
        }
    }

    private static final Boolean renderOperation$lambda-9$lambda-8(ServiceGenerator this$0, StructureShape it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return ShapeExtKt.hasStreamingMember(it, this$0.ctx.getModel());
    }

    private static final void renderOperation$lambda-9(OperationIndex $opIndex, OperationShape $op, ServiceGenerator this$0, StructureShape inputShape) {
        Intrinsics.checkNotNullParameter((Object)$opIndex, (String)"$opIndex");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        Optional outputShape = $opIndex.getOutput((ToShapeId)$op);
        Boolean hasOutputStream = outputShape.map(arg_0 -> ServiceGenerator.renderOperation$lambda-9$lambda-8(this$0, arg_0)).orElse(false);
        if (!hasOutputStream.booleanValue()) {
            String input = this$0.ctx.getSymbolProvider().toSymbol((Shape)inputShape).getName();
            String operationName = NamingKt.defaultName($op);
            this$0.writer.write("", new Object[0]);
            this$0.writer.renderDocumentation((Shape)$op);
            this$0.writer.renderAnnotations((Shape)$op);
            String signature = "suspend fun " + operationName + "(block: " + input + ".Builder.() -> Unit)";
            String impl = operationName + '(' + input + ".Builder().apply(block).build())";
            this$0.writer.write(signature + " = " + impl, new Object[0]);
        }
    }

    public static final /* synthetic */ RenderingContext access$getCtx$p(ServiceGenerator $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ Symbol access$getServiceSymbol$p(ServiceGenerator $this) {
        return $this.serviceSymbol;
    }

    public static final /* synthetic */ void access$renderCompanionObject(ServiceGenerator $this) {
        $this.renderCompanionObject();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceGenerator$SectionServiceCompanionObject;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "ServiceSymbol", "", "smithy-kotlin-codegen"})
    public static final class SectionServiceCompanionObject
    implements SectionId {
        @NotNull
        public static final SectionServiceCompanionObject INSTANCE = new SectionServiceCompanionObject();
        @NotNull
        public static final String ServiceSymbol = "ServiceSymbol";

        private SectionServiceCompanionObject() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceGenerator$SectionServiceConfig;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "RenderingContext", "", "smithy-kotlin-codegen"})
    public static final class SectionServiceConfig
    implements SectionId {
        @NotNull
        public static final SectionServiceConfig INSTANCE = new SectionServiceConfig();
        @NotNull
        public static final String RenderingContext = "RenderingContext";

        private SectionServiceConfig() {
        }
    }
}

