/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.kotlin.codegen.BuildSettings;
import software.amazon.smithy.kotlin.codegen.UnresolvableProtocolException;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypesKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "", "service", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "pkg", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "sdkId", "", "build", "Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;", "(Lsoftware/amazon/smithy/model/shapes/ShapeId;Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;Ljava/lang/String;Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;)V", "getBuild", "()Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;", "getPkg", "()Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "getSdkId", "()Ljava/lang/String;", "getService", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "model", "Lsoftware/amazon/smithy/model/Model;", "resolveServiceProtocol", "serviceIndex", "Lsoftware/amazon/smithy/model/knowledge/ServiceIndex;", "supportedProtocolTraits", "", "Companion", "PackageSettings", "smithy-kotlin-codegen"})
public final class KotlinSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShapeId service;
    @NotNull
    private final PackageSettings pkg;
    @NotNull
    private final String sdkId;
    @NotNull
    private final BuildSettings build;
    @NotNull
    private static final Logger LOGGER;

    public KotlinSettings(@NotNull ShapeId service2, @NotNull PackageSettings pkg, @NotNull String sdkId, @NotNull BuildSettings build) {
        Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        this.service = service2;
        this.pkg = pkg;
        this.sdkId = sdkId;
        this.build = build;
    }

    public /* synthetic */ KotlinSettings(ShapeId shapeId, PackageSettings packageSettings, String string, BuildSettings buildSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            buildSettings = BuildSettings.Companion.getDefault();
        }
        this(shapeId, packageSettings, string, buildSettings);
    }

    @NotNull
    public final ShapeId getService() {
        return this.service;
    }

    @NotNull
    public final PackageSettings getPkg() {
        return this.pkg;
    }

    @NotNull
    public final String getSdkId() {
        return this.sdkId;
    }

    @NotNull
    public final BuildSettings getBuild() {
        return this.build;
    }

    @NotNull
    public final ServiceShape getService(@NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Object t = ((Shape)model.getShape(this.service).orElseThrow(() -> KotlinSettings.getService$lambda-0(this))).asServiceShape().orElseThrow(() -> KotlinSettings.getService$lambda-1(this));
        Intrinsics.checkNotNullExpressionValue(t, (String)"model\n        .getShape(\u2026t a service: $service\") }");
        return (ServiceShape)t;
    }

    @NotNull
    public final ShapeId resolveServiceProtocol(@NotNull ServiceIndex serviceIndex, @NotNull ServiceShape service2, @NotNull Set<ShapeId> supportedProtocolTraits) {
        ShapeId protocol;
        Object v0;
        Set resolvedProtocols;
        block2: {
            Intrinsics.checkNotNullParameter((Object)serviceIndex, (String)"serviceIndex");
            Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
            Intrinsics.checkNotNullParameter(supportedProtocolTraits, (String)"supportedProtocolTraits");
            resolvedProtocols = serviceIndex.getProtocols((ToShapeId)service2).keySet();
            Iterable $this$firstOrNull$iv = resolvedProtocols;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ShapeId p0 = (ShapeId)element$iv;
                boolean bl = false;
                if (!supportedProtocolTraits.contains(p0)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ShapeId shapeId = protocol = (ShapeId)v0;
        if (shapeId == null) {
            throw new UnresolvableProtocolException("The " + service2.getId() + " service supports the following unsupported protocols " + resolvedProtocols + ". The following protocol generators were found on the class path: " + supportedProtocolTraits);
        }
        return shapeId;
    }

    private static final CodegenException getService$lambda-0(KotlinSettings this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new CodegenException(Intrinsics.stringPlus((String)"Service shape not found: ", (Object)this$0.getService()));
    }

    private static final CodegenException getService$lambda-1(KotlinSettings this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new CodegenException(Intrinsics.stringPlus((String)"Shape is not a service: ", (Object)this$0.getService()));
    }

    static {
        Logger logger = Logger.getLogger(KotlinSettings.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KotlinSettings::class.java.name)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "", "name", "", "version", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getName", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "smithy-kotlin-codegen"})
    public static final class PackageSettings {
        @NotNull
        private final String name;
        @NotNull
        private final String version;
        @Nullable
        private final String description;

        public PackageSettings(@NotNull String name, @NotNull String version2, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            this.name = name;
            this.version = version2;
            this.description = description;
        }

        public /* synthetic */ PackageSettings(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final PackageSettings copy(@NotNull String name, @NotNull String version2, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            return new PackageSettings(name, version2, description);
        }

        public static /* synthetic */ PackageSettings copy$default(PackageSettings packageSettings, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = packageSettings.name;
            }
            if ((n & 2) != 0) {
                string2 = packageSettings.version;
            }
            if ((n & 4) != 0) {
                string3 = packageSettings.description;
            }
            return packageSettings.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PackageSettings(name=" + this.name + ", version=" + this.version + ", description=" + this.description + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageSettings)) {
                return false;
            }
            PackageSettings packageSettings = (PackageSettings)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)packageSettings.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)packageSettings.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)packageSettings.description);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$Companion;", "", "()V", "LOGGER", "Ljava/util/logging/Logger;", "from", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "model", "Lsoftware/amazon/smithy/model/Model;", "config", "Lsoftware/amazon/smithy/model/node/ObjectNode;", "inferService", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "inferService$smithy_kotlin_codegen", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSettings from(@NotNull Model model, @NotNull ObjectNode config) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Object[] objectArray = new String[]{"service", "package", "build", "sdkId"};
            config.warnIfAdditionalProperties((Collection)CollectionsKt.listOf((Object[])objectArray));
            ShapeId serviceId = config.getStringMember("service").map(StringNode::expectShapeId).orElseGet(() -> Companion.from$lambda-0(model));
            ObjectNode packageNode = config.expectObjectMember("package");
            String packageName = packageNode.expectStringMember("name").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
            if (!KotlinTypesKt.isValidPackageName(packageName)) {
                throw new CodegenException("Invalid package name, is empty or has invalid characters: '" + packageName + '\'');
            }
            String version2 = packageNode.expectStringMember("version").getValue();
            String desc = packageNode.getStringMemberOrDefault("description", Intrinsics.stringPlus((String)packageName, (Object)" client"));
            String sdkId = config.getStringMemberOrDefault("sdkId", serviceId.getName());
            Optional build = config.getObjectMember("build");
            Intrinsics.checkNotNullExpressionValue((Object)serviceId, (String)"serviceId");
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
            PackageSettings packageSettings = new PackageSettings(packageName, version2, desc);
            Intrinsics.checkNotNullExpressionValue((Object)sdkId, (String)"sdkId");
            Intrinsics.checkNotNullExpressionValue((Object)build, (String)"build");
            return new KotlinSettings(serviceId, packageSettings, sdkId, BuildSettings.Companion.fromNode(build));
        }

        @NotNull
        public final ShapeId inferService$smithy_kotlin_codegen(@NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Stream<ShapeId> stream = model.shapes(ServiceShape.class).map(Shape::getId).sorted();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"model.shapes(ServiceShap\u2026                .sorted()");
            List services = StreamsKt.toList(stream);
            if (services.isEmpty()) {
                throw new CodegenException("Cannot infer a service to generate because the model does not contain any service shapes");
            }
            if (services.size() > 1) {
                throw new CodegenException(Intrinsics.stringPlus((String)"Cannot infer service to generate because the model contains multiple service shapes: ", (Object)services));
            }
            ShapeId service2 = (ShapeId)services.get(0);
            LOGGER.info(Intrinsics.stringPlus((String)"Inferring service to generate as: ", (Object)service2));
            Intrinsics.checkNotNullExpressionValue((Object)service2, (String)"service");
            return service2;
        }

        private static final ShapeId from$lambda-0(Model $model) {
            Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
            return Companion.inferService$smithy_kotlin_codegen($model);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

