/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB1\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpTraitResolver;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "defaultContentType", "", "bindingIndex", "Lsoftware/amazon/smithy/model/knowledge/HttpBindingIndex;", "topDownIndex", "Lsoftware/amazon/smithy/model/knowledge/TopDownIndex;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/lang/String;Lsoftware/amazon/smithy/model/knowledge/HttpBindingIndex;Lsoftware/amazon/smithy/model/knowledge/TopDownIndex;)V", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/model/shapes/ServiceShape;Ljava/lang/String;Lsoftware/amazon/smithy/model/knowledge/HttpBindingIndex;Lsoftware/amazon/smithy/model/knowledge/TopDownIndex;)V", "bindingOperations", "", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "determineRequestContentType", "operationShape", "determineTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "member", "Lsoftware/amazon/smithy/model/shapes/ToShapeId;", "location", "Lsoftware/amazon/smithy/model/knowledge/HttpBinding$Location;", "defaultFormat", "httpTrait", "Lsoftware/amazon/smithy/model/traits/HttpTrait;", "requestBindings", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingDescriptor;", "responseBindings", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "smithy-kotlin-codegen"})
public final class HttpTraitResolver
implements HttpBindingResolver {
    @NotNull
    private final Model model;
    @NotNull
    private final ServiceShape serviceShape;
    @NotNull
    private final String defaultContentType;
    @NotNull
    private final HttpBindingIndex bindingIndex;
    @NotNull
    private final TopDownIndex topDownIndex;

    public HttpTraitResolver(@NotNull Model model, @NotNull ServiceShape serviceShape2, @NotNull String defaultContentType, @NotNull HttpBindingIndex bindingIndex, @NotNull TopDownIndex topDownIndex) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape2, (String)"serviceShape");
        Intrinsics.checkNotNullParameter((Object)defaultContentType, (String)"defaultContentType");
        Intrinsics.checkNotNullParameter((Object)bindingIndex, (String)"bindingIndex");
        Intrinsics.checkNotNullParameter((Object)topDownIndex, (String)"topDownIndex");
        this.model = model;
        this.serviceShape = serviceShape2;
        this.defaultContentType = defaultContentType;
        this.bindingIndex = bindingIndex;
        this.topDownIndex = topDownIndex;
    }

    public /* synthetic */ HttpTraitResolver(Model model, ServiceShape serviceShape2, String string, HttpBindingIndex httpBindingIndex, TopDownIndex topDownIndex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        HttpBindingIndex httpBindingIndex2;
        if ((n & 8) != 0) {
            httpBindingIndex2 = HttpBindingIndex.of((Model)model);
            Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex2, (String)"class HttpTraitResolver(\n    private val model: Model,\n    private val serviceShape: ServiceShape,\n    private val defaultContentType: String,\n    private val bindingIndex: HttpBindingIndex = HttpBindingIndex.of(model),\n    private val topDownIndex: TopDownIndex = TopDownIndex.of(model)\n) : HttpBindingResolver {\n    /**\n     * @param ctx [ProtocolGenerator.GenerationContext]\n     * @param defaultContentType content-type\n     * @param bindingIndex [HttpBindingIndex]\n     * @param topDownIndex [TopDownIndex]\n     */\n    constructor(\n        ctx: ProtocolGenerator.GenerationContext,\n        defaultContentType: String,\n        bindingIndex: HttpBindingIndex = HttpBindingIndex.of(ctx.model),\n        topDownIndex: TopDownIndex = TopDownIndex.of(ctx.model)\n    ) : this(ctx.model, ctx.service, defaultContentType, bindingIndex, topDownIndex)\n\n    override fun bindingOperations(): List<OperationShape> = topDownIndex\n        .getContainedOperations(serviceShape)\n        .filter { op -> op.hasTrait<HttpTrait>() }\n        .toList<OperationShape>()\n\n    override fun httpTrait(operationShape: OperationShape): HttpTrait = operationShape.expectTrait()\n\n    override fun requestBindings(operationShape: OperationShape): List<HttpBindingDescriptor> = bindingIndex\n        .getRequestBindings(operationShape)\n        .values\n        .map { HttpBindingDescriptor(it) }\n\n    override fun responseBindings(shape: Shape): List<HttpBindingDescriptor> = when (shape) {\n        is OperationShape,\n        is StructureShape -> bindingIndex.getResponseBindings(shape.toShapeId()).values.map { HttpBindingDescriptor(it) }\n        else -> error { \"Unimplemented resolving bindings for ${shape.javaClass.canonicalName}\" }\n    }\n\n    override fun determineRequestContentType(operationShape: OperationShape): String = bindingIndex\n        .determineRequestContentType(operationShape, defaultContentType)\n        .orElse(defaultContentType)\n\n    override fun determineTimestampFormat(\n        member: ToShapeId,\n        location: HttpBinding.Location,\n        defaultFormat: TimestampFormatTrait.Format\n    ): TimestampFormatTrait.Format =\n        bindingIndex.determineTimestampFormat(member, location, defaultFormat)\n}");
            httpBindingIndex = httpBindingIndex2;
        }
        if ((n & 0x10) != 0) {
            httpBindingIndex2 = TopDownIndex.of((Model)model);
            Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex2, (String)"class HttpTraitResolver(\n    private val model: Model,\n    private val serviceShape: ServiceShape,\n    private val defaultContentType: String,\n    private val bindingIndex: HttpBindingIndex = HttpBindingIndex.of(model),\n    private val topDownIndex: TopDownIndex = TopDownIndex.of(model)\n) : HttpBindingResolver {\n    /**\n     * @param ctx [ProtocolGenerator.GenerationContext]\n     * @param defaultContentType content-type\n     * @param bindingIndex [HttpBindingIndex]\n     * @param topDownIndex [TopDownIndex]\n     */\n    constructor(\n        ctx: ProtocolGenerator.GenerationContext,\n        defaultContentType: String,\n        bindingIndex: HttpBindingIndex = HttpBindingIndex.of(ctx.model),\n        topDownIndex: TopDownIndex = TopDownIndex.of(ctx.model)\n    ) : this(ctx.model, ctx.service, defaultContentType, bindingIndex, topDownIndex)\n\n    override fun bindingOperations(): List<OperationShape> = topDownIndex\n        .getContainedOperations(serviceShape)\n        .filter { op -> op.hasTrait<HttpTrait>() }\n        .toList<OperationShape>()\n\n    override fun httpTrait(operationShape: OperationShape): HttpTrait = operationShape.expectTrait()\n\n    override fun requestBindings(operationShape: OperationShape): List<HttpBindingDescriptor> = bindingIndex\n        .getRequestBindings(operationShape)\n        .values\n        .map { HttpBindingDescriptor(it) }\n\n    override fun responseBindings(shape: Shape): List<HttpBindingDescriptor> = when (shape) {\n        is OperationShape,\n        is StructureShape -> bindingIndex.getResponseBindings(shape.toShapeId()).values.map { HttpBindingDescriptor(it) }\n        else -> error { \"Unimplemented resolving bindings for ${shape.javaClass.canonicalName}\" }\n    }\n\n    override fun determineRequestContentType(operationShape: OperationShape): String = bindingIndex\n        .determineRequestContentType(operationShape, defaultContentType)\n        .orElse(defaultContentType)\n\n    override fun determineTimestampFormat(\n        member: ToShapeId,\n        location: HttpBinding.Location,\n        defaultFormat: TimestampFormatTrait.Format\n    ): TimestampFormatTrait.Format =\n        bindingIndex.determineTimestampFormat(member, location, defaultFormat)\n}");
            topDownIndex = httpBindingIndex2;
        }
        this(model, serviceShape2, string, httpBindingIndex, topDownIndex);
    }

    public HttpTraitResolver(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull String defaultContentType, @NotNull HttpBindingIndex bindingIndex, @NotNull TopDownIndex topDownIndex) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)defaultContentType, (String)"defaultContentType");
        Intrinsics.checkNotNullParameter((Object)bindingIndex, (String)"bindingIndex");
        Intrinsics.checkNotNullParameter((Object)topDownIndex, (String)"topDownIndex");
        this(ctx.getModel(), ctx.getService(), defaultContentType, bindingIndex, topDownIndex);
    }

    public /* synthetic */ HttpTraitResolver(ProtocolGenerator.GenerationContext generationContext, String string, HttpBindingIndex httpBindingIndex, TopDownIndex topDownIndex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        HttpBindingIndex httpBindingIndex2;
        if ((n & 4) != 0) {
            httpBindingIndex2 = HttpBindingIndex.of((Model)generationContext.getModel());
            Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex2, (String)"constructor(\n        ctx: ProtocolGenerator.GenerationContext,\n        defaultContentType: String,\n        bindingIndex: HttpBindingIndex = HttpBindingIndex.of(ctx.model),\n        topDownIndex: TopDownIndex = TopDownIndex.of(ctx.model)\n    ) : this(ctx.model, ctx.service, defaultContentType, bindingIndex, topDownIndex)");
            httpBindingIndex = httpBindingIndex2;
        }
        if ((n & 8) != 0) {
            httpBindingIndex2 = TopDownIndex.of((Model)generationContext.getModel());
            Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex2, (String)"constructor(\n        ctx: ProtocolGenerator.GenerationContext,\n        defaultContentType: String,\n        bindingIndex: HttpBindingIndex = HttpBindingIndex.of(ctx.model),\n        topDownIndex: TopDownIndex = TopDownIndex.of(ctx.model)\n    ) : this(ctx.model, ctx.service, defaultContentType, bindingIndex, topDownIndex)");
            topDownIndex = httpBindingIndex2;
        }
        this(generationContext, string, httpBindingIndex, topDownIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<OperationShape> bindingOperations() {
        void $this$filterTo$iv$iv;
        Set set = this.topDownIndex.getContainedOperations((ToShapeId)this.serviceShape);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"topDownIndex\n        .getContainedOperations(serviceShape)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OperationShape op = (OperationShape)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)op, (String)"op");
            Shape $this$hasTrait$iv = (Shape)op;
            boolean $i$f$hasTrait = false;
            if (!$this$hasTrait$iv.hasTrait(HttpTrait.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public HttpTrait httpTrait(@NotNull OperationShape operationShape2) {
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        Shape $this$expectTrait$iv = (Shape)operationShape2;
        boolean $i$f$expectTrait = false;
        Trait trait = $this$expectTrait$iv.expectTrait(HttpTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(T::class.java)");
        return (HttpTrait)trait;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> requestBindings(@NotNull OperationShape operationShape2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        Iterable $this$map$iv = this.bindingIndex.getRequestBindings((ToShapeId)operationShape2).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HttpBinding httpBinding = (HttpBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            HttpBindingDescriptor httpBindingDescriptor = new HttpBindingDescriptor((HttpBinding)it);
            collection.add(httpBindingDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> responseBindings(@NotNull Shape shape) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape2 = shape;
        if (shape2 instanceof OperationShape ? true : shape2 instanceof StructureShape) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bindingIndex.getResponseBindings((ToShapeId)shape.toShapeId()).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HttpBinding httpBinding = (HttpBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                HttpBindingDescriptor httpBindingDescriptor = new HttpBindingDescriptor((HttpBinding)it);
                collection.add(httpBindingDescriptor);
            }
        } else {
            Function0<String> function0 = new Function0<String>(shape){
                final /* synthetic */ Shape $shape;
                {
                    this.$shape = $shape;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Unimplemented resolving bindings for ", (Object)this.$shape.getClass().getCanonicalName());
                }
            };
            boolean bl = false;
            throw (Throwable)new IllegalStateException(function0.toString());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String determineRequestContentType(@NotNull OperationShape operationShape2) {
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        String string = this.bindingIndex.determineRequestContentType((ToShapeId)operationShape2, this.defaultContentType).orElse(this.defaultContentType);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bindingIndex\n        .determineRequestContentType(operationShape, defaultContentType)\n        .orElse(defaultContentType)");
        return string;
    }

    @Override
    @NotNull
    public TimestampFormatTrait.Format determineTimestampFormat(@NotNull ToShapeId member, @NotNull HttpBinding.Location location, @NotNull TimestampFormatTrait.Format defaultFormat) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)defaultFormat, (String)"defaultFormat");
        TimestampFormatTrait.Format format = this.bindingIndex.determineTimestampFormat(member, location, defaultFormat);
        Intrinsics.checkNotNullExpressionValue((Object)format, (String)"bindingIndex.determineTimestampFormat(member, location, defaultFormat)");
        return format;
    }
}

