/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.endpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.model.RulesEngineExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointParametersGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.KotlinEndpointParameter;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Deprecated;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.rulesengine.language.syntax.parameters.ParameterType;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/EndpointParametersGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "rules", "Lsoftware/amazon/smithy/rulesengine/language/EndpointRuleSet;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Lsoftware/amazon/smithy/rulesengine/language/EndpointRuleSet;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;)V", "params", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/KotlinEndpointParameter;", "paramsSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "render", "", "renderFields", "renderDocumentation", "renderCompanionObject", "renderEquals", "renderHashCode", "renderToString", "renderCopy", "renderBuilder", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nEndpointParametersGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointParametersGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/EndpointParametersGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1056#2:193\n1563#2:194\n1634#2,3:195\n1869#2,2:198\n1869#2,2:200\n1869#2,2:202\n1878#2,3:204\n1869#2,2:207\n1869#2,2:209\n*S KotlinDebug\n*F\n+ 1 EndpointParametersGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/EndpointParametersGenerator\n*L\n40#1:193\n41#1:194\n41#1:195,3\n78#1:198,2\n107#1:200,2\n124#1:202,2\n135#1:204,3\n145#1:207,2\n157#1:209,2\n*E\n"})
public final class EndpointParametersGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final List<KotlinEndpointParameter> params;
    @NotNull
    private final Symbol paramsSymbol;

    /*
     * WARNING - void declaration
     */
    public EndpointParametersGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @Nullable EndpointRuleSet rules, @NotNull KotlinWriter writer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        this.ctx = ctx;
        this.writer = writer;
        Object object = rules;
        if (object == null || (object = object.getParameters()) == null || (object = object.toList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterable iterable = (Iterable)object;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Parameter it = (Parameter)a;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Comparable comparable = (Comparable)((Object)RulesEngineExtKt.defaultName(it));
                it = (Parameter)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)RulesEngineExtKt.defaultName(it))));
            }
        });
        EndpointParametersGenerator endpointParametersGenerator = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Parameter parameter = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string = RulesEngineExtKt.defaultName((Parameter)it);
            ParameterType parameterType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)parameterType, (String)"getType(...)");
            Symbol symbol = RulesEngineExtKt.toSymbol(parameterType);
            boolean bl2 = it.isRequired();
            Optional optional = it.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getDefault(...)");
            Object object2 = (Value)OptionalExtKt.getOrNull(optional);
            if (object2 == null || (object2 = RulesEngineExtKt.toLiteral(object2)) == null) {
                object2 = "null";
            }
            Optional optional2 = it.getDocumentation();
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getDocumentation(...)");
            String string2 = (String)OptionalExtKt.getOrNull(optional2);
            Optional optional3 = it.getDeprecated();
            Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"getDeprecated(...)");
            collection.add(new KotlinEndpointParameter(string, symbol, bl2, (String)object2, string2, (Deprecated)OptionalExtKt.getOrNull(optional3)));
        }
        endpointParametersGenerator.params = (List)destination$iv$iv;
        this.paramsSymbol = Companion.getSymbol(this.ctx.getSettings());
    }

    public final void render() {
        this.renderDocumentation();
        Object[] objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.paramsSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "#L class #T private constructor(builder: Builder) {", "}", objectArray, arg_0 -> EndpointParametersGenerator.render$lambda$2(this, arg_0));
    }

    private final void renderFields() {
        Iterable $this$forEach$iv = this.params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEndpointParameter it = (KotlinEndpointParameter)element$iv;
            boolean bl = false;
            String initialValueExpr = it.isRequired() ? "requireNotNull(builder." + it.getName() + ") { \"endpoint provider parameter #" + it.getName() + " is required\" }" : "builder." + it.getName();
            EndpointParametersGeneratorKt.access$ensureSuppressDeprecation(this.writer, it);
            EndpointParametersGeneratorKt.renderDeclaration$default(it, this.writer, initialValueExpr, false, 4, null);
            this.writer.write("", new Object[0]);
        }
    }

    private final void renderDocumentation() {
        this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)EndpointParametersGenerator::renderDocumentation$lambda$4));
    }

    private final void renderCompanionObject() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public companion object {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderCompanionObject$lambda$5(this, arg_0));
    }

    private final void renderEquals() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public override fun equals(other: Any?): Boolean {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderEquals$lambda$7(this, arg_0));
    }

    private final void renderHashCode() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public override fun hashCode(): Int {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderHashCode$lambda$9(this, arg_0));
    }

    private final void renderToString() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public override fun toString(): String = buildString {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderToString$lambda$11(this, arg_0));
    }

    private final void renderCopy() {
        Object[] objectArray = new Object[]{this.paramsSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public fun copy(block: Builder.() -> Unit = {}): #T {", "}", objectArray, arg_0 -> EndpointParametersGenerator.renderCopy$lambda$14(this, arg_0));
    }

    private final void renderBuilder() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public class Builder {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderBuilder$lambda$16(this, arg_0));
    }

    private static final Unit render$lambda$2(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.renderFields();
        this$0.renderCompanionObject();
        $this$withBlock.write("", new Object[0]);
        this$0.renderEquals();
        $this$withBlock.write("", new Object[0]);
        this$0.renderHashCode();
        $this$withBlock.write("", new Object[0]);
        this$0.renderToString();
        $this$withBlock.write("", new Object[0]);
        this$0.renderCopy();
        $this$withBlock.write("", new Object[0]);
        this$0.renderBuilder();
        return Unit.INSTANCE;
    }

    private static final Unit renderDocumentation$lambda$4(KotlinWriter $this$dokka) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
        $this$dokka.write("The set of values necessary for endpoint resolution.", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$5(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.paramsSymbol};
        $this$withBlock.write("public inline operator fun invoke(block: Builder.() -> Unit): #T = Builder().apply(block).build()", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderEquals$lambda$7(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("if (this === other) return true", new Object[0]);
        Object[] objectArray = new Object[]{this$0.paramsSymbol};
        $this$withBlock.write("if (other !is #T) return false", objectArray);
        Iterable $this$forEach$iv = this$0.params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEndpointParameter it = (KotlinEndpointParameter)element$iv;
            boolean bl = false;
            EndpointParametersGeneratorKt.access$ensureSuppressDeprecation($this$withBlock, it);
            Object[] objectArray2 = new Object[]{it.getName()};
            $this$withBlock.write("if (this.#1L != other.#1L) return false", objectArray2);
        }
        $this$withBlock.write("return true", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderHashCode$lambda$9(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        if (this$0.params.isEmpty()) {
            $this$withBlock.write("return this::class.hashCode()", new Object[0]);
            return Unit.INSTANCE;
        }
        EndpointParametersGeneratorKt.access$ensureSuppressDeprecation($this$withBlock, this$0.params.get(0));
        Object[] objectArray = new Object[]{this$0.params.get(0).getName()};
        $this$withBlock.write("var result = #L?.hashCode() ?: 0", objectArray);
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)this$0.params, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEndpointParameter it = (KotlinEndpointParameter)element$iv;
            boolean bl = false;
            EndpointParametersGeneratorKt.access$ensureSuppressDeprecation($this$withBlock, it);
            Object[] objectArray2 = new Object[]{it.getName()};
            $this$withBlock.write("result = 31 * result + (#L?.hashCode() ?: 0)", objectArray2);
        }
        $this$withBlock.write("return result", new Object[0]);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderToString$lambda$11(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.paramsSymbol.getName()};
        $this$withBlock.write("append(\"#L(\")", objectArray);
        Iterable $this$forEachIndexed$iv = this$0.params;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinEndpointParameter kotlinEndpointParameter = (KotlinEndpointParameter)item$iv;
            int index = n;
            boolean bl = false;
            EndpointParametersGeneratorKt.access$ensureSuppressDeprecation($this$withBlock, (KotlinEndpointParameter)it);
            Object[] objectArray2 = new Object[]{it.getName(), index < this$0.params.size() - 1 ? "," : ")"};
            $this$withBlock.write("append(\"#1L=$#1L#2L\")", objectArray2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderCopy$lambda$14$lambda$13(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = this$0.params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEndpointParameter it = (KotlinEndpointParameter)element$iv;
            boolean bl = false;
            EndpointParametersGeneratorKt.access$ensureSuppressDeprecation($this$withBlock, it);
            Object[] objectArray = new Object[]{it.getName(), this$0.paramsSymbol.getName()};
            $this$withBlock.write("#1L = this@#2L.#1L", objectArray);
        }
        $this$withBlock.write("block()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderCopy$lambda$14(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "return Builder().apply {", "}", new Object[0], arg_0 -> EndpointParametersGenerator.renderCopy$lambda$14$lambda$13(this$0, arg_0));
        $this$withBlock.write(".build()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderBuilder$lambda$16(EndpointParametersGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = this$0.params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEndpointParameter it = (KotlinEndpointParameter)element$iv;
            boolean bl = false;
            EndpointParametersGeneratorKt.access$renderDeclaration(it, this$0.writer, it.getDefaultLiteral(), true);
        }
        $this$withBlock.write("", new Object[0]);
        Object[] objectArray = new Object[]{this$0.paramsSymbol};
        $this$withBlock.write("public fun build(): #1T = #1T(this)", objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/EndpointParametersGenerator$Companion;", "", "<init>", "()V", "getSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Symbol getSymbol(@NotNull KotlinSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)arg_0 -> Companion.getSymbol$lambda$0(settings, arg_0)));
        }

        private static final Unit getSymbol$lambda$0(KotlinSettings $settings, SymbolBuilder $this$buildSymbol) {
            Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
            String prefix = NamingKt.clientName($settings.getSdkId());
            $this$buildSymbol.setName(prefix + "EndpointParameters");
            $this$buildSymbol.setNamespace($settings.getPkg().getName() + ".endpoints");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

