/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.ServiceClientConfigGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;)V", "service", "serviceSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "kotlin.jvm.PlatformType", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "render", "", "renderServiceConfig", "renderServiceBuilder", "renderCompanionObject", "renderOperation", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "renderWithConfig", "renderOperationDslOverload", "Sections", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nServiceClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1#2:272\n1053#3:273\n1863#3,2:274\n1863#3,2:276\n1863#3,2:278\n*S KotlinDebug\n*F\n+ 1 ServiceClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator\n*L\n92#1:273\n126#1:274,2\n217#1:276,2\n117#1:278,2\n*E\n"})
public final class ServiceClientGenerator {
    @NotNull
    private final RenderingContext<ServiceShape> ctx;
    @NotNull
    private final ServiceShape service;
    private final Symbol serviceSymbol;
    @NotNull
    private final KotlinWriter writer;

    public ServiceClientGenerator(@NotNull RenderingContext<ServiceShape> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.ctx = ctx;
        if (!(this.ctx.getShape() != null)) {
            boolean $i$a$-require-ServiceClientGenerator$22 = false;
            String $i$a$-require-ServiceClientGenerator$22 = "ServiceShape is required for generating a service interface; was: " + this.ctx.getShape();
            throw new IllegalArgumentException($i$a$-require-ServiceClientGenerator$22.toString());
        }
        ServiceShape serviceShape = this.ctx.getShape();
        if (serviceShape == null) {
            ServiceClientGenerator serviceClientGenerator = this;
            boolean bl = false;
            ServiceClientGenerator serviceClientGenerator2 = serviceClientGenerator;
            String string = "ServiceShape is required to render a service client";
            throw new IllegalArgumentException(string.toString());
        }
        this.service = serviceShape;
        this.serviceSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.service);
        this.writer = this.ctx.getWriter();
    }

    public final void render() {
        this.writer.write("\n\n", new Object[0]);
        Object[] objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.ctx.getSettings().getSdkId()};
        this.writer.write("#L const val ServiceId: String = #S", objectArray);
        objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.ctx.getSettings().getPkg().getVersion()};
        this.writer.write("#L const val SdkVersion: String = #S", objectArray);
        objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.service.getVersion()};
        this.writer.write("#L const val ServiceApiVersion: String = #S", objectArray);
        this.writer.write("\n\n", new Object[0]);
        this.writer.putContext("service.name", this.ctx.getSettings().getSdkId());
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.ctx.getModel());
        Set set = topDownIndex.getContainedOperations((ToShapeId)this.service);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy22 = false;
        List operations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OperationShape it = (OperationShape)a;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (OperationShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        OperationIndex operationsIndex = OperationIndex.of((Model)this.ctx.getModel());
        this.writer.renderDocumentation((Shape)this.service);
        this.writer.renderAnnotations((Shape)this.service);
        Object[] $i$f$sortedBy22 = new Object[]{this.ctx.getSettings().getApi().getVisibility(), RuntimeTypes.SmithyClient.INSTANCE.getSdkClient()};
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "#L interface " + this.serviceSymbol.getName() + " : #T {", "}", $i$f$sortedBy22, arg_0 -> ServiceClientGenerator.render$lambda$4(this, operations, operationsIndex, arg_0))).write("", new Object[0]);
        if (this.ctx.getProtocolGenerator() != null) {
            this.renderWithConfig();
            this.writer.write("", new Object[0]);
        }
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape it = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)operationsIndex);
            Intrinsics.checkNotNull((Object)it);
            this.renderOperationDslOverload(operationsIndex, it);
        }
    }

    private final void renderServiceConfig() {
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)this.writer, Sections.ServiceConfig.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.ServiceConfig.INSTANCE.getRenderingContext(), this.ctx)), arg_0 -> ServiceClientGenerator.renderServiceConfig$lambda$6(this, arg_0));
    }

    private final void renderServiceBuilder() {
        if (this.ctx.getProtocolGenerator() == null) {
            return;
        }
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)this.writer, Sections.ServiceBuilder.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.ServiceBuilder.INSTANCE.getRenderingContext(), this.ctx)), arg_0 -> ServiceClientGenerator.renderServiceBuilder$lambda$8(this, arg_0));
    }

    private final void renderCompanionObject() {
        if (this.ctx.getProtocolGenerator() == null) {
            return;
        }
        AbstractCodeWriter abstractCodeWriter = this.writer.writeInline("public companion object : ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"writeInline(...)");
        AbstractCodeWriterExtKt.withBlock(AbstractCodeWriterExtKt.declareSection(abstractCodeWriter, Sections.CompanionObject.SuperTypes.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.CompanionObject.INSTANCE.getServiceSymbol(), (Object)this.serviceSymbol)), arg_0 -> ServiceClientGenerator.renderCompanionObject$lambda$9(this, arg_0)), " {", "}", new Object[0], arg_0 -> ServiceClientGenerator.renderCompanionObject$lambda$13(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderOperation(OperationIndex opIndex, OperationShape op) {
        void $this$forEach$iv;
        this.writer.write("", new Object[0]);
        this.writer.renderDocumentation((Shape)op);
        this.writer.renderAnnotations((Shape)op);
        String signature = ShapeExtKt.operationSignature(opIndex, this.ctx.getModel(), this.ctx.getSymbolProvider(), op, true);
        Object[] objectArray = new Symbol[]{this.ctx.getSymbolProvider().toSymbol(this.ctx.getModel().expectShape(op.getInputShape())), this.ctx.getSymbolProvider().toSymbol(this.ctx.getModel().expectShape(op.getOutputShape()))};
        objectArray = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Symbol it = (Symbol)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            KotlinWriter.addImport$default(this.writer, it, null, 2, null);
        }
        objectArray = new Object[]{signature};
        this.writer.write("public #L", objectArray);
    }

    private final void renderWithConfig() {
        this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)ServiceClientGenerator::renderWithConfig$lambda$15));
        Object[] objectArray = new Object[]{this.ctx.getSettings().getApi().getVisibility(), this.serviceSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "#1L fun #2T.withConfig(block: #2T.Config.Builder.() -> Unit): #2T {", "}", objectArray, arg_0 -> ServiceClientGenerator.renderWithConfig$lambda$16(this, arg_0));
    }

    private final void renderOperationDslOverload(OperationIndex opIndex, OperationShape op) {
        opIndex.getInput((ToShapeId)op).ifPresent(arg_0 -> ServiceClientGenerator.renderOperationDslOverload$lambda$20(arg_0 -> ServiceClientGenerator.renderOperationDslOverload$lambda$19(opIndex, op, this, arg_0), arg_0));
    }

    private static final Unit render$lambda$4(ServiceClientGenerator this$0, List $operations, OperationIndex $operationsIndex, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.dokka(this$0.serviceSymbol.getName() + "'s configuration");
        $this$withBlock.write("public override val config: Config", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        this$0.renderCompanionObject();
        $this$withBlock.write("", new Object[0]);
        this$0.renderServiceBuilder();
        $this$withBlock.write("", new Object[0]);
        this$0.renderServiceConfig();
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape it = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$operationsIndex);
            Intrinsics.checkNotNull((Object)it);
            this$0.renderOperation($operationsIndex, it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderServiceConfig$lambda$6(ServiceClientGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        new ServiceClientConfigGenerator(this$0.service, false, 2, null).render(this$0.ctx, this$0.ctx.getWriter());
        return Unit.INSTANCE;
    }

    private static final Unit renderServiceBuilder$lambda$8$lambda$7(ServiceClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("override val config: Config.Builder = Config.Builder()", new Object[0]);
        Object[] objectArray = new Object[]{this$0.serviceSymbol};
        $this$withBlock.write("override fun newClient(config: Config): #T = Default" + this$0.serviceSymbol.getName() + "(config)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderServiceBuilder$lambda$8(ServiceClientGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        Object[] objectArray = new Object[]{RuntimeTypes.SmithyClient.INSTANCE.getAbstractSdkClientBuilder(), this$0.serviceSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "public class Builder internal constructor(): #T<Config, Config.Builder, #T>() {", "}", objectArray, arg_0 -> ServiceClientGenerator.renderServiceBuilder$lambda$8$lambda$7(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$9(ServiceClientGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        Object[] objectArray = new Object[]{RuntimeTypes.SmithyClient.INSTANCE.getAbstractSdkClientFactory(), this$0.serviceSymbol};
        $this$declareSection.writeInline("#T<Config, Config.Builder, #T, Builder>()", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$13$lambda$12$lambda$11$lambda$10(KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        $this$declareSection.write("super.finalizeConfig(builder)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$13$lambda$12$lambda$11(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.declareSection$default($this$withBlock, Sections.CompanionObject.FinalizeConfig.INSTANCE, null, ServiceClientGenerator::renderCompanionObject$lambda$13$lambda$12$lambda$11$lambda$10, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$13$lambda$12(KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        Object[] objectArray = new Object[]{KotlinTypes.Jvm.INSTANCE.getJvmStatic()};
        $this$declareSection.write("@#T", objectArray);
        $this$declareSection.write("override fun builder(): Builder = Builder()", new Object[0]);
        $this$declareSection.write("", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$declareSection, "override fun finalizeConfig(builder: Builder) {", "}", new Object[0], ServiceClientGenerator::renderCompanionObject$lambda$13$lambda$12$lambda$11);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$13(ServiceClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Pair[] pairArray = new Pair[]{TuplesKt.to(Sections.CompanionObject.INSTANCE.getServiceSymbol(), (Object)this$0.serviceSymbol), TuplesKt.to(Sections.CompanionObject.INSTANCE.getSdkId(), (Object)this$0.ctx.getSettings().getSdkId())};
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)$this$withBlock, Sections.CompanionObject.INSTANCE, MapsKt.mapOf((Pair[])pairArray), ServiceClientGenerator::renderCompanionObject$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit renderWithConfig$lambda$15(KotlinWriter $this$dokka) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
        $this$dokka.write("Create a copy of the client with one or more configuration values overridden.", new Object[0]);
        $this$dokka.write("This method allows the caller to perform scoped config overrides for one or more client operations.", new Object[0]);
        $this$dokka.write("", new Object[0]);
        $this$dokka.write("Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.", new Object[0]);
        $this$dokka.write("If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderWithConfig$lambda$16(ServiceClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("val newConfig = config.toBuilder().apply(block).build()", new Object[0]);
        Object[] objectArray = new Object[]{this$0.serviceSymbol.getName()};
        $this$withBlock.write("return Default#L(newConfig)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderOperationDslOverload$lambda$19$lambda$17(ServiceClientGenerator this$0, StructureShape $inputShape, OperationShape $op, StructureShape outputShape) {
        Intrinsics.checkNotNullParameter((Object)outputShape, (String)"outputShape");
        boolean hasOutputStream = ShapeExtKt.hasStreamingMember(outputShape, this$0.ctx.getModel());
        if (!hasOutputStream) {
            Symbol inputSymbol = this$0.ctx.getSymbolProvider().toSymbol((Shape)$inputShape);
            Symbol outputSymbol = this$0.ctx.getSymbolProvider().toSymbol((Shape)outputShape);
            String operationName = NamingKt.defaultName($op);
            this$0.writer.write("", new Object[0]);
            this$0.writer.renderDocumentation((Shape)$op);
            this$0.writer.renderAnnotations((Shape)$op);
            Object[] objectArray = new Object[]{this$0.ctx.getSettings().getApi().getVisibility(), this$0.serviceSymbol, operationName, inputSymbol, outputSymbol, operationName, inputSymbol};
            this$0.writer.write("#L suspend inline fun #T.#L(crossinline block: #T.Builder.() -> Unit): #T = #L(#T.Builder().apply(block).build())", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final void renderOperationDslOverload$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit renderOperationDslOverload$lambda$19(OperationIndex $opIndex, OperationShape $op, ServiceClientGenerator this$0, StructureShape inputShape) {
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        $opIndex.getOutput((ToShapeId)$op).ifPresent(arg_0 -> ServiceClientGenerator.renderOperationDslOverload$lambda$19$lambda$18(arg_0 -> ServiceClientGenerator.renderOperationDslOverload$lambda$19$lambda$17(this$0, inputShape, $op, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void renderOperationDslOverload$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections;", "", "<init>", "()V", "ServiceBuilder", "CompanionObject", "ServiceConfig", "smithy-kotlin-codegen"})
    public static final class Sections {
        @NotNull
        public static final Sections INSTANCE = new Sections();

        private Sections() {
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$CompanionObject;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "ServiceSymbol", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "getServiceSymbol", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "SdkId", "", "getSdkId", "FinalizeConfig", "SuperTypes", "smithy-kotlin-codegen"})
        public static final class CompanionObject
        implements SectionId {
            @NotNull
            public static final CompanionObject INSTANCE = new CompanionObject();
            @NotNull
            private static final SectionKey<Symbol> ServiceSymbol = new SectionKey("ServiceSymbol");
            @NotNull
            private static final SectionKey<String> SdkId = new SectionKey("SdkId");

            private CompanionObject() {
            }

            @NotNull
            public final SectionKey<Symbol> getServiceSymbol() {
                return ServiceSymbol;
            }

            @NotNull
            public final SectionKey<String> getSdkId() {
                return SdkId;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$CompanionObject$FinalizeConfig;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "smithy-kotlin-codegen"})
            public static final class FinalizeConfig
            implements SectionId {
                @NotNull
                public static final FinalizeConfig INSTANCE = new FinalizeConfig();

                private FinalizeConfig() {
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$CompanionObject$SuperTypes;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "smithy-kotlin-codegen"})
            public static final class SuperTypes
            implements SectionId {
                @NotNull
                public static final SuperTypes INSTANCE = new SuperTypes();

                private SuperTypes() {
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$ServiceBuilder;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "RenderingContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "getRenderingContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
        public static final class ServiceBuilder
        implements SectionId {
            @NotNull
            public static final ServiceBuilder INSTANCE = new ServiceBuilder();
            @NotNull
            private static final SectionKey<RenderingContext<ServiceShape>> RenderingContext = new SectionKey("RenderingContext");

            private ServiceBuilder() {
            }

            @NotNull
            public final SectionKey<RenderingContext<ServiceShape>> getRenderingContext() {
                return RenderingContext;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$ServiceConfig;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "RenderingContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "getRenderingContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
        public static final class ServiceConfig
        implements SectionId {
            @NotNull
            public static final ServiceConfig INSTANCE = new ServiceConfig();
            @NotNull
            private static final SectionKey<RenderingContext<ServiceShape>> RenderingContext = new SectionKey("RenderingContext");

            private ServiceConfig() {
            }

            @NotNull
            public final SectionKey<RenderingContext<ServiceShape>> getRenderingContext() {
                return RenderingContext;
            }
        }
    }
}

