/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u0013\u001a\n\u0010\u0014\u001a\u00020\t*\u00020\u000e\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016*\b\u0012\u0004\u0012\u00020\u00170\u0016\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u001a"}, d2={"renderNonBlankGuard", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "member", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "stringToNumber", "", "shape", "Lsoftware/amazon/smithy/model/shapes/NumberShape;", "errorHandler", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "block", "Lkotlin/Function1;", "Lsoftware/amazon/smithy/kotlin/codegen/core/SymbolRenderer;", "errorHandlerName", "filterDocumentBoundMembers", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingDescriptor;", "isNonBlankInStruct", "", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nHttpBindingProtocolGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1064:1\n766#2:1065\n857#2,2:1066\n1045#2:1068\n1549#2:1069\n1620#2,3:1070\n82#3:1073\n1#4:1074\n*S KotlinDebug\n*F\n+ 1 HttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGeneratorKt\n*L\n1034#1:1065\n1034#1:1066,2\n1035#1:1068\n1036#1:1069\n1036#1:1070,3\n1063#1:1073\n*E\n"})
public final class HttpBindingProtocolGeneratorKt {
    @NotNull
    public static final String stringToNumber(@NotNull NumberShape shape) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        ShapeType shapeType = shape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: {
                string = "toByte()";
                break;
            }
            case 2: {
                string = "toShort()";
                break;
            }
            case 3: {
                string = "toInt()";
                break;
            }
            case 4: {
                string = "toLong()";
                break;
            }
            case 5: {
                string = "toFloat()";
                break;
            }
            case 6: {
                string = "toDouble()";
                break;
            }
            default: {
                throw new CodegenException("unknown number shape: " + shape);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MemberShape> filterDocumentBoundMembers(@NotNull List<HttpBindingDescriptor> $this$filterDocumentBoundMembers) {
        void $this$mapTo$iv$iv;
        HttpBindingDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterDocumentBoundMembers, (String)"<this>");
        Iterable $this$filter$iv = $this$filterDocumentBoundMembers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HttpBindingDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getLocation() == HttpBinding.Location.DOCUMENT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HttpBindingDescriptor it = (HttpBindingDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (HttpBindingDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HttpBindingDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMember());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String errorHandlerName(@NotNull OperationShape $this$errorHandlerName) {
        Intrinsics.checkNotNullParameter((Object)$this$errorHandlerName, (String)"<this>");
        return "throw" + NamingKt.capitalizedDefaultName($this$errorHandlerName) + "Error";
    }

    @NotNull
    public static final Symbol errorHandler(@NotNull OperationShape $this$errorHandler, @NotNull KotlinSettings settings, @NotNull Function1<? super KotlinWriter, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$errorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>($this$errorHandler, settings, block){
            final /* synthetic */ OperationShape $this_errorHandler;
            final /* synthetic */ KotlinSettings $settings;
            final /* synthetic */ Function1<KotlinWriter, Unit> $block;
            {
                this.$this_errorHandler = $receiver;
                this.$settings = $settings;
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                $this$buildSymbol.setName(HttpBindingProtocolGeneratorKt.errorHandlerName(this.$this_errorHandler));
                $this$buildSymbol.setNamespace(this.$settings.getPkg().getSerde());
                $this$buildSymbol.setDefinitionFile(SerdeExtKt.deserializerName(this.$this_errorHandler) + ".kt");
                $this$buildSymbol.setRenderBy(this.$block);
            }
        }));
    }

    private static final void renderNonBlankGuard(ProtocolGenerator.GenerationContext ctx, MemberShape member, KotlinWriter writer) {
        if (HttpBindingProtocolGeneratorKt.isNonBlankInStruct(member, ctx)) {
            Symbol memberSymbol = ctx.getSymbolProvider().toSymbol((Shape)member);
            Intrinsics.checkNotNull((Object)memberSymbol);
            String nullCheck = SymbolExtKt.isNullable(memberSymbol) ? "?" : "";
            Object[] objectArray = new Object[]{NamingKt.defaultName(member)};
            writer.write("require(input.#1L" + nullCheck + ".isNotBlank() == true) { \"#1L is bound to the URI and must be a non-blank value\" }", objectArray);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNonBlankInStruct(MemberShape $this$isNonBlankInStruct, ProtocolGenerator.GenerationContext ctx) {
        if (!ctx.getModel().expectShape($this$isNonBlankInStruct.getTarget()).isStringShape()) return false;
        Shape $this$getTrait$iv = (Shape)$this$isNonBlankInStruct;
        boolean $i$f$getTrait = false;
        Optional optional = $this$getTrait$iv.getTrait(LengthTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
        LengthTrait lengthTrait = (LengthTrait)((Trait)OptionalExtKt.getOrNull(optional));
        Object object = lengthTrait;
        if (lengthTrait == null) return false;
        Optional optional2 = object.getMin();
        object = optional2;
        if (optional2 == null) return false;
        Long l = (Long)OptionalExtKt.getOrNull(object);
        object = l;
        if (l == null) return false;
        Object object2 = object;
        long it = ((Number)object2).longValue();
        boolean bl = false;
        if (it <= 0L) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Object object3 = object2;
        if (object3 == null) return false;
        return true;
    }

    public static final /* synthetic */ void access$renderNonBlankGuard(ProtocolGenerator.GenerationContext ctx, MemberShape member, KotlinWriter writer) {
        HttpBindingProtocolGeneratorKt.renderNonBlankGuard(ctx, member, writer);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

