/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.ServiceClientConfigGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.ServiceClientGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "(Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;)V", "service", "serviceSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "kotlin.jvm.PlatformType", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "overrideServiceName", "", "render", "renderCompanionObject", "renderOperation", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "renderOperationDslOverload", "renderServiceBuilder", "renderServiceConfig", "renderWithConfig", "Sections", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nServiceClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1#2:232\n1045#3:233\n1855#3,2:234\n1855#3,2:236\n1855#3,2:238\n*S KotlinDebug\n*F\n+ 1 ServiceClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator\n*L\n70#1:233\n108#1:234,2\n183#1:236,2\n98#1:238,2\n*E\n"})
public final class ServiceClientGenerator {
    @NotNull
    private final RenderingContext<ServiceShape> ctx;
    @NotNull
    private final ServiceShape service;
    private final Symbol serviceSymbol;
    @NotNull
    private final KotlinWriter writer;

    public ServiceClientGenerator(@NotNull RenderingContext<ServiceShape> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.ctx = ctx;
        if (!(this.ctx.getShape() != null)) {
            boolean $i$a$-require-ServiceClientGenerator$22 = false;
            String $i$a$-require-ServiceClientGenerator$22 = "ServiceShape is required for generating a service interface; was: " + this.ctx.getShape();
            throw new IllegalArgumentException($i$a$-require-ServiceClientGenerator$22.toString());
        }
        ServiceShape serviceShape2 = this.ctx.getShape();
        if (serviceShape2 == null) {
            ServiceClientGenerator serviceClientGenerator = this;
            boolean bl = false;
            ServiceClientGenerator serviceClientGenerator2 = serviceClientGenerator;
            String string = "ServiceShape is required to render a service client";
            throw new IllegalArgumentException(string.toString());
        }
        this.service = serviceShape2;
        this.serviceSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.service);
        this.writer = this.ctx.getWriter();
    }

    public final void render() {
        this.writer.putContext("service.name", this.ctx.getSettings().getSdkId());
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.ctx.getModel());
        Set set = topDownIndex.getContainedOperations((ToShapeId)this.service);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"topDownIndex.getContainedOperations(service)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy22 = false;
        List operations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OperationShape it = (OperationShape)a;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (OperationShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        OperationIndex operationsIndex = OperationIndex.of((Model)this.ctx.getModel());
        this.writer.renderDocumentation((Shape)this.service);
        this.writer.renderAnnotations((Shape)this.service);
        Object[] $i$f$sortedBy22 = new Object[]{RuntimeTypes.SmithyClient.INSTANCE.getSdkClient()};
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)this.writer.openBlock("public interface " + this.serviceSymbol.getName() + " : #T {", $i$f$sortedBy22)).call(() -> ServiceClientGenerator.render$lambda$3(this))).call(() -> ServiceClientGenerator.render$lambda$4(this))).call(() -> ServiceClientGenerator.render$lambda$5(this))).call(() -> ServiceClientGenerator.render$lambda$7(operations, this, operationsIndex))).closeBlock("}", new Object[0])).write("", new Object[0]);
        if (this.ctx.getProtocolGenerator() != null) {
            this.renderWithConfig();
            this.writer.write("", new Object[0]);
        }
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape it = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)operationsIndex, (String)"operationsIndex");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.renderOperationDslOverload(operationsIndex, it);
        }
    }

    private final void renderServiceConfig() {
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)this.writer, Sections.ServiceConfig.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.ServiceConfig.INSTANCE.getRenderingContext(), this.ctx)), (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ ServiceClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                new ServiceClientConfigGenerator(ServiceClientGenerator.access$getService$p(this.this$0), false, 2, null).render(ServiceClientGenerator.access$getCtx$p(this.this$0), ServiceClientGenerator.access$getCtx$p(this.this$0).getWriter());
            }
        });
    }

    private final void renderServiceBuilder() {
        if (this.ctx.getProtocolGenerator() == null) {
            return;
        }
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)this.writer, Sections.ServiceBuilder.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.ServiceBuilder.INSTANCE.getRenderingContext(), this.ctx)), (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ ServiceClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                AbstractCodeWriter abstractCodeWriter = ServiceClientGenerator.access$getWriter$p(this.this$0);
                Object[] objectArray = new Object[2];
                objectArray[0] = RuntimeTypes.SmithyClient.INSTANCE.getAbstractSdkClientBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)ServiceClientGenerator.access$getServiceSymbol$p(this.this$0), (String)"serviceSymbol");
                AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "public class Builder internal constructor(): #T<Config, Config.Builder, #T>() {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.this$0){
                    final /* synthetic */ ServiceClientGenerator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        $this$withBlock.write("override val config: Config.Builder = Config.Builder()", new Object[0]);
                        Object[] objectArray = new Object[]{ServiceClientGenerator.access$getServiceSymbol$p(this.this$0)};
                        $this$withBlock.write("override fun newClient(config: Config): #T = Default" + ServiceClientGenerator.access$getServiceSymbol$p(this.this$0).getName() + "(config)", objectArray);
                    }
                });
            }
        });
    }

    private final void renderCompanionObject() {
        if (this.ctx.getProtocolGenerator() == null) {
            return;
        }
        AbstractCodeWriter abstractCodeWriter = this.writer;
        Object[] objectArray = new Object[2];
        objectArray[0] = RuntimeTypes.SmithyClient.INSTANCE.getSdkClientFactory();
        Intrinsics.checkNotNullExpressionValue((Object)this.serviceSymbol, (String)"serviceSymbol");
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "public companion object : #T<Config, Config.Builder, #T, Builder> {", "}", objectArray, renderCompanionObject.1.INSTANCE);
    }

    private final void overrideServiceName() {
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)this.writer.write("", new Object[0])).write("override val serviceName: String", new Object[0])).indent()).write("get() = #service.name:S", new Object[0])).dedent();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderOperation(OperationIndex opIndex, OperationShape op) {
        void $this$forEach$iv;
        this.writer.write("", new Object[0]);
        this.writer.renderDocumentation((Shape)op);
        this.writer.renderAnnotations((Shape)op);
        String signature = ShapeExtKt.operationSignature(opIndex, this.ctx.getModel(), this.ctx.getSymbolProvider(), op, true);
        Object[] objectArray = new Symbol[]{this.ctx.getSymbolProvider().toSymbol(this.ctx.getModel().expectShape(op.getInputShape())), this.ctx.getSymbolProvider().toSymbol(this.ctx.getModel().expectShape(op.getOutputShape()))};
        objectArray = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Symbol it = (Symbol)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            KotlinWriter.addImport$default(this.writer, it, null, 2, null);
        }
        objectArray = new Object[]{signature};
        this.writer.write("public #L", objectArray);
    }

    private final void renderWithConfig() {
        this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)renderWithConfig.1.INSTANCE));
        AbstractCodeWriter abstractCodeWriter = this.writer;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.serviceSymbol, (String)"serviceSymbol");
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "public fun #1T.withConfig(block: #1T.Config.Builder.() -> Unit): #1T {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ ServiceClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                $this$withBlock.write("val newConfig = config.toBuilder().apply(block).build()", new Object[0]);
                Object[] objectArray = new Object[]{ServiceClientGenerator.access$getServiceSymbol$p(this.this$0).getName()};
                $this$withBlock.write("return Default#L(newConfig)", objectArray);
            }
        });
    }

    private final void renderOperationDslOverload(OperationIndex opIndex, OperationShape op) {
        opIndex.getInput((ToShapeId)op).ifPresent(arg_0 -> ServiceClientGenerator.renderOperationDslOverload$lambda$10((Function1)new Function1<StructureShape, Unit>(opIndex, op, this){
            final /* synthetic */ OperationIndex $opIndex;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ ServiceClientGenerator this$0;
            {
                this.$opIndex = $opIndex;
                this.$op = $op;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull StructureShape inputShape) {
                Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
                this.$opIndex.getOutput((ToShapeId)this.$op).ifPresent(arg_0 -> renderOperationDslOverload.1.invoke$lambda$0((Function1)new Function1<StructureShape, Unit>(this.this$0, inputShape, this.$op){
                    final /* synthetic */ ServiceClientGenerator this$0;
                    final /* synthetic */ StructureShape $inputShape;
                    final /* synthetic */ OperationShape $op;
                    {
                        this.this$0 = $receiver;
                        this.$inputShape = $inputShape;
                        this.$op = $op;
                        super(1);
                    }

                    public final void invoke(@NotNull StructureShape outputShape2) {
                        Intrinsics.checkNotNullParameter((Object)outputShape2, (String)"outputShape");
                        boolean hasOutputStream2 = ShapeExtKt.hasStreamingMember(outputShape2, ServiceClientGenerator.access$getCtx$p(this.this$0).getModel());
                        if (!hasOutputStream2) {
                            Symbol inputSymbol = ServiceClientGenerator.access$getCtx$p(this.this$0).getSymbolProvider().toSymbol((Shape)this.$inputShape);
                            Symbol outputSymbol = ServiceClientGenerator.access$getCtx$p(this.this$0).getSymbolProvider().toSymbol((Shape)outputShape2);
                            String operationName = NamingKt.defaultName(this.$op);
                            ServiceClientGenerator.access$getWriter$p(this.this$0).write("", new Object[0]);
                            ServiceClientGenerator.access$getWriter$p(this.this$0).renderDocumentation((Shape)this.$op);
                            ServiceClientGenerator.access$getWriter$p(this.this$0).renderAnnotations((Shape)this.$op);
                            Object[] objectArray = new Object[]{ServiceClientGenerator.access$getServiceSymbol$p(this.this$0), operationName, inputSymbol, outputSymbol, operationName, inputSymbol};
                            ServiceClientGenerator.access$getWriter$p(this.this$0).write("public suspend inline fun #T.#L(crossinline block: #T.Builder.() -> Unit): #T = #L(#T.Builder().apply(block).build())", objectArray);
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void render$lambda$3(ServiceClientGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.overrideServiceName();
    }

    private static final void render$lambda$4(ServiceClientGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writer.dokka(this$0.serviceSymbol.getName() + "'s configuration");
        this$0.writer.write("public override val config: Config", new Object[0]);
    }

    private static final void render$lambda$5(ServiceClientGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writer.write("", new Object[0]);
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)this$0.writer, Sections.CompanionObject.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(Sections.CompanionObject.INSTANCE.getServiceSymbol(), (Object)this$0.serviceSymbol)), (Function1)new Function1<KotlinWriter, Unit>(this$0){
            final /* synthetic */ ServiceClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                ServiceClientGenerator.access$renderCompanionObject(this.this$0);
            }
        });
        this$0.writer.write("", new Object[0]);
        this$0.renderServiceBuilder();
        this$0.writer.write("", new Object[0]);
        this$0.renderServiceConfig();
    }

    private static final void render$lambda$7(List $operations, ServiceClientGenerator this$0, OperationIndex $operationsIndex) {
        Intrinsics.checkNotNullParameter((Object)$operations, (String)"$operations");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape it = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$operationsIndex, (String)"operationsIndex");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.renderOperation($operationsIndex, it);
        }
    }

    private static final void renderOperationDslOverload$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ServiceShape access$getService$p(ServiceClientGenerator $this) {
        return $this.service;
    }

    public static final /* synthetic */ RenderingContext access$getCtx$p(ServiceClientGenerator $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ KotlinWriter access$getWriter$p(ServiceClientGenerator $this) {
        return $this.writer;
    }

    public static final /* synthetic */ Symbol access$getServiceSymbol$p(ServiceClientGenerator $this) {
        return $this.serviceSymbol;
    }

    public static final /* synthetic */ void access$renderCompanionObject(ServiceClientGenerator $this) {
        $this.renderCompanionObject();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections;", "", "()V", "CompanionObject", "ServiceBuilder", "ServiceConfig", "smithy-kotlin-codegen"})
    public static final class Sections {
        @NotNull
        public static final Sections INSTANCE = new Sections();

        private Sections() {
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$ServiceBuilder;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "RenderingContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "getRenderingContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
        public static final class ServiceBuilder
        implements SectionId {
            @NotNull
            public static final ServiceBuilder INSTANCE = new ServiceBuilder();
            @NotNull
            private static final SectionKey<RenderingContext<ServiceShape>> RenderingContext = new SectionKey("RenderingContext");

            private ServiceBuilder() {
            }

            @NotNull
            public final SectionKey<RenderingContext<ServiceShape>> getRenderingContext() {
                return RenderingContext;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$CompanionObject;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "ServiceSymbol", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "getServiceSymbol", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
        public static final class CompanionObject
        implements SectionId {
            @NotNull
            public static final CompanionObject INSTANCE = new CompanionObject();
            @NotNull
            private static final SectionKey<Symbol> ServiceSymbol = new SectionKey("ServiceSymbol");

            private CompanionObject() {
            }

            @NotNull
            public final SectionKey<Symbol> getServiceSymbol() {
                return ServiceSymbol;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ServiceClientGenerator$Sections$ServiceConfig;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "RenderingContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "getRenderingContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
        public static final class ServiceConfig
        implements SectionId {
            @NotNull
            public static final ServiceConfig INSTANCE = new ServiceConfig();
            @NotNull
            private static final SectionKey<RenderingContext<ServiceShape>> RenderingContext = new SectionKey("RenderingContext");

            private ServiceConfig() {
            }

            @NotNull
            public final SectionKey<RenderingContext<ServiceShape>> getRenderingContext() {
                return RenderingContext;
            }
        }
    }
}

