/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J.\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/UnionGenerator;", "", "model", "Lsoftware/amazon/smithy/model/Model;", "symbolProvider", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "shape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/codegen/core/SymbolProvider;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/shapes/UnionShape;)V", "getModel", "()Lsoftware/amazon/smithy/model/Model;", "render", "", "renderEquals", "sortedMembers", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "typeName", "", "renderHashCode", "selectHashFunctionForShape", "member", "smithy-kotlin-codegen"})
public final class UnionGenerator {
    @NotNull
    private final Model model;
    @NotNull
    private final SymbolProvider symbolProvider;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final UnionShape shape;

    public UnionGenerator(@NotNull Model model, @NotNull SymbolProvider symbolProvider, @NotNull KotlinWriter writer, @NotNull UnionShape shape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.model = model;
        this.symbolProvider = symbolProvider;
        this.writer = writer;
        this.shape = shape;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    public final void render() {
        Object[] objectArray;
        Symbol variantSymbol;
        String variantName;
        MemberShape it;
        boolean bl;
        block8: {
            Iterable $this$any$iv = this.shape.getAllMembers().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MemberShape memberShape2 = (MemberShape)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)memberShape2.getMemberName(), (String)"SdkUnknown", (boolean)true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!(!bl)) {
            boolean $i$a$-check-UnionGenerator$render$32 = false;
            String $i$a$-check-UnionGenerator$render$32 = "generating SdkUnknown would cause duplicate variant for union shape: " + this.shape;
            throw new IllegalStateException($i$a$-check-UnionGenerator$render$32.toString());
        }
        Symbol symbol = this.symbolProvider.toSymbol((Shape)this.shape);
        this.writer.renderDocumentation((Shape)this.shape);
        this.writer.renderAnnotations((Shape)this.shape);
        Object[] $i$a$-check-UnionGenerator$render$32 = new Object[]{symbol};
        this.writer.openBlock("sealed class #T {", $i$a$-check-UnionGenerator$render$32);
        Collection<MemberShape> members = ShapeExtKt.filterEventStreamErrors(this.shape, this.model);
        Iterable $this$sortedBy$iv = members;
        boolean $i$f$sortedBy = false;
        Object $this$forEach$iv = (Object[])CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            it = (MemberShape)element$iv;
            boolean bl3 = false;
            this.writer.renderMemberDocumentation(this.model, it);
            this.writer.renderAnnotations((Shape)it);
            variantName = NamingKt.unionVariantName(it);
            variantSymbol = this.symbolProvider.toSymbol((Shape)it);
            objectArray = new Object[]{variantName, variantSymbol, symbol};
            this.writer.writeInline("data class #L(val value: #Q) : #Q()", objectArray);
            ShapeType shapeType = this.model.expectShape(it.getTarget()).getType();
            if ((shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) == 1) {
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, " {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this, it, variantName){
                    final /* synthetic */ UnionGenerator this$0;
                    final /* synthetic */ MemberShape $it;
                    final /* synthetic */ String $variantName;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        this.$variantName = $variantName;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        UnionGenerator.access$renderHashCode(this.this$0, this.this$0.getModel(), CollectionsKt.listOf((Object)this.$it), UnionGenerator.access$getSymbolProvider$p(this.this$0), $this$withBlock);
                        UnionGenerator.access$renderEquals(this.this$0, this.this$0.getModel(), CollectionsKt.listOf((Object)this.$it), this.$variantName, $this$withBlock);
                    }
                });
                continue;
            }
            this.writer.write("", new Object[0]);
        }
        $this$forEach$iv = new Object[]{symbol};
        this.writer.write("object SdkUnknown : #Q()", (Object[])$this$forEach$iv);
        $this$sortedBy$iv = members;
        $i$f$sortedBy = false;
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            it = (MemberShape)element$iv;
            boolean bl4 = false;
            variantName = NamingKt.unionVariantName(it);
            variantSymbol = this.symbolProvider.toSymbol((Shape)it);
            this.writer.write("", new Object[0]);
            this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, variantName, variantSymbol){
                final /* synthetic */ Symbol $symbol;
                final /* synthetic */ String $variantName;
                final /* synthetic */ Symbol $variantSymbol;
                {
                    this.$symbol = $symbol;
                    this.$variantName = $variantName;
                    this.$variantSymbol = $variantSymbol;
                    super(1);
                }

                public final void invoke(@NotNull KotlinWriter $this$dokka) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
                    Object[] objectArray = new Object[]{this.$symbol, this.$variantName, this.$variantSymbol, this.$symbol, this.$variantName};
                    $this$dokka.write("Casts this [#T] as a [#L] and retrieves its [#Q] value. Throws an exception if the [#T] is not a\n[#L].", objectArray);
                }
            }));
            objectArray = new Object[]{variantName, variantSymbol, symbol, variantName};
            this.writer.write("fun as#L(): #Q = (this as #T.#L).value", objectArray);
            this.writer.write("", new Object[0]);
            this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, variantName, variantSymbol){
                final /* synthetic */ Symbol $symbol;
                final /* synthetic */ String $variantName;
                final /* synthetic */ Symbol $variantSymbol;
                {
                    this.$symbol = $symbol;
                    this.$variantName = $variantName;
                    this.$variantSymbol = $variantSymbol;
                    super(1);
                }

                public final void invoke(@NotNull KotlinWriter $this$dokka) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
                    Object[] objectArray = new Object[]{this.$symbol, this.$variantName, this.$variantSymbol, this.$symbol, this.$variantName};
                    $this$dokka.write("Casts this [#T] as a [#L] and retrieves its [#Q] value. Returns null if the [#T] is not a [#L].", objectArray);
                }
            }));
            objectArray = new Object[]{variantName, variantSymbol, symbol, variantName};
            this.writer.write("fun as#LOrNull(): #Q? = (this as? #T.#L)?.value", objectArray);
        }
        ((KotlinWriter)this.writer.closeBlock("}", new Object[0])).write("", new Object[0]);
        $this$sortedBy$iv = members;
        $i$f$sortedBy = false;
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            it = (MemberShape)element$iv;
            boolean bl5 = false;
            variantName = NamingKt.unionVariantName(it);
            variantSymbol = this.symbolProvider.toSymbol((Shape)it);
            this.writer.write("", new Object[0]);
            this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, variantName, variantSymbol){
                final /* synthetic */ Symbol $symbol;
                final /* synthetic */ String $variantName;
                final /* synthetic */ Symbol $variantSymbol;
                {
                    this.$symbol = $symbol;
                    this.$variantName = $variantName;
                    this.$variantSymbol = $variantSymbol;
                    super(1);
                }

                public final void invoke(@NotNull KotlinWriter $this$dokka) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
                    Object[] objectArray = new Object[]{this.$symbol, this.$variantName, this.$variantSymbol};
                    $this$dokka.write("Casts this [#T] as a [#L] and retrieves its [#Q] value.", objectArray);
                }
            }));
            objectArray = new Object[]{symbol, variantName, symbol, variantName};
            this.writer.write("val #T.#L get() = (this as #T.#L).value", objectArray);
        }
    }

    private final void renderHashCode(Model model, List<MemberShape> sortedMembers, SymbolProvider symbolProvider, KotlinWriter writer) {
        writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getInt()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun hashCode(): #Q {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this, model, sortedMembers, symbolProvider){
            final /* synthetic */ UnionGenerator this$0;
            final /* synthetic */ Model $model;
            final /* synthetic */ List<MemberShape> $sortedMembers;
            final /* synthetic */ SymbolProvider $symbolProvider;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                this.$sortedMembers = $sortedMembers;
                this.$symbolProvider = $symbolProvider;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{UnionGenerator.access$selectHashFunctionForShape(this.this$0, this.$model, this.$sortedMembers.get(0), this.$symbolProvider)};
                $this$withBlock.write("return value#L", objectArray);
            }
        });
    }

    private final String selectHashFunctionForShape(Model model, MemberShape member, SymbolProvider symbolProvider) {
        String string;
        Shape targetShape = model.expectShape(member.getTarget());
        Symbol targetSymbol = symbolProvider.toSymbol(targetShape);
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)targetSymbol, (String)"targetSymbol");
                if (SymbolExtKt.isBoxed(targetSymbol)) {
                    string = " ?: 0";
                    break;
                }
                string = "";
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)targetSymbol, (String)"targetSymbol");
                if (SymbolExtKt.isBoxed(targetSymbol)) {
                    string = ".toInt() ?: 0";
                    break;
                }
                string = ".toInt()";
                break;
            }
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)targetShape, (String)"targetShape");
                Shape $this$hasTrait$iv = targetShape;
                boolean $i$f$hasTrait = false;
                if ($this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
                    string = ".hashCode() ?: 0";
                    break;
                }
                string = ".contentHashCode()";
                break;
            }
            default: {
                Intrinsics.checkNotNullExpressionValue((Object)targetSymbol, (String)"targetSymbol");
                string = SymbolExtKt.isBoxed(targetSymbol) ? ".hashCode() ?: 0" : ".hashCode()";
            }
        }
        return string;
    }

    private final void renderEquals(Model model, List<MemberShape> sortedMembers, String typeName, KotlinWriter writer) {
        writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getAny(), KotlinTypes.INSTANCE.getBoolean()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun equals(other: #Q?): #Q {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(typeName, sortedMembers, model, writer){
            final /* synthetic */ String $typeName;
            final /* synthetic */ List<MemberShape> $sortedMembers;
            final /* synthetic */ Model $model;
            final /* synthetic */ KotlinWriter $writer;
            {
                this.$typeName = $typeName;
                this.$sortedMembers = $sortedMembers;
                this.$model = $model;
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                $this$withBlock.write("if (this === other) return true", new Object[0]);
                $this$withBlock.write("if (other == null || this::class != other::class) return false", new Object[0]);
                $this$withBlock.write("", new Object[0]);
                $this$withBlock.write("other as " + this.$typeName, new Object[0]);
                $this$withBlock.write("", new Object[0]);
                for (MemberShape memberShape2 : this.$sortedMembers) {
                    Object[] objectArray;
                    Shape target = this.$model.expectShape(memberShape2.getTarget());
                    String memberName = "value";
                    if (target instanceof BlobShape) {
                        Shape $this$hasTrait$iv = target;
                        boolean $i$f$hasTrait = false;
                        if (!$this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
                            objectArray = new Object[]{memberName};
                            this.$writer.write("if (!#1L.contentEquals(other.#1L)) return false", objectArray);
                            continue;
                        }
                    }
                    objectArray = new Object[]{memberName};
                    $this$withBlock.write("if (#1L != other.#1L) return false", objectArray);
                }
                $this$withBlock.write("", new Object[0]);
                $this$withBlock.write("return true", new Object[0]);
            }
        });
    }

    public static final /* synthetic */ String access$selectHashFunctionForShape(UnionGenerator $this, Model model, MemberShape member, SymbolProvider symbolProvider) {
        return $this.selectHashFunctionForShape(model, member, symbolProvider);
    }

    public static final /* synthetic */ void access$renderHashCode(UnionGenerator $this, Model model, List sortedMembers, SymbolProvider symbolProvider, KotlinWriter writer) {
        $this.renderHashCode(model, sortedMembers, symbolProvider, writer);
    }

    public static final /* synthetic */ SymbolProvider access$getSymbolProvider$p(UnionGenerator $this) {
        return $this.symbolProvider;
    }

    public static final /* synthetic */ void access$renderEquals(UnionGenerator $this, Model model, List sortedMembers, String typeName, KotlinWriter writer) {
        $this.renderEquals(model, sortedMembers, typeName, writer);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            nArray[ShapeType.BLOB.ordinal()] = 1;
            nArray[ShapeType.INTEGER.ordinal()] = 2;
            nArray[ShapeType.BYTE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

