/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.InlineCodeWriterFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependencyKt;
import software.amazon.smithy.kotlin.codegen.rendering.GradleGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.Scope;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\b\u001a\u00020\u0004H\u0002\u001a.\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a{\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u001b\u0010\u0014\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u00072\u001b\u0010\u0002\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u00072\u001b\u0010\u0015\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u0007\u001a{\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u001b\u0010\u0014\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u00072\u001b\u0010\u0002\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u00072\u001b\u0010\u0015\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u0007\u001a\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0004\u001a$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u0002\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"JVM_TARGET_VERSION", "", "repositoryRenderer", "Lkotlin/Function1;", "Lsoftware/amazon/smithy/utils/CodeWriter;", "", "Lsoftware/amazon/smithy/kotlin/codegen/core/InlineCodeWriter;", "Lkotlin/ExtensionFunctionType;", "createCodeWriter", "renderDependencies", "writer", "scope", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/Scope;", "isKmp", "", "dependencies", "", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDependency;", "renderJvmGradleBuild", "isRootModule", "pluginsRenderer", "annotationRenderer", "renderKmpGradleBuild", "renderRootJvmPluginConfig", "writeGradleBuild", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "manifest", "Lsoftware/amazon/smithy/build/FileManifest;", "smithy-kotlin-codegen"})
public final class GradleGeneratorKt {
    @NotNull
    private static final String JVM_TARGET_VERSION;
    @NotNull
    private static final Function1<CodeWriter, Unit> repositoryRenderer;

    public static final void writeGradleBuild(@NotNull KotlinSettings settings, @NotNull FileManifest manifest, @NotNull List<KotlinDependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        CodeWriter writer = GradleGeneratorKt.createCodeWriter();
        boolean isKmp = settings.getBuild().getGenerateMultiplatformProject();
        boolean isRootModule = settings.getBuild().getGenerateFullProject();
        Function1 annotationRenderer2 = (Function1)new Function1<CodeWriter, Unit>(settings){
            final /* synthetic */ KotlinSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter $this$null) {
                List annotations;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                List list = this.$settings.getBuild().getOptInAnnotations();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                if (!((Collection)(annotations = list)).isEmpty()) {
                    String formatted2 = CollectionsKt.joinToString$default((Iterable)annotations, (CharSequence)",\n", null, null, (int)0, null, (Function1)writeGradleBuild.annotationRenderer.formatted.1.INSTANCE, (int)30, null);
                    $this$null.write((Object)formatted2, new Object[0]);
                }
            }
        };
        Function1 pluginsBodyRenderer2 = (Function1)new Function1<CodeWriter, Unit>(isKmp, isRootModule){
            final /* synthetic */ boolean $isKmp;
            final /* synthetic */ boolean $isRootModule;
            {
                this.$isKmp = $isKmp;
                this.$isRootModule = $isRootModule;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                String pluginName = this.$isKmp ? "multiplatform" : "jvm";
                Object[] objectArray = new Object[]{new Function1<CodeWriter, Unit>(this.$isRootModule){
                    final /* synthetic */ boolean $isRootModule;
                    {
                        this.$isRootModule = $isRootModule;
                        super(1);
                    }

                    public final void invoke(@NotNull CodeWriter w) {
                        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                        if (this.$isRootModule) {
                            Object[] objectArray = new Object[]{KotlinDependencyKt.getKOTLIN_COMPILER_VERSION()};
                            w.write((Object)"version #S", objectArray);
                        }
                    }
                }};
                $this$null.write((Object)("kotlin(\"" + pluginName + "\") #W"), objectArray);
            }
        };
        if (isKmp) {
            GradleGeneratorKt.renderKmpGradleBuild(writer, isRootModule, dependencies, (Function1<? super CodeWriter, Unit>)pluginsBodyRenderer2, repositoryRenderer, (Function1<? super CodeWriter, Unit>)annotationRenderer2);
        } else {
            GradleGeneratorKt.renderJvmGradleBuild(writer, isRootModule, dependencies, (Function1<? super CodeWriter, Unit>)pluginsBodyRenderer2, repositoryRenderer, (Function1<? super CodeWriter, Unit>)annotationRenderer2);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        String contents = string;
        manifest.writeFile("build.gradle.kts", contents);
        if (settings.getBuild().getGenerateFullProject()) {
            manifest.writeFile("settings.gradle.kts", "");
        }
    }

    public static final void renderKmpGradleBuild(@NotNull CodeWriter writer, boolean isRootModule, @NotNull List<KotlinDependency> dependencies, @NotNull Function1<? super CodeWriter, Unit> pluginsRenderer, @NotNull Function1<? super CodeWriter, Unit> repositoryRenderer2, @NotNull Function1<? super CodeWriter, Unit> annotationRenderer2) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(pluginsRenderer, (String)"pluginsRenderer");
        Intrinsics.checkNotNullParameter(repositoryRenderer2, (String)"repositoryRenderer");
        Intrinsics.checkNotNullParameter(annotationRenderer2, (String)"annotationRenderer");
        Object[] objectArray = new Object[]{pluginsRenderer, new Function1<CodeWriter, Unit>(isRootModule, repositoryRenderer2){
            final /* synthetic */ boolean $isRootModule;
            final /* synthetic */ Function1<CodeWriter, Unit> $repositoryRenderer;
            {
                this.$isRootModule = $isRootModule;
                this.$repositoryRenderer = $repositoryRenderer;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter w) {
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                if (this.$isRootModule) {
                    this.$repositoryRenderer.invoke((Object)w);
                }
            }
        }, new Function1<CodeWriter, Object>(isRootModule){
            final /* synthetic */ boolean $isRootModule;
            {
                this.$isRootModule = $isRootModule;
                super(1);
            }

            public final Object invoke(@NotNull CodeWriter w) {
                Unit unit;
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                if (this.$isRootModule) {
                    GradleGeneratorKt.renderRootJvmPluginConfig(w);
                    unit = Unit.INSTANCE;
                } else {
                    unit = w.write((Object)"jvm()", new Object[0]);
                }
                return unit;
            }
        }, new Function1<CodeWriter, Unit>(dependencies){
            final /* synthetic */ List<KotlinDependency> $dependencies;
            {
                this.$dependencies = $dependencies;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter w) {
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                GradleGeneratorKt.access$renderDependencies(w, Scope.SOURCE, true, this.$dependencies);
            }
        }, new Function1<CodeWriter, Unit>(dependencies){
            final /* synthetic */ List<KotlinDependency> $dependencies;
            {
                this.$dependencies = $dependencies;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter w) {
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                GradleGeneratorKt.access$renderDependencies(w, Scope.TEST, true, this.$dependencies);
            }
        }, annotationRenderer2};
        writer.write((Object)"plugins {\n    #W\n}  \n#W\n\nkotlin {\n    #W\n    sourceSets {\n        val commonMain by getting {\n            dependencies {\n                #W\n            }\n        }\n        val commonTest by getting {\n            dependencies {\n                #W\n            }\n        }\n    }\n    val optInAnnotations = listOf(\n        #W\n    )\n    kotlin.sourceSets.all {\n        optInAnnotations.forEach { languageSettings.optIn(it) }\n    }\n}", objectArray);
    }

    public static final void renderRootJvmPluginConfig(@NotNull CodeWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Object[] objectArray = new Object[]{JVM_TARGET_VERSION};
        writer.write((Object)"jvm {\n    compilations.all {\n        kotlinOptions.jvmTarget = #S\n    }\n    testRuns[\"test\"].executionTask.configure {\n        useJUnitPlatform()\n        testLogging {\n            events(\"passed\", \"skipped\", \"failed\")\n            showStandardStreams = true\n        }\n    }\n}", objectArray);
    }

    public static final void renderJvmGradleBuild(@NotNull CodeWriter writer, boolean isRootModule, @NotNull List<KotlinDependency> dependencies, @NotNull Function1<? super CodeWriter, Unit> pluginsRenderer, @NotNull Function1<? super CodeWriter, Unit> repositoryRenderer2, @NotNull Function1<? super CodeWriter, Unit> annotationRenderer2) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(pluginsRenderer, (String)"pluginsRenderer");
        Intrinsics.checkNotNullParameter(repositoryRenderer2, (String)"repositoryRenderer");
        Intrinsics.checkNotNullParameter(annotationRenderer2, (String)"annotationRenderer");
        Object[] objectArray = new Object[]{pluginsRenderer, new Function1<CodeWriter, Unit>(isRootModule, repositoryRenderer2){
            final /* synthetic */ boolean $isRootModule;
            final /* synthetic */ Function1<CodeWriter, Unit> $repositoryRenderer;
            {
                this.$isRootModule = $isRootModule;
                this.$repositoryRenderer = $repositoryRenderer;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter w) {
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                if (this.$isRootModule) {
                    this.$repositoryRenderer.invoke((Object)w);
                }
            }
        }, new Function1<CodeWriter, Unit>(dependencies){
            final /* synthetic */ List<KotlinDependency> $dependencies;
            {
                this.$dependencies = $dependencies;
                super(1);
            }

            public final void invoke(@NotNull CodeWriter w) {
                Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                GradleGeneratorKt.access$renderDependencies(w, Scope.SOURCE, false, this.$dependencies);
            }
        }, annotationRenderer2};
        writer.write((Object)"plugins {\n    #W\n}\n#W\n\ndependencies {\n    #W\n}\nval optInAnnotations = listOf(\n    #W\n)\nkotlin.sourceSets.all {\n    optInAnnotations.forEach { languageSettings.optIn(it) }\n}\n\ntasks.test {\n    useJUnitPlatform()\n    testLogging {\n        events(\"passed\", \"skipped\", \"failed\")\n        showStandardStreams = true\n    }\n}", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final void renderDependencies(CodeWriter writer, Scope scope, boolean isKmp, List<KotlinDependency> dependencies) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (!isKmp) {
            writer.write((Object)"implementation(kotlin(\"stdlib\"))", new Object[0]);
        }
        Object object = new Function1[]{renderDependencies.orderedDependencies.1.INSTANCE, renderDependencies.orderedDependencies.2.INSTANCE};
        List orderedDependencies2 = CollectionsKt.sortedWith((Iterable)dependencies, (Comparator)ComparisonsKt.compareBy((Function1[])object));
        object = orderedDependencies2;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinDependency it = (KotlinDependency)element$iv$iv;
            boolean bl = false;
            boolean bl2 = isKmp ? (scope == Scope.SOURCE ? !it.getConfig().isTestScope() : it.getConfig().isTestScope()) : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinDependency dependency = (KotlinDependency)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{dependency.getGroup(), dependency.getArtifact(), dependency.getVersion()};
            writer.write((Object)((Object)((Object)dependency.getConfig()) + "(\"#L:#L:#L\")"), objectArray);
        }
    }

    private static final CodeWriter createCodeWriter() {
        CodeWriter codeWriter;
        CodeWriter $this$createCodeWriter_u24lambda_u2d2 = codeWriter = new CodeWriter();
        boolean bl = false;
        $this$createCodeWriter_u24lambda_u2d2.trimBlankLines();
        $this$createCodeWriter_u24lambda_u2d2.trimTrailingSpaces();
        $this$createCodeWriter_u24lambda_u2d2.setIndentText("    ");
        $this$createCodeWriter_u24lambda_u2d2.setExpressionStart('#');
        $this$createCodeWriter_u24lambda_u2d2.putFormatter('W', (BiFunction)new InlineCodeWriterFormatter((Function0<? extends CodeWriter>)((Function0)createCodeWriter.1.1.INSTANCE)));
        return codeWriter;
    }

    public static final /* synthetic */ void access$renderDependencies(CodeWriter writer, Scope scope, boolean isKmp, List dependencies) {
        GradleGeneratorKt.renderDependencies(writer, scope, isKmp, dependencies);
    }

    public static final /* synthetic */ CodeWriter access$createCodeWriter() {
        return GradleGeneratorKt.createCodeWriter();
    }

    static {
        String string = System.getProperty("smithy.kotlin.codegen.jvmTargetVersion", "1.8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"smithy.kotl\u2026jvmTargetVersion\", \"1.8\")");
        JVM_TARGET_VERSION = string;
        repositoryRenderer = repositoryRenderer.1.INSTANCE;
    }
}

