/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.AwsHttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.StaticHttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.traits.SyntheticClone;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.MutateHeadersMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.serde.CborParserGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.CborSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataParserGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.pattern.UriPattern;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.protocol.traits.Rpcv2CborTrait;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010!\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0014\u0010\"\u001a\u00020#*\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010$\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RpcV2Cbor;", "Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator;", "<init>", "()V", "protocol", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "getProtocol", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getProtocolHttpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "structuredDataSerializer", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "structuredDataParser", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataParserGenerator;", "renderDeserializeErrorDetails", "", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "getDefaultHttpMiddleware", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "renderSerializeHttpBody", "hasHttpBody", "", "renderContentTypeHeader", "resolver", "RpcV2CborHttpBindingResolver", "smithy-aws-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nRpcV2Cbor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RpcV2Cbor.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RpcV2Cbor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,170:1\n295#2,2:171\n83#3:173\n*S KotlinDebug\n*F\n+ 1 RpcV2Cbor.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RpcV2Cbor\n*L\n107#1:171,2\n128#1:173\n*E\n"})
public final class RpcV2Cbor
extends AwsHttpBindingProtocolGenerator {
    @NotNull
    private final ShapeId protocol;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public RpcV2Cbor() {
        ShapeId shapeId = Rpcv2CborTrait.ID;
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"ID");
        this.protocol = shapeId;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.UNKNOWN;
    }

    @NotNull
    public ShapeId getProtocol() {
        return this.protocol;
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    public HttpBindingResolver getProtocolHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        return new RpcV2CborHttpBindingResolver(model, serviceShape);
    }

    @NotNull
    public StructuredDataSerializerGenerator structuredDataSerializer(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (StructuredDataSerializerGenerator)new CborSerializerGenerator((ProtocolGenerator)this);
    }

    @NotNull
    public StructuredDataParserGenerator structuredDataParser(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (StructuredDataParserGenerator)new CborParserGenerator((ProtocolGenerator)this);
    }

    @Override
    public void renderDeserializeErrorDetails(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Object[] objectArray = new Object[]{RuntimeTypes.SmithyRpcV2Protocols.Cbor.INSTANCE.getRpcV2CborErrorDeserializer()};
        writer.write((Object)"#T.deserialize(payload)", objectArray);
    }

    @NotNull
    protected List<ProtocolMiddleware> getDefaultHttpMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MutateHeadersMiddleware smithyProtocolHeaderMiddleware = new MutateHeadersMiddleware(null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"smithy-protocol", (Object)"rpc-v2-cbor")), null, 5, null);
        ProtocolMiddleware validateSmithyProtocolHeaderMiddleware2 = new ProtocolMiddleware(){
            private final String name;
            {
                this.name = "RpcV2CborValidateSmithyProtocolResponseHeader";
            }

            public String getName() {
                return this.name;
            }

            public void render(ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Symbol interceptorSymbol = RuntimeTypes.SmithyRpcV2Protocols.Cbor.INSTANCE.getRpcV2CborSmithyProtocolResponseHeaderInterceptor();
                Object[] objectArray = new Object[]{interceptorSymbol};
                writer.write((Object)"op.interceptors.add(#T)", objectArray);
            }

            public boolean isEnabledFor(ProtocolGenerator.GenerationContext ctx, OperationShape op) {
                return ProtocolMiddleware.DefaultImpls.isEnabledFor((ProtocolMiddleware)this, (ProtocolGenerator.GenerationContext)ctx, (OperationShape)op);
            }

            public void renderProperties(KotlinWriter writer) {
                ProtocolMiddleware.DefaultImpls.renderProperties((ProtocolMiddleware)this, (KotlinWriter)writer);
            }

            public byte getOrder() {
                return ProtocolMiddleware.DefaultImpls.getOrder((ProtocolMiddleware)this);
            }
        };
        ProtocolMiddleware acceptHeaderMiddleware2 = new ProtocolMiddleware(){
            private final String name;
            {
                this.name = "RpcV2CborAcceptHeaderMiddleware";
            }

            public String getName() {
                return this.name;
            }

            public void render(ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                String acceptHeaderValue = ShapeExtKt.isOutputEventStream((OperationShape)op, (Model)ctx.getModel()) ? "application/vnd.amazon.eventstream" : "application/cbor";
                new MutateHeadersMiddleware(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept", (Object)acceptHeaderValue)), null, null, 6, null).render(ctx, op, writer);
            }

            public boolean isEnabledFor(ProtocolGenerator.GenerationContext ctx, OperationShape op) {
                return ProtocolMiddleware.DefaultImpls.isEnabledFor((ProtocolMiddleware)this, (ProtocolGenerator.GenerationContext)ctx, (OperationShape)op);
            }

            public void renderProperties(KotlinWriter writer) {
                ProtocolMiddleware.DefaultImpls.renderProperties((ProtocolMiddleware)this, (KotlinWriter)writer);
            }

            public byte getOrder() {
                return ProtocolMiddleware.DefaultImpls.getOrder((ProtocolMiddleware)this);
            }
        };
        ProtocolMiddleware businessMetricsMiddleware2 = new ProtocolMiddleware(){
            private final String name;
            {
                this.name = "RpcV2CborBusinessMetricsMiddleware";
            }

            public String getName() {
                return this.name;
            }

            public void render(ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Object[] objectArray = new Object[]{RuntimeTypes.Core.BusinessMetrics.INSTANCE.getEmitBusinessMetric(), RuntimeTypes.Core.BusinessMetrics.INSTANCE.getSmithyBusinessMetric()};
                writer.write((Object)"op.context.#T(#T.PROTOCOL_RPC_V2_CBOR)", objectArray);
            }

            public boolean isEnabledFor(ProtocolGenerator.GenerationContext ctx, OperationShape op) {
                return ProtocolMiddleware.DefaultImpls.isEnabledFor((ProtocolMiddleware)this, (ProtocolGenerator.GenerationContext)ctx, (OperationShape)op);
            }

            public void renderProperties(KotlinWriter writer) {
                ProtocolMiddleware.DefaultImpls.renderProperties((ProtocolMiddleware)this, (KotlinWriter)writer);
            }

            public byte getOrder() {
                return ProtocolMiddleware.DefaultImpls.getOrder((ProtocolMiddleware)this);
            }
        };
        Object[] objectArray = new ProtocolMiddleware[]{smithyProtocolHeaderMiddleware, validateSmithyProtocolHeaderMiddleware2, acceptHeaderMiddleware2, businessMetricsMiddleware2};
        return CollectionsKt.plus((Collection)super.getDefaultHttpMiddleware(ctx), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    protected void renderSerializeHttpBody(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Object v0;
        List requestBindings;
        HttpBindingResolver resolver;
        block4: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            resolver = this.getProtocolHttpBindingResolver(ctx.getModel(), ctx.getService());
            if (!this.hasHttpBody(op, ctx)) {
                return;
            }
            requestBindings = resolver.requestBindings(op);
            Iterable $this$firstOrNull$iv = requestBindings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpBindingDescriptor it = (HttpBindingDescriptor)element$iv;
                boolean bl = false;
                if (!(it.getLocation() == HttpBinding.Location.PAYLOAD)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        HttpBindingDescriptor httpPayload = v0;
        if (httpPayload != null) {
            this.renderExplicitHttpPayloadSerializer(ctx, httpPayload, writer);
        } else {
            List documentMembers = HttpBindingProtocolGeneratorKt.filterDocumentBoundMembers((List)requestBindings);
            StructuredDataSerializerGenerator sdg = this.structuredDataSerializer(ctx);
            Symbol opBodySerializerFn = sdg.operationSerializer(ctx, op, documentMembers);
            Object[] objectArray = new Object[]{opBodySerializerFn};
            writer.write((Object)"builder.body = #T(context, input)", objectArray);
        }
        this.renderContentTypeHeader(ctx, op, writer, resolver);
    }

    private final boolean hasHttpBody(OperationShape $this$hasHttpBody, ProtocolGenerator.GenerationContext ctx) {
        SyntheticClone input;
        SyntheticClone syntheticClone;
        block3: {
            Shape it;
            block2: {
                Shape shape = ctx.getModel().expectShape($this$hasHttpBody.getInputShape());
                Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
                it = ShapeExtKt.targetOrSelf((Shape)shape, (Model)ctx.getModel());
                boolean bl = false;
                Shape $this$getTrait$iv = it;
                boolean $i$f$getTrait = false;
                Optional optional = $this$getTrait$iv.getTrait(SyntheticClone.class);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
                syntheticClone = (SyntheticClone)((Trait)OptionalExtKt.getOrNull((Optional)optional));
                if (syntheticClone == null) break block2;
                SyntheticClone clone = syntheticClone;
                boolean bl2 = false;
                Shape shape2 = ctx.getModel().expectShape(clone.getArchetype());
                Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"expectShape(...)");
                Shape shape3 = ShapeExtKt.targetOrSelf((Shape)shape2, (Model)ctx.getModel());
                syntheticClone = shape3;
                if (shape3 != null) break block3;
            }
            syntheticClone = it;
        }
        return !Intrinsics.areEqual((Object)(input = syntheticClone).getId(), (Object)UnitTypeTrait.UNIT);
    }

    protected void renderContentTypeHeader(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer, @NotNull HttpBindingResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String contentTypeHeader = ShapeExtKt.isInputEventStream((OperationShape)op, (Model)ctx.getModel()) ? "application/vnd.amazon.eventstream" : "application/cbor";
        Object[] objectArray = new Object[]{contentTypeHeader};
        writer.write((Object)"builder.headers.setMissing(\"Content-Type\", #S)", objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RpcV2Cbor$RpcV2CborHttpBindingResolver;", "Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/StaticHttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "<init>", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/model/shapes/ServiceShape;)V", "getServiceShape", "()Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "httpTrait", "Lsoftware/amazon/smithy/model/traits/HttpTrait;", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "determineRequestContentType", "", "smithy-aws-kotlin-codegen"})
    public static final class RpcV2CborHttpBindingResolver
    extends StaticHttpBindingResolver {
        @NotNull
        private final ServiceShape serviceShape;

        public RpcV2CborHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
            HttpTrait httpTrait = HttpTrait.builder().code(200).method("POST").uri(UriPattern.parse((String)"/")).build();
            Intrinsics.checkNotNullExpressionValue((Object)httpTrait, (String)"build(...)");
            super(model, serviceShape, httpTrait, "application/cbor", TimestampFormatTrait.Format.UNKNOWN);
            this.serviceShape = serviceShape;
        }

        @NotNull
        public final ServiceShape getServiceShape() {
            return this.serviceShape;
        }

        @Override
        @NotNull
        public HttpTrait httpTrait(@NotNull OperationShape operationShape) {
            Intrinsics.checkNotNullParameter((Object)operationShape, (String)"operationShape");
            HttpTrait httpTrait = HttpTrait.builder().code(200).method("POST").uri(UriPattern.parse((String)("/service/" + this.serviceShape.getId().getName() + "/operation/" + operationShape.getId().getName()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)httpTrait, (String)"build(...)");
            return httpTrait;
        }

        @Override
        @NotNull
        public String determineRequestContentType(@NotNull OperationShape operationShape) {
            Intrinsics.checkNotNullParameter((Object)operationShape, (String)"operationShape");
            return "application/cbor";
        }
    }
}

