/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.SeekableInputStream;
import software.amazon.s3.analyticsaccelerator.common.ObjectRange;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIO;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class S3SeekableInputStream
extends SeekableInputStream {
    private final LogicalIO logicalIO;
    private final Telemetry telemetry;
    private final S3URI s3URI;
    private long position;
    private boolean closed;
    private static final int EOF = -1;
    private static final String OPERATION_READ = "stream.read";
    private static final String FLAVOR_TAIL = "tail";
    private static final String FLAVOR_BYTE = "byte";
    private static final String OPERATION_STREAM_CLOSE = "seekablestream.close";
    private final long streamBirth = System.nanoTime();

    S3SeekableInputStream(@NonNull S3URI s3URI, @NonNull LogicalIO logicalIO, @NonNull Telemetry telemetry) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (logicalIO == null) {
            throw new NullPointerException("logicalIO is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.logicalIO = logicalIO;
        this.telemetry = telemetry;
        this.position = 0L;
        this.closed = false;
    }

    @Override
    public int read() throws IOException {
        this.throwIfClosed("cannot read from closed stream");
        if (this.position >= this.getContentLength()) {
            return -1;
        }
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_BYTE))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(this.getPos(), this.getPos()))).build(), () -> {
            int byteRead = this.logicalIO.read(this.position);
            this.advancePosition(1);
            return byteRead;
        });
    }

    @Override
    public int read(byte @NonNull [] buffer, int offset, int length) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.throwIfClosed("cannot read from closed stream");
        this.validatePositionedReadArgs(this.position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        if (this.position >= this.getContentLength()) {
            return -1;
        }
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.etag(this.logicalIO.metadata().getEtag()))).attribute(StreamAttributes.range(this.position, this.position + (long)length - 1L))).build(), () -> {
            int bytesRead = this.logicalIO.read(buffer, offset, length, this.position);
            return this.advancePosition(bytesRead);
        });
    }

    @Override
    public void seek(long pos) throws IOException {
        Preconditions.checkArgument(pos >= 0L, "position must be non-negative");
        this.throwIfClosed("cannot seek on closed stream");
        this.position = pos;
    }

    @Override
    public long getPos() {
        return this.position;
    }

    @Override
    public int readTail(byte[] buffer, int offset, int length) throws IOException {
        this.throwIfClosed("cannot read from closed stream");
        this.validatePositionedReadArgs(this.position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_TAIL))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.etag(this.logicalIO.metadata().getEtag()))).attribute(StreamAttributes.range(this.getContentLength() - (long)length, this.getContentLength() - 1L))).build(), () -> this.logicalIO.readTail(buffer, offset, length));
    }

    @Override
    public void readVectored(List<ObjectRange> ranges, IntFunction<ByteBuffer> allocate, Consumer<ByteBuffer> release) throws IOException {
        Preconditions.checkNotNull(ranges, "ranges must not be null");
        Preconditions.checkNotNull(allocate, "allocate must not be null");
        Preconditions.checkNotNull(release, "release must not be null");
        this.logicalIO.readVectored(ranges, allocate, release);
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.throwIfClosed("cannot read from closed stream");
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return;
        }
        this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.etag(this.logicalIO.metadata().getEtag()))).attribute(StreamAttributes.range(position, position + (long)length - 1L))).build(), () -> {
            int bytesRead = this.logicalIO.read(buffer, offset, length, position);
            if (bytesRead < length) {
                throw new EOFException("Reached the end of stream with " + (length - bytesRead) + " bytes left to read");
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_STREAM_CLOSE)).attribute(StreamAttributes.streamRelativeTimestamp(System.nanoTime() - this.streamBirth))).build(), this.logicalIO::close);
        this.telemetry.flush();
        this.closed = true;
    }

    private long getContentLength() throws IOException {
        return this.logicalIO.metadata().getContentLength();
    }

    private int advancePosition(int bytesRead) {
        if (bytesRead >= 0) {
            this.position += (long)bytesRead;
        }
        return bytesRead;
    }

    private void throwIfClosed(String msg) throws IOException {
        if (this.closed) {
            throw new IOException(msg);
        }
    }
}

