/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe;

import java.time.Duration;
import software.amazon.s3.shaded.dev.failsafe.PolicyBuilder;
import software.amazon.s3.shaded.dev.failsafe.RateLimiter;
import software.amazon.s3.shaded.dev.failsafe.RateLimiterConfig;
import software.amazon.s3.shaded.dev.failsafe.internal.RateLimiterImpl;
import software.amazon.s3.shaded.dev.failsafe.internal.util.Assert;

public class RateLimiterBuilder<R>
extends PolicyBuilder<RateLimiterBuilder<R>, RateLimiterConfig<R>, R> {
    RateLimiterBuilder(Duration executionRate) {
        super(new RateLimiterConfig(executionRate));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(long maxPermits, Duration period) {
        super(new RateLimiterConfig(maxPermits, period));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(RateLimiterConfig<R> config) {
        super(new RateLimiterConfig<R>(config));
    }

    public RateLimiter<R> build() {
        return new RateLimiterImpl(new RateLimiterConfig((RateLimiterConfig)this.config));
    }

    public RateLimiterBuilder<R> withMaxWaitTime(Duration maxWaitTime) {
        ((RateLimiterConfig)this.config).maxWaitTime = Assert.notNull(maxWaitTime, "maxWaitTime");
        return this;
    }
}

