/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe;

import java.time.Duration;
import software.amazon.s3.shaded.dev.failsafe.Policy;
import software.amazon.s3.shaded.dev.failsafe.RateLimitExceededException;
import software.amazon.s3.shaded.dev.failsafe.RateLimiterBuilder;
import software.amazon.s3.shaded.dev.failsafe.RateLimiterConfig;

public interface RateLimiter<R>
extends Policy<R> {
    public static <R> RateLimiterBuilder<R> smoothBuilder(long maxExecutions, Duration period) {
        return new RateLimiterBuilder(period.dividedBy(maxExecutions));
    }

    public static <R> RateLimiterBuilder<R> smoothBuilder(Duration maxRate) {
        return new RateLimiterBuilder(maxRate);
    }

    public static <R> RateLimiterBuilder<R> burstyBuilder(long maxExecutions, Duration period) {
        return new RateLimiterBuilder(maxExecutions, period);
    }

    public static <R> RateLimiterBuilder<R> builder(RateLimiterConfig<R> config) {
        return new RateLimiterBuilder<R>(config);
    }

    @Override
    public RateLimiterConfig<R> getConfig();

    default public void acquirePermit() throws InterruptedException {
        this.acquirePermits(1);
    }

    public void acquirePermits(int var1) throws InterruptedException;

    default public void acquirePermit(Duration maxWaitTime) throws InterruptedException {
        this.acquirePermits(1, maxWaitTime);
    }

    default public void acquirePermits(int permits, Duration maxWaitTime) throws InterruptedException {
        if (!this.tryAcquirePermits(permits, maxWaitTime)) {
            throw new RateLimitExceededException(this);
        }
    }

    default public boolean isSmooth() {
        return ((RateLimiterConfig)this.getConfig()).getMaxRate() != null;
    }

    default public boolean isBursty() {
        return ((RateLimiterConfig)this.getConfig()).getPeriod() != null;
    }

    default public Duration reservePermit() {
        return this.reservePermits(1);
    }

    public Duration reservePermits(int var1);

    default public Duration tryReservePermit(Duration maxWaitTime) {
        return this.tryReservePermits(1, maxWaitTime);
    }

    public Duration tryReservePermits(int var1, Duration var2);

    default public boolean tryAcquirePermit() {
        return this.tryAcquirePermits(1);
    }

    public boolean tryAcquirePermits(int var1);

    default public boolean tryAcquirePermit(Duration maxWaitTime) throws InterruptedException {
        return this.tryAcquirePermits(1, maxWaitTime);
    }

    public boolean tryAcquirePermits(int var1, Duration var2) throws InterruptedException;
}

