/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe;

import java.util.concurrent.CompletableFuture;
import software.amazon.s3.shaded.dev.failsafe.FailurePolicyBuilder;
import software.amazon.s3.shaded.dev.failsafe.Fallback;
import software.amazon.s3.shaded.dev.failsafe.FallbackConfig;
import software.amazon.s3.shaded.dev.failsafe.PolicyListeners;
import software.amazon.s3.shaded.dev.failsafe.event.EventListener;
import software.amazon.s3.shaded.dev.failsafe.event.ExecutionAttemptedEvent;
import software.amazon.s3.shaded.dev.failsafe.function.CheckedFunction;
import software.amazon.s3.shaded.dev.failsafe.internal.FallbackImpl;
import software.amazon.s3.shaded.dev.failsafe.internal.util.Assert;

public class FallbackBuilder<R>
extends FailurePolicyBuilder<FallbackBuilder<R>, FallbackConfig<R>, R>
implements PolicyListeners<FallbackBuilder<R>, R> {
    FallbackBuilder(CheckedFunction<ExecutionAttemptedEvent<R>, R> fallback, CheckedFunction<ExecutionAttemptedEvent<R>, CompletableFuture<R>> fallbackStage) {
        super(new FallbackConfig());
        ((FallbackConfig)this.config).fallback = fallback;
        ((FallbackConfig)this.config).fallbackStage = fallbackStage;
    }

    FallbackBuilder(FallbackConfig<R> config) {
        super(new FallbackConfig<R>(config));
    }

    public Fallback<R> build() {
        return new FallbackImpl(new FallbackConfig((FallbackConfig)this.config));
    }

    public FallbackBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((FallbackConfig)this.config).failedAttemptListener = Assert.notNull(listener, "listener");
        return this;
    }

    public FallbackBuilder<R> withAsync() {
        ((FallbackConfig)this.config).async = true;
        return this;
    }
}

