/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public class PhysicalIOConfiguration {
    private static final long DEFAULT_MEMORY_CAPACITY_BYTES = 0x80000000L;
    private static final long DEFAULT_CACHE_DATA_TIMEOUT_MILLISECONDS = 1000L;
    private static final int DEFAULT_CAPACITY_METADATA_STORE = 50;
    private static final boolean DEFAULT_USE_SINGLE_CACHE = true;
    private static final long DEFAULT_BLOCK_SIZE_BYTES = 0x800000L;
    private static final long DEFAULT_READ_AHEAD_BYTES = 65536L;
    private static final long DEFAULT_MAX_RANGE_SIZE = 0x800000L;
    private static final long DEFAULT_PART_SIZE = 0x800000L;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_BASE = 2.0;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_SPEED = 1.0;
    private static final long DEFAULT_BLOCK_READ_TIMEOUT = 30000L;
    private static final int DEFAULT_BLOCK_READ_RETRY_COUNT = 20;
    private static final int DEFAULT_MEMORY_CLEANUP_FREQUENCY_MILLISECONDS = 5000;
    private long memoryCapacityBytes;
    private static final String MEMORY_CAPACITY_BYTES_KEY = "max.memory.limit";
    private int memoryCleanupFrequencyMilliseconds;
    private static final String MEMORY_CLEANUP_FREQUENCY_MILLISECONDS_KEY = "memory.cleanup.frequency";
    private long cacheDataTimeoutMilliseconds;
    private static final String CACHE_DATA_TIMEOUT_MILLISECONDS_KEY = "cache.timeout";
    private int metadataStoreCapacity;
    private static final String METADATA_STORE_CAPACITY_KEY = "metadatastore.capacity";
    private long blockSizeBytes;
    private static final String BLOCK_SIZE_BYTES_KEY = "blocksizebytes";
    private long readAheadBytes;
    private static final String READ_AHEAD_BYTES_KEY = "readaheadbytes";
    private long maxRangeSizeBytes;
    private static final String MAX_RANGE_SIZE_BYTES_KEY = "maxrangesizebytes";
    private long partSizeBytes;
    private static final String PART_SIZE_BYTES_KEY = "partsizebytes";
    private double sequentialPrefetchBase;
    private static final String SEQUENTIAL_PREFETCH_BASE_KEY = "sequentialprefetch.base";
    private double sequentialPrefetchSpeed;
    private static final String SEQUENTIAL_PREFETCH_SPEED_KEY = "sequentialprefetch.speed";
    private long blockReadTimeout;
    private static final String BLOCK_READ_TIMEOUT_KEY = "blockreadtimeout";
    private int blockReadRetryCount;
    private static final String BLOCK_READ_RETRY_COUNT_KEY = "blockreadretrycount";
    public static final PhysicalIOConfiguration DEFAULT = PhysicalIOConfiguration.builder().build();

    public static PhysicalIOConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return PhysicalIOConfiguration.builder().memoryCapacityBytes(configuration.getLong(MEMORY_CAPACITY_BYTES_KEY, 0x80000000L)).memoryCleanupFrequencyMilliseconds(configuration.getInt(MEMORY_CLEANUP_FREQUENCY_MILLISECONDS_KEY, 5000)).cacheDataTimeoutMilliseconds(configuration.getLong(CACHE_DATA_TIMEOUT_MILLISECONDS_KEY, 1000L)).metadataStoreCapacity(configuration.getInt(METADATA_STORE_CAPACITY_KEY, 50)).blockSizeBytes(configuration.getLong(BLOCK_SIZE_BYTES_KEY, 0x800000L)).readAheadBytes(configuration.getLong(READ_AHEAD_BYTES_KEY, 65536L)).maxRangeSizeBytes(configuration.getLong(MAX_RANGE_SIZE_BYTES_KEY, 0x800000L)).partSizeBytes(configuration.getLong(PART_SIZE_BYTES_KEY, 0x800000L)).sequentialPrefetchBase(configuration.getDouble(SEQUENTIAL_PREFETCH_BASE_KEY, 2.0)).sequentialPrefetchSpeed(configuration.getDouble(SEQUENTIAL_PREFETCH_SPEED_KEY, 1.0)).blockReadTimeout(configuration.getLong(BLOCK_READ_TIMEOUT_KEY, 30000L)).blockReadRetryCount(configuration.getInt(BLOCK_READ_RETRY_COUNT_KEY, 20)).build();
    }

    private PhysicalIOConfiguration(long memoryCapacityBytes, int memoryCleanupFrequencyMilliseconds, long cacheDataTimeoutMilliseconds, int metadataStoreCapacity, long blockSizeBytes, long readAheadBytes, long maxRangeSizeBytes, long partSizeBytes, double sequentialPrefetchBase, double sequentialPrefetchSpeed, long blockReadTimeout, int blockReadRetryCount) {
        Preconditions.checkArgument(memoryCapacityBytes > 0L, "`memoryCapacityBytes` must be positive");
        Preconditions.checkArgument(memoryCleanupFrequencyMilliseconds > 0, "`memoryCleanupFrequencyMilliseconds` must be positive");
        Preconditions.checkArgument(cacheDataTimeoutMilliseconds > 0L, "`cacheDataTimeoutMilliseconds` must be positive");
        Preconditions.checkArgument(metadataStoreCapacity > 0, "`metadataStoreCapacity` must be positive");
        Preconditions.checkArgument(blockSizeBytes > 0L, "`blockSizeBytes` must be positive");
        Preconditions.checkArgument(readAheadBytes > 0L, "`readAheadLengthBytes` must be positive");
        Preconditions.checkArgument(maxRangeSizeBytes > 0L, "`maxRangeSize` must be positive");
        Preconditions.checkArgument(partSizeBytes > 0L, "`partSize` must be positive");
        Preconditions.checkArgument(sequentialPrefetchBase > 0.0, "`sequentialPrefetchBase` must be positive");
        Preconditions.checkArgument(sequentialPrefetchSpeed > 0.0, "`sequentialPrefetchSpeed` must be positive");
        Preconditions.checkArgument(blockReadTimeout > 0L, "`blockReadTimeout` must be positive");
        Preconditions.checkArgument(blockReadRetryCount > 0, "`blockReadRetryCount` must be positive");
        this.memoryCapacityBytes = memoryCapacityBytes;
        this.memoryCleanupFrequencyMilliseconds = memoryCleanupFrequencyMilliseconds;
        this.cacheDataTimeoutMilliseconds = cacheDataTimeoutMilliseconds;
        this.metadataStoreCapacity = metadataStoreCapacity;
        this.blockSizeBytes = blockSizeBytes;
        this.readAheadBytes = readAheadBytes;
        this.maxRangeSizeBytes = maxRangeSizeBytes;
        this.partSizeBytes = partSizeBytes;
        this.sequentialPrefetchBase = sequentialPrefetchBase;
        this.sequentialPrefetchSpeed = sequentialPrefetchSpeed;
        this.blockReadTimeout = blockReadTimeout;
        this.blockReadRetryCount = blockReadRetryCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PhysicalIO configuration:\n");
        builder.append("\tmemoryCapacityBytes: " + this.memoryCapacityBytes + "\n");
        builder.append("\tmemoryCleanupFrequencyMilliseconds: " + this.memoryCleanupFrequencyMilliseconds + "\n");
        builder.append("\tcacheDataTimeoutMilliseconds: " + this.cacheDataTimeoutMilliseconds + "\n");
        builder.append("\tmetadataStoreCapacity: " + this.metadataStoreCapacity + "\n");
        builder.append("\tblockSizeBytes: " + this.blockSizeBytes + "\n");
        builder.append("\treadAheadBytes: " + this.readAheadBytes + "\n");
        builder.append("\tmaxRangeSizeBytes: " + this.maxRangeSizeBytes + "\n");
        builder.append("\tpartSizeBytes: " + this.partSizeBytes + "\n");
        builder.append("\tsequentialPrefetchBase: " + this.sequentialPrefetchBase + "\n");
        builder.append("\tsequentialPrefetchSpeed: " + this.sequentialPrefetchSpeed + "\n");
        builder.append("\tblockReadTimeout: " + this.blockReadTimeout + "\n");
        builder.append("\tblockReadRetryCount: " + this.blockReadRetryCount + "\n");
        return builder.toString();
    }

    @Generated
    private static long $default$memoryCapacityBytes() {
        return 0x80000000L;
    }

    @Generated
    private static int $default$memoryCleanupFrequencyMilliseconds() {
        return 5000;
    }

    @Generated
    private static long $default$cacheDataTimeoutMilliseconds() {
        return 1000L;
    }

    @Generated
    private static int $default$metadataStoreCapacity() {
        return 50;
    }

    @Generated
    private static long $default$blockSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static long $default$readAheadBytes() {
        return 65536L;
    }

    @Generated
    private static long $default$maxRangeSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static long $default$partSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static double $default$sequentialPrefetchBase() {
        return 2.0;
    }

    @Generated
    private static double $default$sequentialPrefetchSpeed() {
        return 1.0;
    }

    @Generated
    private static long $default$blockReadTimeout() {
        return 30000L;
    }

    @Generated
    private static int $default$blockReadRetryCount() {
        return 20;
    }

    @Generated
    public static PhysicalIOConfigurationBuilder builder() {
        return new PhysicalIOConfigurationBuilder();
    }

    @Generated
    public long getMemoryCapacityBytes() {
        return this.memoryCapacityBytes;
    }

    @Generated
    public int getMemoryCleanupFrequencyMilliseconds() {
        return this.memoryCleanupFrequencyMilliseconds;
    }

    @Generated
    public long getCacheDataTimeoutMilliseconds() {
        return this.cacheDataTimeoutMilliseconds;
    }

    @Generated
    public int getMetadataStoreCapacity() {
        return this.metadataStoreCapacity;
    }

    @Generated
    public long getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    @Generated
    public long getReadAheadBytes() {
        return this.readAheadBytes;
    }

    @Generated
    public long getMaxRangeSizeBytes() {
        return this.maxRangeSizeBytes;
    }

    @Generated
    public long getPartSizeBytes() {
        return this.partSizeBytes;
    }

    @Generated
    public double getSequentialPrefetchBase() {
        return this.sequentialPrefetchBase;
    }

    @Generated
    public double getSequentialPrefetchSpeed() {
        return this.sequentialPrefetchSpeed;
    }

    @Generated
    public long getBlockReadTimeout() {
        return this.blockReadTimeout;
    }

    @Generated
    public int getBlockReadRetryCount() {
        return this.blockReadRetryCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalIOConfiguration)) {
            return false;
        }
        PhysicalIOConfiguration other = (PhysicalIOConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMemoryCapacityBytes() != other.getMemoryCapacityBytes()) {
            return false;
        }
        if (this.getMemoryCleanupFrequencyMilliseconds() != other.getMemoryCleanupFrequencyMilliseconds()) {
            return false;
        }
        if (this.getCacheDataTimeoutMilliseconds() != other.getCacheDataTimeoutMilliseconds()) {
            return false;
        }
        if (this.getMetadataStoreCapacity() != other.getMetadataStoreCapacity()) {
            return false;
        }
        if (this.getBlockSizeBytes() != other.getBlockSizeBytes()) {
            return false;
        }
        if (this.getReadAheadBytes() != other.getReadAheadBytes()) {
            return false;
        }
        if (this.getMaxRangeSizeBytes() != other.getMaxRangeSizeBytes()) {
            return false;
        }
        if (this.getPartSizeBytes() != other.getPartSizeBytes()) {
            return false;
        }
        if (Double.compare(this.getSequentialPrefetchBase(), other.getSequentialPrefetchBase()) != 0) {
            return false;
        }
        if (Double.compare(this.getSequentialPrefetchSpeed(), other.getSequentialPrefetchSpeed()) != 0) {
            return false;
        }
        if (this.getBlockReadTimeout() != other.getBlockReadTimeout()) {
            return false;
        }
        return this.getBlockReadRetryCount() == other.getBlockReadRetryCount();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalIOConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $memoryCapacityBytes = this.getMemoryCapacityBytes();
        result = result * 59 + (int)($memoryCapacityBytes >>> 32 ^ $memoryCapacityBytes);
        result = result * 59 + this.getMemoryCleanupFrequencyMilliseconds();
        long $cacheDataTimeoutMilliseconds = this.getCacheDataTimeoutMilliseconds();
        result = result * 59 + (int)($cacheDataTimeoutMilliseconds >>> 32 ^ $cacheDataTimeoutMilliseconds);
        result = result * 59 + this.getMetadataStoreCapacity();
        long $blockSizeBytes = this.getBlockSizeBytes();
        result = result * 59 + (int)($blockSizeBytes >>> 32 ^ $blockSizeBytes);
        long $readAheadBytes = this.getReadAheadBytes();
        result = result * 59 + (int)($readAheadBytes >>> 32 ^ $readAheadBytes);
        long $maxRangeSizeBytes = this.getMaxRangeSizeBytes();
        result = result * 59 + (int)($maxRangeSizeBytes >>> 32 ^ $maxRangeSizeBytes);
        long $partSizeBytes = this.getPartSizeBytes();
        result = result * 59 + (int)($partSizeBytes >>> 32 ^ $partSizeBytes);
        long $sequentialPrefetchBase = Double.doubleToLongBits(this.getSequentialPrefetchBase());
        result = result * 59 + (int)($sequentialPrefetchBase >>> 32 ^ $sequentialPrefetchBase);
        long $sequentialPrefetchSpeed = Double.doubleToLongBits(this.getSequentialPrefetchSpeed());
        result = result * 59 + (int)($sequentialPrefetchSpeed >>> 32 ^ $sequentialPrefetchSpeed);
        long $blockReadTimeout = this.getBlockReadTimeout();
        result = result * 59 + (int)($blockReadTimeout >>> 32 ^ $blockReadTimeout);
        result = result * 59 + this.getBlockReadRetryCount();
        return result;
    }

    @Generated
    public static class PhysicalIOConfigurationBuilder {
        @Generated
        private boolean memoryCapacityBytes$set;
        @Generated
        private long memoryCapacityBytes$value;
        @Generated
        private boolean memoryCleanupFrequencyMilliseconds$set;
        @Generated
        private int memoryCleanupFrequencyMilliseconds$value;
        @Generated
        private boolean cacheDataTimeoutMilliseconds$set;
        @Generated
        private long cacheDataTimeoutMilliseconds$value;
        @Generated
        private boolean metadataStoreCapacity$set;
        @Generated
        private int metadataStoreCapacity$value;
        @Generated
        private boolean blockSizeBytes$set;
        @Generated
        private long blockSizeBytes$value;
        @Generated
        private boolean readAheadBytes$set;
        @Generated
        private long readAheadBytes$value;
        @Generated
        private boolean maxRangeSizeBytes$set;
        @Generated
        private long maxRangeSizeBytes$value;
        @Generated
        private boolean partSizeBytes$set;
        @Generated
        private long partSizeBytes$value;
        @Generated
        private boolean sequentialPrefetchBase$set;
        @Generated
        private double sequentialPrefetchBase$value;
        @Generated
        private boolean sequentialPrefetchSpeed$set;
        @Generated
        private double sequentialPrefetchSpeed$value;
        @Generated
        private boolean blockReadTimeout$set;
        @Generated
        private long blockReadTimeout$value;
        @Generated
        private boolean blockReadRetryCount$set;
        @Generated
        private int blockReadRetryCount$value;
        @Generated
        private long memoryCapacityBytes;
        @Generated
        private int memoryCleanupFrequencyMilliseconds;
        @Generated
        private long cacheDataTimeoutMilliseconds;
        @Generated
        private int metadataStoreCapacity;
        @Generated
        private long blockSizeBytes;
        @Generated
        private long readAheadBytes;
        @Generated
        private long maxRangeSizeBytes;
        @Generated
        private long partSizeBytes;
        @Generated
        private double sequentialPrefetchBase;
        @Generated
        private double sequentialPrefetchSpeed;
        @Generated
        private long blockReadTimeout;
        @Generated
        private int blockReadRetryCount;

        @Generated
        PhysicalIOConfigurationBuilder() {
        }

        @Generated
        public PhysicalIOConfigurationBuilder memoryCapacityBytes(long memoryCapacityBytes) {
            this.memoryCapacityBytes$value = memoryCapacityBytes;
            this.memoryCapacityBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder memoryCleanupFrequencyMilliseconds(int memoryCleanupFrequencyMilliseconds) {
            this.memoryCleanupFrequencyMilliseconds$value = memoryCleanupFrequencyMilliseconds;
            this.memoryCleanupFrequencyMilliseconds$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder cacheDataTimeoutMilliseconds(long cacheDataTimeoutMilliseconds) {
            this.cacheDataTimeoutMilliseconds$value = cacheDataTimeoutMilliseconds;
            this.cacheDataTimeoutMilliseconds$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder metadataStoreCapacity(int metadataStoreCapacity) {
            this.metadataStoreCapacity$value = metadataStoreCapacity;
            this.metadataStoreCapacity$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockSizeBytes(long blockSizeBytes) {
            this.blockSizeBytes$value = blockSizeBytes;
            this.blockSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder readAheadBytes(long readAheadBytes) {
            this.readAheadBytes$value = readAheadBytes;
            this.readAheadBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder maxRangeSizeBytes(long maxRangeSizeBytes) {
            this.maxRangeSizeBytes$value = maxRangeSizeBytes;
            this.maxRangeSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder partSizeBytes(long partSizeBytes) {
            this.partSizeBytes$value = partSizeBytes;
            this.partSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchBase(double sequentialPrefetchBase) {
            this.sequentialPrefetchBase$value = sequentialPrefetchBase;
            this.sequentialPrefetchBase$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchSpeed(double sequentialPrefetchSpeed) {
            this.sequentialPrefetchSpeed$value = sequentialPrefetchSpeed;
            this.sequentialPrefetchSpeed$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockReadTimeout(long blockReadTimeout) {
            this.blockReadTimeout$value = blockReadTimeout;
            this.blockReadTimeout$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockReadRetryCount(int blockReadRetryCount) {
            this.blockReadRetryCount$value = blockReadRetryCount;
            this.blockReadRetryCount$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfiguration build() {
            long memoryCapacityBytes$value = this.memoryCapacityBytes$value;
            if (!this.memoryCapacityBytes$set) {
                memoryCapacityBytes$value = PhysicalIOConfiguration.$default$memoryCapacityBytes();
            }
            int memoryCleanupFrequencyMilliseconds$value = this.memoryCleanupFrequencyMilliseconds$value;
            if (!this.memoryCleanupFrequencyMilliseconds$set) {
                memoryCleanupFrequencyMilliseconds$value = PhysicalIOConfiguration.$default$memoryCleanupFrequencyMilliseconds();
            }
            long cacheDataTimeoutMilliseconds$value = this.cacheDataTimeoutMilliseconds$value;
            if (!this.cacheDataTimeoutMilliseconds$set) {
                cacheDataTimeoutMilliseconds$value = PhysicalIOConfiguration.$default$cacheDataTimeoutMilliseconds();
            }
            int metadataStoreCapacity$value = this.metadataStoreCapacity$value;
            if (!this.metadataStoreCapacity$set) {
                metadataStoreCapacity$value = PhysicalIOConfiguration.$default$metadataStoreCapacity();
            }
            long blockSizeBytes$value = this.blockSizeBytes$value;
            if (!this.blockSizeBytes$set) {
                blockSizeBytes$value = PhysicalIOConfiguration.$default$blockSizeBytes();
            }
            long readAheadBytes$value = this.readAheadBytes$value;
            if (!this.readAheadBytes$set) {
                readAheadBytes$value = PhysicalIOConfiguration.$default$readAheadBytes();
            }
            long maxRangeSizeBytes$value = this.maxRangeSizeBytes$value;
            if (!this.maxRangeSizeBytes$set) {
                maxRangeSizeBytes$value = PhysicalIOConfiguration.$default$maxRangeSizeBytes();
            }
            long partSizeBytes$value = this.partSizeBytes$value;
            if (!this.partSizeBytes$set) {
                partSizeBytes$value = PhysicalIOConfiguration.$default$partSizeBytes();
            }
            double sequentialPrefetchBase$value = this.sequentialPrefetchBase$value;
            if (!this.sequentialPrefetchBase$set) {
                sequentialPrefetchBase$value = PhysicalIOConfiguration.$default$sequentialPrefetchBase();
            }
            double sequentialPrefetchSpeed$value = this.sequentialPrefetchSpeed$value;
            if (!this.sequentialPrefetchSpeed$set) {
                sequentialPrefetchSpeed$value = PhysicalIOConfiguration.$default$sequentialPrefetchSpeed();
            }
            long blockReadTimeout$value = this.blockReadTimeout$value;
            if (!this.blockReadTimeout$set) {
                blockReadTimeout$value = PhysicalIOConfiguration.$default$blockReadTimeout();
            }
            int blockReadRetryCount$value = this.blockReadRetryCount$value;
            if (!this.blockReadRetryCount$set) {
                blockReadRetryCount$value = PhysicalIOConfiguration.$default$blockReadRetryCount();
            }
            return new PhysicalIOConfiguration(memoryCapacityBytes$value, memoryCleanupFrequencyMilliseconds$value, cacheDataTimeoutMilliseconds$value, metadataStoreCapacity$value, blockSizeBytes$value, readAheadBytes$value, maxRangeSizeBytes$value, partSizeBytes$value, sequentialPrefetchBase$value, sequentialPrefetchSpeed$value, blockReadTimeout$value, blockReadRetryCount$value);
        }

        @Generated
        public String toString() {
            return "PhysicalIOConfiguration.PhysicalIOConfigurationBuilder(memoryCapacityBytes$value=" + this.memoryCapacityBytes$value + ", memoryCleanupFrequencyMilliseconds$value=" + this.memoryCleanupFrequencyMilliseconds$value + ", cacheDataTimeoutMilliseconds$value=" + this.cacheDataTimeoutMilliseconds$value + ", metadataStoreCapacity$value=" + this.metadataStoreCapacity$value + ", blockSizeBytes$value=" + this.blockSizeBytes$value + ", readAheadBytes$value=" + this.readAheadBytes$value + ", maxRangeSizeBytes$value=" + this.maxRangeSizeBytes$value + ", partSizeBytes$value=" + this.partSizeBytes$value + ", sequentialPrefetchBase$value=" + this.sequentialPrefetchBase$value + ", sequentialPrefetchSpeed$value=" + this.sequentialPrefetchSpeed$value + ", blockReadTimeout$value=" + this.blockReadTimeout$value + ", blockReadRetryCount$value=" + this.blockReadRetryCount$value + ")";
        }
    }
}

