/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.io.IOException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMappers;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanState;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class ParquetPrefetchRemainingColumnTask {
    private final S3URI s3Uri;
    private final Telemetry telemetry;
    private final PhysicalIO physicalIO;
    private final ParquetColumnPrefetchStore parquetColumnPrefetchStore;
    private static final String OPERATION_PARQUET_PREFETCH_COLUMN_CHUNK = "parquet.task.prefetch.column.chunk";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetPrefetchRemainingColumnTask.class);

    public ParquetPrefetchRemainingColumnTask(@NonNull S3URI s3URI, @NonNull Telemetry telemetry, @NonNull PhysicalIO physicalIO, @NonNull ParquetColumnPrefetchStore parquetColumnPrefetchStore) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (parquetColumnPrefetchStore == null) {
            throw new NullPointerException("parquetColumnPrefetchStore is marked non-null but is null");
        }
        this.s3Uri = s3URI;
        this.telemetry = telemetry;
        this.physicalIO = physicalIO;
        this.parquetColumnPrefetchStore = parquetColumnPrefetchStore;
    }

    public IOPlanExecution prefetchRemainingColumnChunk(long position, int len) {
        try {
            ColumnMetadata columnMetadata;
            ColumnMappers columnMappers = this.parquetColumnPrefetchStore.getColumnMappers(this.s3Uri);
            if (columnMappers != null && (columnMetadata = columnMappers.getOffsetIndexToColumnMap().get(position)) != null) {
                return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_PREFETCH_COLUMN_CHUNK)).attribute(StreamAttributes.column(columnMetadata.getColumnName()))).attribute(StreamAttributes.uri(this.s3Uri))).attribute(StreamAttributes.range(position, position + (long)len - 1L))).build(), () -> this.executeRemainingColumnPrefetchPlan(columnMetadata, position, len));
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to prefetch remaining column chunk for {}.", (Object)this.s3Uri.getKey(), (Object)e);
        }
        return IOPlanExecution.builder().state(IOPlanState.SKIPPED).build();
    }

    private IOPlanExecution executeRemainingColumnPrefetchPlan(ColumnMetadata columnMetadata, long position, int len) throws IOException {
        if ((long)len < columnMetadata.getCompressedSize()) {
            long startRange = position + (long)len;
            long endRange = startRange + (columnMetadata.getCompressedSize() - (long)len);
            IOPlan ioPlan = new IOPlan(new Range(startRange, endRange));
            return this.physicalIO.execute(ioPlan);
        }
        return IOPlanExecution.builder().state(IOPlanState.SKIPPED).build();
    }
}

