/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;

public class OperationMeasurement
extends TelemetryDatapointMeasurement {
    @NonNull
    private final TelemetryLevel level;
    private final long elapsedStartTimeNanos;
    private final long elapsedCompleteTimeNanos;
    @NonNull
    private final Optional<Throwable> error;

    private OperationMeasurement(Operation operation, @NonNull TelemetryLevel level, long epochTimestampNanos, long elapsedStartTimeNanos, long elapsedCompleteTimeNanos, @NonNull Optional<Throwable> error) {
        super(operation, epochTimestampNanos);
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        this.level = level;
        this.elapsedStartTimeNanos = elapsedStartTimeNanos;
        this.elapsedCompleteTimeNanos = elapsedCompleteTimeNanos;
        this.error = error;
    }

    @Override
    protected double getValueCore() {
        return this.getElapsedTimeNanos();
    }

    public Operation getOperation() {
        return (Operation)this.getDatapoint();
    }

    @Override
    public String toString(@NonNull TelemetryFormat telemetryFormat, @NonNull EpochFormatter epochFormatter) {
        if (telemetryFormat == null) {
            throw new NullPointerException("telemetryFormat is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        return telemetryFormat.renderOperationEnd(this, epochFormatter);
    }

    public static OperationMeasurementBuilder builder() {
        return new OperationMeasurementBuilder();
    }

    public boolean succeeded() {
        return !this.error.isPresent();
    }

    public boolean failed() {
        return this.error.isPresent();
    }

    public long getElapsedTimeNanos() {
        return this.elapsedCompleteTimeNanos - this.elapsedStartTimeNanos;
    }

    @NonNull
    @Generated
    public TelemetryLevel getLevel() {
        return this.level;
    }

    @Generated
    public long getElapsedStartTimeNanos() {
        return this.elapsedStartTimeNanos;
    }

    @Generated
    public long getElapsedCompleteTimeNanos() {
        return this.elapsedCompleteTimeNanos;
    }

    @NonNull
    @Generated
    public Optional<Throwable> getError() {
        return this.error;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationMeasurement)) {
            return false;
        }
        OperationMeasurement other = (OperationMeasurement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getElapsedStartTimeNanos() != other.getElapsedStartTimeNanos()) {
            return false;
        }
        if (this.getElapsedCompleteTimeNanos() != other.getElapsedCompleteTimeNanos()) {
            return false;
        }
        TelemetryLevel this$level = this.getLevel();
        TelemetryLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
            return false;
        }
        Optional<Throwable> this$error = this.getError();
        Optional<Throwable> other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationMeasurement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $elapsedStartTimeNanos = this.getElapsedStartTimeNanos();
        result = result * 59 + (int)($elapsedStartTimeNanos >>> 32 ^ $elapsedStartTimeNanos);
        long $elapsedCompleteTimeNanos = this.getElapsedCompleteTimeNanos();
        result = result * 59 + (int)($elapsedCompleteTimeNanos >>> 32 ^ $elapsedCompleteTimeNanos);
        TelemetryLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
        Optional<Throwable> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public static class OperationMeasurementBuilder
    extends TelemetryDatapointMeasurement.TelemetryDatapointMeasurementBuilder<OperationMeasurement, OperationMeasurementBuilder> {
        private Operation operation;
        TelemetryLevel level;
        private long elapsedStartTimeNanos = Long.MIN_VALUE;
        private long elapsedCompleteTimeNanos = Long.MIN_VALUE;
        private Optional<Throwable> error = Optional.empty();

        public OperationMeasurementBuilder operation(@NonNull Operation operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            this.operation = operation;
            return this;
        }

        public OperationMeasurementBuilder level(@NonNull TelemetryLevel level) {
            if (level == null) {
                throw new NullPointerException("level is marked non-null but is null");
            }
            this.level = level;
            return this;
        }

        public OperationMeasurementBuilder elapsedStartTimeNanos(long elapsedStartTimeNanos) {
            this.elapsedStartTimeNanos = elapsedStartTimeNanos;
            return this;
        }

        public OperationMeasurementBuilder elapsedCompleteTimeNanos(long elapsedCompleteTimeNanos) {
            this.elapsedCompleteTimeNanos = elapsedCompleteTimeNanos;
            return this;
        }

        public OperationMeasurementBuilder error(Throwable error) {
            this.error = Optional.of(error);
            return this;
        }

        @Override
        protected OperationMeasurement buildCore() {
            Preconditions.checkNotNull(this.operation, "The `operation` must be set.");
            Preconditions.checkArgument(this.elapsedStartTimeNanos >= 0L, "The `elapsedStartTimeNanos` must be set and non-negative.");
            Preconditions.checkArgument(this.elapsedCompleteTimeNanos >= 0L, "The `elapsedCompleteTimeNanos` must be set and non-negative.");
            Preconditions.checkArgument(this.elapsedCompleteTimeNanos >= this.elapsedStartTimeNanos, "The `elapsedCompleteTimeNanos` must be more or equal than `elapsedStartTimeNanos`.");
            return new OperationMeasurement(this.operation, this.level, this.getEpochTimestampNanos(), this.elapsedStartTimeNanos, this.elapsedCompleteTimeNanos, this.error);
        }
    }
}

