/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.impl;

import java.io.IOException;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.StreamContext;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class PhysicalIOImpl
implements PhysicalIO {
    private MetadataStore metadataStore;
    private BlobStore blobStore;
    private final Telemetry telemetry;
    private final StreamContext streamContext;
    private ObjectKey objectKey;
    private final ObjectMetadata metadata;
    private final long physicalIOBirth = System.nanoTime();
    private static final String OPERATION_READ = "physical.io.read";
    private static final String OPERATION_EXECUTE = "physical.io.execute";
    private static final String FLAVOR_TAIL = "tail";
    private static final String FLAVOR_BYTE = "byte";

    public PhysicalIOImpl(@NonNull S3URI s3URI, @NonNull MetadataStore metadataStore, @NonNull BlobStore blobStore, @NonNull Telemetry telemetry) throws IOException {
        this(s3URI, metadataStore, blobStore, telemetry, null);
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (blobStore == null) {
            throw new NullPointerException("blobStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
    }

    public PhysicalIOImpl(@NonNull S3URI s3URI, @NonNull MetadataStore metadataStore, @NonNull BlobStore blobStore, @NonNull Telemetry telemetry, StreamContext streamContext) throws IOException {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (blobStore == null) {
            throw new NullPointerException("blobStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.metadataStore = metadataStore;
        this.blobStore = blobStore;
        this.telemetry = telemetry;
        this.streamContext = streamContext;
        this.metadata = this.metadataStore.get(s3URI);
        this.objectKey = ObjectKey.builder().s3URI(s3URI).etag(this.metadata.getEtag()).build();
    }

    @Override
    public ObjectMetadata metadata() {
        return this.metadata;
    }

    @Override
    public int read(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_BYTE))).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.streamContext).read(pos));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len, long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos + (long)len - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.streamContext).read(buf, off, len, pos));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public int readTail(byte[] buf, int off, int len) throws IOException {
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        long contentLength = this.contentLength();
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_TAIL))).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(contentLength - (long)len, contentLength - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.streamContext).read(buf, off, len, contentLength - (long)len));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public IOPlanExecution execute(IOPlan ioPlan) {
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_EXECUTE)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.ioPlan(ioPlan))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.streamContext).execute(ioPlan));
    }

    private void handleOperationExceptions(Exception e) {
        if (e.getCause() != null && e.getCause().getMessage() != null && (e.getCause().getMessage().contains("Status Code: 412") || e.getCause().getMessage().contains("Error while getting block"))) {
            try {
                this.metadataStore.evictKey(this.objectKey.getS3URI());
            }
            finally {
                this.blobStore.evictKey(this.objectKey);
            }
        }
    }

    private long contentLength() {
        return this.metadata().getContentLength();
    }

    @Override
    public void close() throws IOException {
    }
}

