/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.request.Referrer;
import software.amazon.s3.analyticsaccelerator.request.StreamContext;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;
import software.amazon.s3.analyticsaccelerator.util.StreamUtils;

public class Block
implements Closeable {
    private CompletableFuture<ObjectContent> source;
    private CompletableFuture<byte[]> data;
    private final ObjectKey objectKey;
    private final Range range;
    private final Telemetry telemetry;
    private final ObjectClient objectClient;
    private final StreamContext streamContext;
    private final ReadMode readMode;
    private final Referrer referrer;
    private final long readTimeout;
    private final int readRetryCount;
    private final long start;
    private final long end;
    private final long generation;
    private static final String OPERATION_BLOCK_GET_ASYNC = "block.get.async";
    private static final String OPERATION_BLOCK_GET_JOIN = "block.get.join";
    private static final Logger LOG = LoggerFactory.getLogger(Block.class);

    public Block(@NonNull ObjectKey objectKey, @NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, long start, long end, long generation, @NonNull ReadMode readMode, long readTimeout, int readRetryCount) throws IOException {
        this(objectKey, objectClient, telemetry, start, end, generation, readMode, readTimeout, readRetryCount, null);
        if (objectKey == null) {
            throw new NullPointerException("objectKey is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (readMode == null) {
            throw new NullPointerException("readMode is marked non-null but is null");
        }
    }

    public Block(@NonNull ObjectKey objectKey, @NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, long start, long end, long generation, @NonNull ReadMode readMode, long readTimeout, int readRetryCount, StreamContext streamContext) throws IOException {
        if (objectKey == null) {
            throw new NullPointerException("objectKey is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (readMode == null) {
            throw new NullPointerException("readMode is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= generation, "`generation` must be non-negative; was: %s", generation);
        Preconditions.checkArgument(0L <= start, "`start` must be non-negative; was: %s", start);
        Preconditions.checkArgument(0L <= end, "`end` must be non-negative; was: %s", end);
        Preconditions.checkArgument(start <= end, "`start` must be less than `end`; %s is not less than %s", start, end);
        Preconditions.checkArgument(0L < readTimeout, "`readTimeout` must be greater than 0; was %s", readTimeout);
        Preconditions.checkArgument(0 < readRetryCount, "`readRetryCount` must be greater than 0; was %s", readRetryCount);
        this.start = start;
        this.end = end;
        this.generation = generation;
        this.telemetry = telemetry;
        this.objectKey = objectKey;
        this.range = new Range(start, end);
        this.objectClient = objectClient;
        this.streamContext = streamContext;
        this.readMode = readMode;
        this.referrer = new Referrer(this.range.toHttpString(), readMode);
        this.readTimeout = readTimeout;
        this.readRetryCount = readRetryCount;
        this.generateSourceAndData();
    }

    private void generateSourceAndData() throws IOException {
        int retries = 0;
        while (retries < this.readRetryCount) {
            try {
                GetRequest getRequest = GetRequest.builder().s3Uri(this.objectKey.getS3URI()).range(this.range).etag(this.objectKey.getEtag()).referrer(this.referrer).build();
                this.source = this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_BLOCK_GET_ASYNC)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(this.range))).attribute(StreamAttributes.generation(this.generation))).build(), this.objectClient.getObject(getRequest, this.streamContext));
                this.data = this.source.thenApply(objectContent -> {
                    try {
                        return StreamUtils.toByteArray(objectContent, this.objectKey, this.range, this.readTimeout);
                    }
                    catch (IOException | TimeoutException e) {
                        throw new RuntimeException("Error while converting InputStream to byte array", e);
                    }
                });
                return;
            }
            catch (RuntimeException e) {
                LOG.debug("Retry {}/{} - Failed to fetch block data due to: {}", new Object[]{++retries, this.readRetryCount, e.getMessage()});
                if (retries < this.readRetryCount) continue;
                LOG.error("Max retries reached. Unable to fetch block data.");
                throw new IOException("Failed to fetch block data after retries", e);
            }
        }
    }

    public int read(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        byte[] content = this.getDataWithRetries();
        return Byte.toUnsignedInt(content[this.posToOffset(pos)]);
    }

    public int read(byte @NonNull [] buf, int off, int len, long pos) throws IOException {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        byte[] content = this.getDataWithRetries();
        int contentOffset = this.posToOffset(pos);
        int available = content.length - contentOffset;
        int bytesToCopy = Math.min(len, available);
        for (int i = 0; i < bytesToCopy; ++i) {
            buf[off + i] = content[contentOffset + i];
        }
        return bytesToCopy;
    }

    public boolean contains(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return this.start <= pos && pos <= this.end;
    }

    private int posToOffset(long pos) {
        return (int)(pos - this.start);
    }

    private byte[] getDataWithRetries() throws IOException {
        for (int i = 0; i < this.readRetryCount; ++i) {
            try {
                return this.getData();
            }
            catch (IOException ex) {
                if (ex.getClass() == IOException.class) {
                    if (i >= this.readRetryCount - 1) {
                        LOG.error("Cannot read block file. Retry reached the limit");
                        throw new IOException("Cannot read block file", ex.getCause());
                    }
                } else {
                    throw ex;
                }
                LOG.debug("Get data failed. Retrying. Retry Count {}", (Object)i);
                this.generateSourceAndData();
                continue;
            }
        }
        throw new IOException("Cannot read block file", new IOException("Error while getting block"));
    }

    private byte[] getData() throws IOException {
        return this.telemetry.measureJoinCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_BLOCK_GET_JOIN)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(this.range))).attribute(StreamAttributes.rangeLength(this.range.getLength()))).build(), this.data, this.readTimeout);
    }

    @Override
    public void close() {
        this.source.cancel(false);
    }

    @Generated
    public long getStart() {
        return this.start;
    }

    @Generated
    public long getEnd() {
        return this.end;
    }

    @Generated
    public long getGeneration() {
        return this.generation;
    }
}

