/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import java.io.IOException;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class DefaultLogicalIOImpl
implements LogicalIO {
    private static final String OPERATION_LOGICAL_READ = "logical.read";
    private final S3URI s3URI;
    private final PhysicalIO physicalIO;
    private final Telemetry telemetry;
    private final long birthTimestamp = System.nanoTime();

    public DefaultLogicalIOImpl(@NonNull S3URI s3URI, @NonNull PhysicalIO physicalIO, @NonNull Telemetry telemetry) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.physicalIO = physicalIO;
        this.telemetry = telemetry;
    }

    @Override
    public int read(long position) throws IOException {
        return this.physicalIO.read(position);
    }

    @Override
    public int read(byte[] buf, int off, int len, long position) throws IOException {
        return this.telemetry.measureConditionally(TelemetryLevel.VERBOSE, () -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_LOGICAL_READ)).attribute(StreamAttributes.logicalReadPosition(position))).attribute(StreamAttributes.logicalReadLength(len))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.logicalIORelativeTimestamp(System.nanoTime() - this.birthTimestamp))).build(), () -> this.physicalIO.read(buf, off, len, position), bytesRead -> bytesRead > 1);
    }

    @Override
    public int readTail(byte[] buf, int off, int len) throws IOException {
        long contentLength = this.metadata().getContentLength();
        long startOfRead = Math.max(0L, contentLength - (long)len);
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_LOGICAL_READ)).attribute(StreamAttributes.logicalReadPosition(startOfRead))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.logicalIORelativeTimestamp(System.nanoTime() - this.birthTimestamp))).build(), () -> this.physicalIO.readTail(buf, off, len));
    }

    @Override
    public ObjectMetadata metadata() throws IOException {
        return this.physicalIO.metadata();
    }

    @Override
    public void close() throws IOException {
        this.physicalIO.close();
    }
}

