/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;

public class BlockStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockStore.class);
    private final ObjectKey s3URI;
    private final ObjectMetadata metadata;
    private final List<Block> blocks;

    public BlockStore(ObjectKey objectKey, ObjectMetadata metadata) {
        Preconditions.checkNotNull(objectKey, "`objectKey` must not be null");
        Preconditions.checkNotNull(metadata, "`metadata` must not be null");
        this.s3URI = objectKey;
        this.metadata = metadata;
        this.blocks = new LinkedList<Block>();
    }

    public Optional<Block> getBlock(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return this.blocks.stream().filter(b -> b.contains(pos)).findFirst();
    }

    public OptionalLong findNextLoadedByte(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        if (this.getBlock(pos).isPresent()) {
            return OptionalLong.of(pos);
        }
        return this.blocks.stream().mapToLong(Block::getStart).filter(startPos -> pos < startPos).min();
    }

    public OptionalLong findNextMissingByte(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        long nextMissingByte = pos;
        while (this.getBlock(nextMissingByte).isPresent()) {
            nextMissingByte = this.getBlock(nextMissingByte).get().getEnd() + 1L;
        }
        return nextMissingByte <= this.getLastObjectByte() ? OptionalLong.of(nextMissingByte) : OptionalLong.empty();
    }

    public void add(Block block) {
        Preconditions.checkNotNull(block, "`block` must not be null");
        this.blocks.add(block);
    }

    private long getLastObjectByte() {
        return this.metadata.getContentLength() - 1L;
    }

    private void safeClose(Block block) {
        try {
            block.close();
        }
        catch (Exception e) {
            LOG.error("Exception when closing Block in the BlockStore", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.blocks.forEach(this::safeClose);
    }
}

