/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.util.regex.Pattern;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.util.ObjectFormat;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class ObjectFormatSelector {
    private final Pattern parquetPattern;

    public ObjectFormatSelector(LogicalIOConfiguration configuration) {
        this.parquetPattern = Pattern.compile(configuration.getParquetFormatSelectorRegex(), 2);
    }

    public ObjectFormat getObjectFormat(S3URI s3URI) {
        if (this.parquetPattern.matcher(s3URI.getKey()).find()) {
            return ObjectFormat.PARQUET;
        }
        return ObjectFormat.DEFAULT;
    }
}

