/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Inner class is created very infrequently, and fluency justifies the extra pointer")
public class MetadataStore
implements Closeable {
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final Map<S3URI, CompletableFuture<ObjectMetadata>> cache;
    private static final Logger LOG = LoggerFactory.getLogger(MetadataStore.class);
    private static final String OPERATION_METADATA_HEAD_ASYNC = "metadata.store.head.async";
    private static final String OPERATION_METADATA_HEAD_JOIN = "metadata.store.head.join";

    public MetadataStore(@NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, final @NonNull PhysicalIOConfiguration configuration) {
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.objectClient = objectClient;
        this.telemetry = telemetry;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<S3URI, CompletableFuture<ObjectMetadata>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<S3URI, CompletableFuture<ObjectMetadata>> eldest) {
                return this.size() > configuration.getMetadataStoreCapacity();
            }
        });
    }

    public ObjectMetadata get(S3URI s3URI) throws IOException {
        return this.telemetry.measureJoinCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_METADATA_HEAD_JOIN)).attribute(StreamAttributes.uri(s3URI))).build(), this.asyncGet(s3URI));
    }

    public boolean evictKey(S3URI s3URI) {
        return this.cache.remove(s3URI) != null;
    }

    public synchronized CompletableFuture<ObjectMetadata> asyncGet(S3URI s3URI) {
        return this.cache.computeIfAbsent(s3URI, uri -> this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_METADATA_HEAD_ASYNC)).attribute(StreamAttributes.uri(s3URI))).build(), this.objectClient.headObject(HeadRequest.builder().s3Uri(s3URI).build())));
    }

    public synchronized void storeObjectMetadata(S3URI s3URI, ObjectMetadata objectMetadata) {
        this.cache.put(s3URI, CompletableFuture.completedFuture(objectMetadata));
    }

    private void safeCancel(CompletableFuture<ObjectMetadata> future) {
        if (!future.isDone()) {
            try {
                future.cancel(false);
            }
            catch (Exception e) {
                LOG.error("Error cancelling ObjectMetadata future", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.cache.values().forEach(this::safeCancel);
    }
}

