/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Blob;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockManager;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.StreamContext;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Inner class is created very infrequently, and fluency justifies the extra pointer")
public class BlobStore
implements Closeable {
    private final Map<ObjectKey, Blob> blobMap;
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final PhysicalIOConfiguration configuration;

    public BlobStore(@NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, final @NonNull PhysicalIOConfiguration configuration) {
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.objectClient = objectClient;
        this.telemetry = telemetry;
        this.blobMap = Collections.synchronizedMap(new LinkedHashMap<ObjectKey, Blob>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ObjectKey, Blob> eldest) {
                return this.size() > configuration.getBlobStoreCapacity();
            }
        });
        this.configuration = configuration;
    }

    public Blob get(ObjectKey objectKey, ObjectMetadata metadata, StreamContext streamContext) {
        return this.blobMap.computeIfAbsent(objectKey, uri -> new Blob((ObjectKey)uri, metadata, new BlockManager((ObjectKey)uri, this.objectClient, metadata, this.telemetry, this.configuration, streamContext), this.telemetry));
    }

    public boolean evictKey(ObjectKey objectKey) {
        return this.blobMap.remove(objectKey) != null;
    }

    public int blobCount() {
        return this.blobMap.size();
    }

    @Override
    public void close() {
        this.blobMap.forEach((k, v) -> v.close());
    }
}

