/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.FileTail;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetUtils;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class ParquetReadTailTask {
    private final S3URI s3URI;
    private final Telemetry telemetry;
    private final LogicalIOConfiguration logicalIOConfiguration;
    private final PhysicalIO physicalIO;
    private static final String OPERATION_PARQUET_READ_TAIL = "parquet.task.read.tail";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetReadTailTask.class);

    public ParquetReadTailTask(@NonNull S3URI s3URI, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull PhysicalIO physicalIO) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.telemetry = telemetry;
        this.logicalIOConfiguration = logicalIOConfiguration;
        this.physicalIO = physicalIO;
    }

    public FileTail readFileTail() {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_READ_TAIL)).attribute(StreamAttributes.uri(this.s3URI))).build(), () -> {
            long contentLength = this.physicalIO.metadata().getContentLength();
            Optional<Range> tailRangeOptional = ParquetUtils.getFileTailRange(this.logicalIOConfiguration, 0L, contentLength);
            if (tailRangeOptional.isPresent()) {
                Range tailRange = tailRangeOptional.get();
                int tailLength = (int)tailRange.getLength();
                try {
                    byte[] fileTail = new byte[tailLength];
                    this.physicalIO.readTail(fileTail, 0, tailLength);
                    return new FileTail(ByteBuffer.wrap(fileTail), (int)tailRange.getLength());
                }
                catch (Exception e) {
                    LOG.warn("Unable to read file tail for {}, parquet prefetch optimisations will be disabled for this key.", (Object)this.s3URI.getKey(), (Object)e);
                    throw new CompletionException("Error in getting file tail", e);
                }
            }
            return new FileTail(ByteBuffer.allocate(0), 0);
        });
    }
}

