/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.util.List;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetUtils;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class ParquetPrefetchTailTask {
    private final S3URI s3URI;
    private final Telemetry telemetry;
    private final LogicalIOConfiguration logicalIOConfiguration;
    private final PhysicalIO physicalIO;
    private static final String OPERATION_PARQUET_PREFETCH_TAIL = "parquet.task.prefetch.tail";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetPrefetchTailTask.class);

    public ParquetPrefetchTailTask(@NonNull S3URI s3URI, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull PhysicalIO physicalIO) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.telemetry = telemetry;
        this.logicalIOConfiguration = logicalIOConfiguration;
        this.physicalIO = physicalIO;
    }

    public List<Range> prefetchTail() {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_PREFETCH_TAIL)).attribute(StreamAttributes.uri(this.s3URI))).build(), () -> {
            try {
                long contentLength = this.physicalIO.metadata().getContentLength();
                List<Range> ranges = ParquetUtils.getFileTailPrefetchRanges(this.logicalIOConfiguration, 0L, contentLength);
                IOPlan ioPlan = new IOPlan(ranges);
                this.physicalIO.execute(ioPlan);
                return ioPlan.getPrefetchRanges();
            }
            catch (Exception e) {
                LOG.warn("Unable to prefetch file tail for {}, parquet prefetch optimisations will be disabled for this key.", (Object)this.s3URI.getKey(), (Object)e);
                throw new CompletionException("Error in executing tail prefetch plan", e);
            }
        });
    }
}

