/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.util.PrefetchMode;

public class LogicalIOConfiguration {
    private static final boolean DEFAULT_PREFETCH_FOOTER_ENABLED = true;
    private static final boolean DEFAULT_PREFETCH_PAGE_INDEX_ENABLED = true;
    private static final long DEFAULT_PREFETCH_FILE_METADATA_SIZE = 32768L;
    private static final long DEFAULT_PREFETCH_LARGE_FILE_METADATA_SIZE = 0x100000L;
    private static final long DEFAULT_PREFETCH_FILE_PAGE_INDEX_SIZE = 0x100000L;
    private static final long DEFAULT_PREFETCH_LARGE_FILE_PAGE_INDEX_SIZE = 0x800000L;
    private static final long DEFAULT_LARGE_FILE_SIZE = 0x40000000L;
    private static final boolean DEFAULT_PREFETCHING_SMALL_OBJECT_ENABLED = true;
    private static final long DEFAULT_SMALL_OBJECT_SIZE_THRESHOLD = 0x300000L;
    private static final int DEFAULT_PARQUET_METADATA_STORE_SIZE = 45;
    private static final int DEFAULT_MAX_COLUMN_ACCESS_STORE_SIZE = 15;
    private static final String DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX = "^.*.(parquet|par)$";
    private static final PrefetchMode DEFAULT_PREFETCHING_MODE = PrefetchMode.ROW_GROUP;
    private boolean prefetchFooterEnabled;
    private static final String FOOTER_PREFETCH_ENABLED_KEY = "prefetch.footer.enabled";
    private boolean prefetchPageIndexEnabled;
    private static final String PAGE_INDEX_PREFETCH_ENABLED_KEY = "prefetch.page.index.enabled";
    private long prefetchFileMetadataSize;
    private static final String PREFETCH_FILE_METADATA_SIZE_KEY = "prefetch.file.metadata.size";
    private long prefetchLargeFileMetadataSize;
    private static final String PREFETCH_LARGE_FILE_METADATA_SIZE_KEY = "prefetch.large.file.metadata.size";
    private long prefetchFilePageIndexSize;
    private static final String PREFETCH_FILE_PAGE_INDEX_SIZE_KEY = "prefetch.file.page.index.size";
    private long prefetchLargeFilePageIndexSize;
    private static final String LARGE_FILE_PAGE_INDEX_PREFETCH_SIZE_KEY = "prefetch.large.file.page.index.size";
    private long largeFileSize;
    private static final String LARGE_FILE_SIZE = "large.file.size";
    private boolean smallObjectsPrefetchingEnabled;
    private static final String SMALL_OBJECTS_PREFETCHING_ENABLED_KEY = "small.objects.prefetching.enabled";
    private long smallObjectSizeThreshold;
    private static final String SMALL_OBJECT_SIZE_THRESHOLD_KEY = "small.object.size.threshold";
    private static final String METADATA_AWARE_PREFETCHING_ENABLED_KEY = "metadata.aware.prefetching.enabled";
    private PrefetchMode prefetchingMode;
    private static final String PREFETCHING_MODE_KEY = "prefetching.mode";
    private int parquetMetadataStoreSize;
    private static final String PARQUET_METADATA_STORE_SIZE_KEY = "parquet.metadata.store.size";
    private int maxColumnAccessCountStoreSize;
    private static final String MAX_COLUMN_ACCESS_STORE_SIZE_KEY = "max.column.access.store.size";
    private String parquetFormatSelectorRegex;
    private static final String PARQUET_FORMAT_SELECTOR_REGEX = "parquet.format.selector.regex";
    public static final LogicalIOConfiguration DEFAULT = LogicalIOConfiguration.builder().build();

    public static LogicalIOConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return LogicalIOConfiguration.builder().prefetchFooterEnabled(configuration.getBoolean(FOOTER_PREFETCH_ENABLED_KEY, true)).prefetchPageIndexEnabled(configuration.getBoolean(PAGE_INDEX_PREFETCH_ENABLED_KEY, true)).prefetchFileMetadataSize(configuration.getLong(PREFETCH_FILE_METADATA_SIZE_KEY, 32768L)).prefetchLargeFileMetadataSize(configuration.getLong(PREFETCH_LARGE_FILE_METADATA_SIZE_KEY, 0x100000L)).prefetchFilePageIndexSize(configuration.getLong(PREFETCH_FILE_PAGE_INDEX_SIZE_KEY, 0x100000L)).prefetchLargeFilePageIndexSize(configuration.getLong(LARGE_FILE_PAGE_INDEX_PREFETCH_SIZE_KEY, 0x800000L)).largeFileSize(configuration.getLong(LARGE_FILE_SIZE, 0x40000000L)).smallObjectsPrefetchingEnabled(configuration.getBoolean(SMALL_OBJECTS_PREFETCHING_ENABLED_KEY, true)).smallObjectSizeThreshold(configuration.getLong(SMALL_OBJECT_SIZE_THRESHOLD_KEY, 0x300000L)).parquetMetadataStoreSize(configuration.getInt(PARQUET_METADATA_STORE_SIZE_KEY, 45)).maxColumnAccessCountStoreSize(configuration.getInt(MAX_COLUMN_ACCESS_STORE_SIZE_KEY, 15)).parquetFormatSelectorRegex(configuration.getString(PARQUET_FORMAT_SELECTOR_REGEX, DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX)).prefetchingMode(PrefetchMode.fromString(configuration.getString(PREFETCHING_MODE_KEY, DEFAULT_PREFETCHING_MODE.toString()))).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogicalIO configuration:\n");
        builder.append("\tprefetchFooterEnabled: " + this.prefetchFooterEnabled + "\n");
        builder.append("\tprefetchPageIndexEnabled: " + this.prefetchPageIndexEnabled + "\n");
        builder.append("\tprefetchFileMetadataSize: " + this.prefetchFileMetadataSize + "\n");
        builder.append("\tprefetchLargeFileMetadataSize: " + this.prefetchLargeFileMetadataSize + "\n");
        builder.append("\tprefetchFilePageIndexSize: " + this.prefetchFilePageIndexSize + "\n");
        builder.append("\tprefetchLargeFilePageIndexSize: " + this.prefetchLargeFilePageIndexSize + "\n");
        builder.append("\tlargeFileSize: " + this.largeFileSize + "\n");
        builder.append("\tsmallObjectsPrefetchingEnabled: " + this.smallObjectsPrefetchingEnabled + "\n");
        builder.append("\tsmallObjectSizeThreshold: " + this.smallObjectSizeThreshold + "\n");
        builder.append("\tparquetMetadataStoreSize: " + this.parquetMetadataStoreSize + "\n");
        builder.append("\tmaxColumnAccessCountStoreSize: " + this.maxColumnAccessCountStoreSize + "\n");
        builder.append("\tparquetFormatSelectorRegex: " + this.parquetFormatSelectorRegex + "\n");
        builder.append("\tprefetchingMode: " + (Object)((Object)this.prefetchingMode) + "\n");
        return builder.toString();
    }

    @Generated
    private static boolean $default$prefetchFooterEnabled() {
        return true;
    }

    @Generated
    private static boolean $default$prefetchPageIndexEnabled() {
        return true;
    }

    @Generated
    private static long $default$prefetchFileMetadataSize() {
        return 32768L;
    }

    @Generated
    private static long $default$prefetchLargeFileMetadataSize() {
        return 0x100000L;
    }

    @Generated
    private static long $default$prefetchFilePageIndexSize() {
        return 0x100000L;
    }

    @Generated
    private static long $default$prefetchLargeFilePageIndexSize() {
        return 0x800000L;
    }

    @Generated
    private static long $default$largeFileSize() {
        return 0x40000000L;
    }

    @Generated
    private static boolean $default$smallObjectsPrefetchingEnabled() {
        return true;
    }

    @Generated
    private static long $default$smallObjectSizeThreshold() {
        return 0x300000L;
    }

    @Generated
    private static PrefetchMode $default$prefetchingMode() {
        return DEFAULT_PREFETCHING_MODE;
    }

    @Generated
    private static int $default$parquetMetadataStoreSize() {
        return 45;
    }

    @Generated
    private static int $default$maxColumnAccessCountStoreSize() {
        return 15;
    }

    @Generated
    private static String $default$parquetFormatSelectorRegex() {
        return DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX;
    }

    @Generated
    LogicalIOConfiguration(boolean prefetchFooterEnabled, boolean prefetchPageIndexEnabled, long prefetchFileMetadataSize, long prefetchLargeFileMetadataSize, long prefetchFilePageIndexSize, long prefetchLargeFilePageIndexSize, long largeFileSize, boolean smallObjectsPrefetchingEnabled, long smallObjectSizeThreshold, PrefetchMode prefetchingMode, int parquetMetadataStoreSize, int maxColumnAccessCountStoreSize, String parquetFormatSelectorRegex) {
        this.prefetchFooterEnabled = prefetchFooterEnabled;
        this.prefetchPageIndexEnabled = prefetchPageIndexEnabled;
        this.prefetchFileMetadataSize = prefetchFileMetadataSize;
        this.prefetchLargeFileMetadataSize = prefetchLargeFileMetadataSize;
        this.prefetchFilePageIndexSize = prefetchFilePageIndexSize;
        this.prefetchLargeFilePageIndexSize = prefetchLargeFilePageIndexSize;
        this.largeFileSize = largeFileSize;
        this.smallObjectsPrefetchingEnabled = smallObjectsPrefetchingEnabled;
        this.smallObjectSizeThreshold = smallObjectSizeThreshold;
        this.prefetchingMode = prefetchingMode;
        this.parquetMetadataStoreSize = parquetMetadataStoreSize;
        this.maxColumnAccessCountStoreSize = maxColumnAccessCountStoreSize;
        this.parquetFormatSelectorRegex = parquetFormatSelectorRegex;
    }

    @Generated
    public static LogicalIOConfigurationBuilder builder() {
        return new LogicalIOConfigurationBuilder();
    }

    @Generated
    public boolean isPrefetchFooterEnabled() {
        return this.prefetchFooterEnabled;
    }

    @Generated
    public boolean isPrefetchPageIndexEnabled() {
        return this.prefetchPageIndexEnabled;
    }

    @Generated
    public long getPrefetchFileMetadataSize() {
        return this.prefetchFileMetadataSize;
    }

    @Generated
    public long getPrefetchLargeFileMetadataSize() {
        return this.prefetchLargeFileMetadataSize;
    }

    @Generated
    public long getPrefetchFilePageIndexSize() {
        return this.prefetchFilePageIndexSize;
    }

    @Generated
    public long getPrefetchLargeFilePageIndexSize() {
        return this.prefetchLargeFilePageIndexSize;
    }

    @Generated
    public long getLargeFileSize() {
        return this.largeFileSize;
    }

    @Generated
    public boolean isSmallObjectsPrefetchingEnabled() {
        return this.smallObjectsPrefetchingEnabled;
    }

    @Generated
    public long getSmallObjectSizeThreshold() {
        return this.smallObjectSizeThreshold;
    }

    @Generated
    public PrefetchMode getPrefetchingMode() {
        return this.prefetchingMode;
    }

    @Generated
    public int getParquetMetadataStoreSize() {
        return this.parquetMetadataStoreSize;
    }

    @Generated
    public int getMaxColumnAccessCountStoreSize() {
        return this.maxColumnAccessCountStoreSize;
    }

    @Generated
    public String getParquetFormatSelectorRegex() {
        return this.parquetFormatSelectorRegex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogicalIOConfiguration)) {
            return false;
        }
        LogicalIOConfiguration other = (LogicalIOConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrefetchFooterEnabled() != other.isPrefetchFooterEnabled()) {
            return false;
        }
        if (this.isPrefetchPageIndexEnabled() != other.isPrefetchPageIndexEnabled()) {
            return false;
        }
        if (this.getPrefetchFileMetadataSize() != other.getPrefetchFileMetadataSize()) {
            return false;
        }
        if (this.getPrefetchLargeFileMetadataSize() != other.getPrefetchLargeFileMetadataSize()) {
            return false;
        }
        if (this.getPrefetchFilePageIndexSize() != other.getPrefetchFilePageIndexSize()) {
            return false;
        }
        if (this.getPrefetchLargeFilePageIndexSize() != other.getPrefetchLargeFilePageIndexSize()) {
            return false;
        }
        if (this.getLargeFileSize() != other.getLargeFileSize()) {
            return false;
        }
        if (this.isSmallObjectsPrefetchingEnabled() != other.isSmallObjectsPrefetchingEnabled()) {
            return false;
        }
        if (this.getSmallObjectSizeThreshold() != other.getSmallObjectSizeThreshold()) {
            return false;
        }
        if (this.getParquetMetadataStoreSize() != other.getParquetMetadataStoreSize()) {
            return false;
        }
        if (this.getMaxColumnAccessCountStoreSize() != other.getMaxColumnAccessCountStoreSize()) {
            return false;
        }
        PrefetchMode this$prefetchingMode = this.getPrefetchingMode();
        PrefetchMode other$prefetchingMode = other.getPrefetchingMode();
        if (this$prefetchingMode == null ? other$prefetchingMode != null : !((Object)((Object)this$prefetchingMode)).equals((Object)other$prefetchingMode)) {
            return false;
        }
        String this$parquetFormatSelectorRegex = this.getParquetFormatSelectorRegex();
        String other$parquetFormatSelectorRegex = other.getParquetFormatSelectorRegex();
        return !(this$parquetFormatSelectorRegex == null ? other$parquetFormatSelectorRegex != null : !this$parquetFormatSelectorRegex.equals(other$parquetFormatSelectorRegex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogicalIOConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrefetchFooterEnabled() ? 79 : 97);
        result = result * 59 + (this.isPrefetchPageIndexEnabled() ? 79 : 97);
        long $prefetchFileMetadataSize = this.getPrefetchFileMetadataSize();
        result = result * 59 + (int)($prefetchFileMetadataSize >>> 32 ^ $prefetchFileMetadataSize);
        long $prefetchLargeFileMetadataSize = this.getPrefetchLargeFileMetadataSize();
        result = result * 59 + (int)($prefetchLargeFileMetadataSize >>> 32 ^ $prefetchLargeFileMetadataSize);
        long $prefetchFilePageIndexSize = this.getPrefetchFilePageIndexSize();
        result = result * 59 + (int)($prefetchFilePageIndexSize >>> 32 ^ $prefetchFilePageIndexSize);
        long $prefetchLargeFilePageIndexSize = this.getPrefetchLargeFilePageIndexSize();
        result = result * 59 + (int)($prefetchLargeFilePageIndexSize >>> 32 ^ $prefetchLargeFilePageIndexSize);
        long $largeFileSize = this.getLargeFileSize();
        result = result * 59 + (int)($largeFileSize >>> 32 ^ $largeFileSize);
        result = result * 59 + (this.isSmallObjectsPrefetchingEnabled() ? 79 : 97);
        long $smallObjectSizeThreshold = this.getSmallObjectSizeThreshold();
        result = result * 59 + (int)($smallObjectSizeThreshold >>> 32 ^ $smallObjectSizeThreshold);
        result = result * 59 + this.getParquetMetadataStoreSize();
        result = result * 59 + this.getMaxColumnAccessCountStoreSize();
        PrefetchMode $prefetchingMode = this.getPrefetchingMode();
        result = result * 59 + ($prefetchingMode == null ? 43 : ((Object)((Object)$prefetchingMode)).hashCode());
        String $parquetFormatSelectorRegex = this.getParquetFormatSelectorRegex();
        result = result * 59 + ($parquetFormatSelectorRegex == null ? 43 : $parquetFormatSelectorRegex.hashCode());
        return result;
    }

    @Generated
    public static class LogicalIOConfigurationBuilder {
        @Generated
        private boolean prefetchFooterEnabled$set;
        @Generated
        private boolean prefetchFooterEnabled$value;
        @Generated
        private boolean prefetchPageIndexEnabled$set;
        @Generated
        private boolean prefetchPageIndexEnabled$value;
        @Generated
        private boolean prefetchFileMetadataSize$set;
        @Generated
        private long prefetchFileMetadataSize$value;
        @Generated
        private boolean prefetchLargeFileMetadataSize$set;
        @Generated
        private long prefetchLargeFileMetadataSize$value;
        @Generated
        private boolean prefetchFilePageIndexSize$set;
        @Generated
        private long prefetchFilePageIndexSize$value;
        @Generated
        private boolean prefetchLargeFilePageIndexSize$set;
        @Generated
        private long prefetchLargeFilePageIndexSize$value;
        @Generated
        private boolean largeFileSize$set;
        @Generated
        private long largeFileSize$value;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$set;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$value;
        @Generated
        private boolean smallObjectSizeThreshold$set;
        @Generated
        private long smallObjectSizeThreshold$value;
        @Generated
        private boolean prefetchingMode$set;
        @Generated
        private PrefetchMode prefetchingMode$value;
        @Generated
        private boolean parquetMetadataStoreSize$set;
        @Generated
        private int parquetMetadataStoreSize$value;
        @Generated
        private boolean maxColumnAccessCountStoreSize$set;
        @Generated
        private int maxColumnAccessCountStoreSize$value;
        @Generated
        private boolean parquetFormatSelectorRegex$set;
        @Generated
        private String parquetFormatSelectorRegex$value;

        @Generated
        LogicalIOConfigurationBuilder() {
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchFooterEnabled(boolean prefetchFooterEnabled) {
            this.prefetchFooterEnabled$value = prefetchFooterEnabled;
            this.prefetchFooterEnabled$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchPageIndexEnabled(boolean prefetchPageIndexEnabled) {
            this.prefetchPageIndexEnabled$value = prefetchPageIndexEnabled;
            this.prefetchPageIndexEnabled$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchFileMetadataSize(long prefetchFileMetadataSize) {
            this.prefetchFileMetadataSize$value = prefetchFileMetadataSize;
            this.prefetchFileMetadataSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchLargeFileMetadataSize(long prefetchLargeFileMetadataSize) {
            this.prefetchLargeFileMetadataSize$value = prefetchLargeFileMetadataSize;
            this.prefetchLargeFileMetadataSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchFilePageIndexSize(long prefetchFilePageIndexSize) {
            this.prefetchFilePageIndexSize$value = prefetchFilePageIndexSize;
            this.prefetchFilePageIndexSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchLargeFilePageIndexSize(long prefetchLargeFilePageIndexSize) {
            this.prefetchLargeFilePageIndexSize$value = prefetchLargeFilePageIndexSize;
            this.prefetchLargeFilePageIndexSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder largeFileSize(long largeFileSize) {
            this.largeFileSize$value = largeFileSize;
            this.largeFileSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder smallObjectsPrefetchingEnabled(boolean smallObjectsPrefetchingEnabled) {
            this.smallObjectsPrefetchingEnabled$value = smallObjectsPrefetchingEnabled;
            this.smallObjectsPrefetchingEnabled$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder smallObjectSizeThreshold(long smallObjectSizeThreshold) {
            this.smallObjectSizeThreshold$value = smallObjectSizeThreshold;
            this.smallObjectSizeThreshold$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchingMode(PrefetchMode prefetchingMode) {
            this.prefetchingMode$value = prefetchingMode;
            this.prefetchingMode$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder parquetMetadataStoreSize(int parquetMetadataStoreSize) {
            this.parquetMetadataStoreSize$value = parquetMetadataStoreSize;
            this.parquetMetadataStoreSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder maxColumnAccessCountStoreSize(int maxColumnAccessCountStoreSize) {
            this.maxColumnAccessCountStoreSize$value = maxColumnAccessCountStoreSize;
            this.maxColumnAccessCountStoreSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder parquetFormatSelectorRegex(String parquetFormatSelectorRegex) {
            this.parquetFormatSelectorRegex$value = parquetFormatSelectorRegex;
            this.parquetFormatSelectorRegex$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfiguration build() {
            boolean prefetchFooterEnabled$value = this.prefetchFooterEnabled$value;
            if (!this.prefetchFooterEnabled$set) {
                prefetchFooterEnabled$value = LogicalIOConfiguration.$default$prefetchFooterEnabled();
            }
            boolean prefetchPageIndexEnabled$value = this.prefetchPageIndexEnabled$value;
            if (!this.prefetchPageIndexEnabled$set) {
                prefetchPageIndexEnabled$value = LogicalIOConfiguration.$default$prefetchPageIndexEnabled();
            }
            long prefetchFileMetadataSize$value = this.prefetchFileMetadataSize$value;
            if (!this.prefetchFileMetadataSize$set) {
                prefetchFileMetadataSize$value = LogicalIOConfiguration.$default$prefetchFileMetadataSize();
            }
            long prefetchLargeFileMetadataSize$value = this.prefetchLargeFileMetadataSize$value;
            if (!this.prefetchLargeFileMetadataSize$set) {
                prefetchLargeFileMetadataSize$value = LogicalIOConfiguration.$default$prefetchLargeFileMetadataSize();
            }
            long prefetchFilePageIndexSize$value = this.prefetchFilePageIndexSize$value;
            if (!this.prefetchFilePageIndexSize$set) {
                prefetchFilePageIndexSize$value = LogicalIOConfiguration.$default$prefetchFilePageIndexSize();
            }
            long prefetchLargeFilePageIndexSize$value = this.prefetchLargeFilePageIndexSize$value;
            if (!this.prefetchLargeFilePageIndexSize$set) {
                prefetchLargeFilePageIndexSize$value = LogicalIOConfiguration.$default$prefetchLargeFilePageIndexSize();
            }
            long largeFileSize$value = this.largeFileSize$value;
            if (!this.largeFileSize$set) {
                largeFileSize$value = LogicalIOConfiguration.$default$largeFileSize();
            }
            boolean smallObjectsPrefetchingEnabled$value = this.smallObjectsPrefetchingEnabled$value;
            if (!this.smallObjectsPrefetchingEnabled$set) {
                smallObjectsPrefetchingEnabled$value = LogicalIOConfiguration.$default$smallObjectsPrefetchingEnabled();
            }
            long smallObjectSizeThreshold$value = this.smallObjectSizeThreshold$value;
            if (!this.smallObjectSizeThreshold$set) {
                smallObjectSizeThreshold$value = LogicalIOConfiguration.$default$smallObjectSizeThreshold();
            }
            PrefetchMode prefetchingMode$value = this.prefetchingMode$value;
            if (!this.prefetchingMode$set) {
                prefetchingMode$value = LogicalIOConfiguration.$default$prefetchingMode();
            }
            int parquetMetadataStoreSize$value = this.parquetMetadataStoreSize$value;
            if (!this.parquetMetadataStoreSize$set) {
                parquetMetadataStoreSize$value = LogicalIOConfiguration.$default$parquetMetadataStoreSize();
            }
            int maxColumnAccessCountStoreSize$value = this.maxColumnAccessCountStoreSize$value;
            if (!this.maxColumnAccessCountStoreSize$set) {
                maxColumnAccessCountStoreSize$value = LogicalIOConfiguration.$default$maxColumnAccessCountStoreSize();
            }
            String parquetFormatSelectorRegex$value = this.parquetFormatSelectorRegex$value;
            if (!this.parquetFormatSelectorRegex$set) {
                parquetFormatSelectorRegex$value = LogicalIOConfiguration.$default$parquetFormatSelectorRegex();
            }
            return new LogicalIOConfiguration(prefetchFooterEnabled$value, prefetchPageIndexEnabled$value, prefetchFileMetadataSize$value, prefetchLargeFileMetadataSize$value, prefetchFilePageIndexSize$value, prefetchLargeFilePageIndexSize$value, largeFileSize$value, smallObjectsPrefetchingEnabled$value, smallObjectSizeThreshold$value, prefetchingMode$value, parquetMetadataStoreSize$value, maxColumnAccessCountStoreSize$value, parquetFormatSelectorRegex$value);
        }

        @Generated
        public String toString() {
            return "LogicalIOConfiguration.LogicalIOConfigurationBuilder(prefetchFooterEnabled$value=" + this.prefetchFooterEnabled$value + ", prefetchPageIndexEnabled$value=" + this.prefetchPageIndexEnabled$value + ", prefetchFileMetadataSize$value=" + this.prefetchFileMetadataSize$value + ", prefetchLargeFileMetadataSize$value=" + this.prefetchLargeFileMetadataSize$value + ", prefetchFilePageIndexSize$value=" + this.prefetchFilePageIndexSize$value + ", prefetchLargeFilePageIndexSize$value=" + this.prefetchLargeFilePageIndexSize$value + ", largeFileSize$value=" + this.largeFileSize$value + ", smallObjectsPrefetchingEnabled$value=" + this.smallObjectsPrefetchingEnabled$value + ", smallObjectSizeThreshold$value=" + this.smallObjectSizeThreshold$value + ", prefetchingMode$value=" + (Object)((Object)this.prefetchingMode$value) + ", parquetMetadataStoreSize$value=" + this.parquetMetadataStoreSize$value + ", maxColumnAccessCountStoreSize$value=" + this.maxColumnAccessCountStoreSize$value + ", parquetFormatSelectorRegex$value=" + this.parquetFormatSelectorRegex$value + ")";
        }
    }
}

